// Public domain.

#pragma once

#include "Quake3Font.h"

static int OrbitronMap[128][3] = {
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},     {0, 0, PROP_SPACE_WIDTH},
  {12, 4, 6},     {23, 4, 9},     {37, 4, 20},
  {62, 4, 19},    {86, 4, 24},    {115, 4, 23},
  {143, 4, 6},    {154, 4, 7},    {166, 4, 7},
  {178, 4, 12},   {195, 4, 11},   {211, 4, 5},
  {221, 4, 13},   {239, 4, 6},    {5, 34, 13},
  {23, 34, 21},   {49, 34, 10},   {64, 34, 20},
  {89, 34, 20},   {114, 34, 18},  {137, 34, 20},
  {162, 34, 20},  {187, 34, 16},  {208, 34, 21},
  {5, 64, 20},    {30, 64, 6},    {41, 64, 5},
  {51, 64, 12},   {68, 64, 16},   {89, 64, 12},
  {106, 64, 17},  {128, 64, 20},  {153, 64, 21},
  {179, 64, 20},  {204, 64, 20},  {229, 64, 21},
  {5, 94, 19},    {29, 94, 18},   {52, 94, 20},
  {77, 94, 21},   {103, 94, 6},   {114, 94, 19},
  {138, 94, 20},  {163, 94, 19},  {187, 94, 23},
  {215, 94, 20},  {5, 124, 20},   {30, 124, 19},
  {54, 124, 22},  {81, 124, 20},  {106, 124, 20},
  {131, 124, 19}, {155, 124, 20}, {180, 124, 25},
  {210, 124, 29}, {5, 154, 20},   {30, 154, 20},
  {55, 154, 20},  {80, 154, 7},   {92, 154, 13},
  {110, 154, 7},  {122, 154, 16}, {143, 154, 20},
  {0, 0, -1},     {168, 154, 17}, {190, 154, 17},
  {212, 154, 17}, {234, 154, 17}, {5, 184, 17},
  {27, 184, 10},  {42, 184, 17},  {64, 184, 17},
  {86, 184, 5},   {96, 184, 6},   {107, 184, 16},
  {128, 184, 8},  {141, 184, 24}, {170, 184, 17},
  {192, 184, 17}, {214, 184, 16}, {235, 184, 16},
  {5, 214, 13},   {23, 214, 17},  {45, 214, 10},
  {60, 214, 17},  {82, 214, 19},  {106, 214, 26},
  {137, 214, 17}, {159, 214, 17}, {181, 214, 17},
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},
};

static int UbuntuCondensedMap[128][3] = {
  {0, 0, -1},    {0, 0, -1},    {0, 0, -1},
  {0, 0, -1},    {0, 0, -1},    {0, 0, -1},
  {0, 0, -1},    {0, 0, -1},    {0, 0, -1},
  {0, 0, -1},    {0, 0, -1},    {0, 0, -1},
  {0, 0, -1},    {0, 0, -1},    {0, 0, -1},
  {0, 0, -1},    {0, 0, -1},    {0, 0, -1},
  {0, 0, -1},    {0, 0, -1},    {0, 0, -1},
  {0, 0, -1},    {0, 0, -1},    {0, 0, -1},
  {0, 0, -1},    {0, 0, -1},    {0, 0, -1},
  {0, 0, -1},    {0, 0, -1},    {0, 0, -1},
  {0, 0, -1},    {0, 0, -1},    {0, 0, PROP_SPACE_WIDTH},
  {9, 4, 5},     {19, 4, 7},    {31, 4, 10},
  {46, 4, 7},    {58, 4, 11},   {74, 4, 9},
  {88, 4, 4},    {97, 4, 5},    {107, 4, 5},
  {117, 4, 7},   {129, 4, 7},   {141, 4, 4},
  {150, 4, 4},   {159, 4, 4},   {168, 4, 5},
  {178, 4, 7},   {190, 4, 7},   {202, 4, 7},
  {214, 4, 7},   {226, 4, 7},   {238, 4, 7},
  {5, 28, 7},    {17, 28, 7},   {29, 28, 7},
  {41, 28, 7},   {53, 28, 4},   {62, 28, 4},
  {71, 28, 7},   {83, 28, 7},   {95, 28, 7},
  {107, 28, 6},  {118, 28, 14}, {137, 28, 9},
  {151, 28, 9},  {165, 28, 8},  {178, 28, 10},
  {193, 28, 8},  {206, 28, 7},  {218, 28, 9},
  {232, 28, 10}, {5, 52, 5},    {15, 52, 7},
  {27, 52, 9},   {41, 52, 7},   {53, 52, 12},
  {70, 52, 10},  {85, 52, 10},  {100, 52, 8},
  {113, 52, 10}, {128, 52, 9},  {142, 52, 7},
  {154, 52, 7},  {166, 52, 9},  {180, 52, 8},
  {193, 52, 13}, {211, 52, 8},  {224, 52, 8},
  {237, 52, 7},  {5, 76, 5},    {15, 76, 5},
  {25, 76, 5},   {35, 76, 7},   {47, 76, 6},
  {0, 0, -1},    {58, 76, 7},   {70, 76, 8},
  {83, 76, 6},   {94, 76, 8},   {107, 76, 7},
  {119, 76, 5},  {129, 76, 8},  {142, 76, 8},
  {155, 76, 4},  {164, 76, 4},  {173, 76, 7},
  {185, 76, 4},  {194, 76, 12}, {211, 76, 8},
  {224, 76, 8},  {237, 76, 8},  {5, 100, 8},
  {18, 100, 6},  {29, 100, 6},  {40, 100, 6},
  {51, 100, 8},  {64, 100, 7},  {76, 100, 10},
  {91, 100, 7},  {103, 100, 7}, {115, 100, 6},
  {0, 0, -1},    {0, 0, -1},    {0, 0, -1},
  {0, 0, -1},    {0, 0, -1},
};

static int UbuntuCondensedBigMap[128][3] = {
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},     {0, 0, PROP_SPACE_WIDTH},
  {12, 4, 9},     {26, 4, 13},    {44, 4, 19},
  {68, 4, 14},    {87, 4, 21},    {113, 4, 17},
  {135, 4, 8},    {148, 4, 10},   {163, 4, 10},
  {178, 4, 13},   {196, 4, 14},   {215, 4, 8},
  {228, 4, 8},    {241, 4, 8},    {254, 4, 9},
  {268, 4, 14},   {287, 4, 14},   {306, 4, 14},
  {325, 4, 14},   {344, 4, 14},   {363, 4, 14},
  {382, 4, 14},   {401, 4, 14},   {420, 4, 14},
  {439, 4, 14},   {458, 4, 8},    {471, 4, 8},
  {484, 4, 14},   {5, 52, 14},    {24, 52, 14},
  {43, 52, 11},   {59, 52, 27},   {91, 52, 17},
  {113, 52, 17},  {135, 52, 16},  {156, 52, 19},
  {180, 52, 15},  {200, 52, 14},  {219, 52, 17},
  {241, 52, 19},  {265, 52, 9},   {279, 52, 13},
  {297, 52, 17},  {319, 52, 14},  {338, 52, 24},
  {367, 52, 19},  {391, 52, 20},  {416, 52, 16},
  {437, 52, 20},  {462, 52, 17},  {484, 52, 13},
  {5, 100, 14},   {24, 100, 18},  {47, 100, 16},
  {68, 100, 25},  {98, 100, 16},  {119, 100, 15},
  {139, 100, 14}, {158, 100, 9},  {172, 100, 9},
  {186, 100, 9},  {200, 100, 14}, {219, 100, 12},
  {0, 0, -1},     {236, 100, 14}, {255, 100, 15},
  {275, 100, 12}, {292, 100, 15}, {312, 100, 14},
  {331, 100, 10}, {346, 100, 15}, {366, 100, 16},
  {387, 100, 8},  {400, 100, 8},  {413, 100, 14},
  {432, 100, 8},  {445, 100, 23}, {473, 100, 16},
  {5, 148, 15},   {25, 148, 15},  {45, 148, 15},
  {65, 148, 11},  {81, 148, 11},  {97, 148, 11},
  {113, 148, 16}, {134, 148, 13}, {152, 148, 19},
  {176, 148, 13}, {194, 148, 13}, {212, 148, 12},
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},
};

static int UnsteadyOversteerMap[128][3] = {
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},     {0, 0, PROP_SPACE_WIDTH},
  {17, 4, 6},     {28, 4, 12},    {45, 4, 18},
  {68, 4, 20},    {93, 4, 20},    {118, 4, 20},
  {143, 4, 6},    {154, 4, 9},    {168, 4, 9},
  {182, 4, 18},   {205, 4, 12},   {222, 4, 6},
  {233, 4, 12},   {5, 34, 6},     {16, 34, 20},
  {41, 34, 20},   {66, 34, 6},    {77, 34, 20},
  {102, 34, 20},  {127, 34, 20},  {152, 34, 20},
  {177, 34, 20},  {202, 34, 20},  {227, 34, 20},
  {5, 64, 20},    {30, 64, 6},    {41, 64, 6},
  {52, 64, 20},   {77, 64, 12},   {94, 64, 20},
  {119, 64, 20},  {144, 64, 20},  {169, 64, 20},
  {194, 64, 20},  {219, 64, 20},  {5, 94, 20},
  {30, 94, 20},   {55, 94, 20},   {80, 94, 20},
  {105, 94, 20},  {130, 94, 6},   {141, 94, 20},
  {166, 94, 20},  {191, 94, 6},   {202, 94, 20},
  {227, 94, 20},  {5, 124, 20},   {30, 124, 20},
  {55, 124, 20},  {80, 124, 20},  {105, 124, 20},
  {130, 124, 20}, {155, 124, 20}, {180, 124, 20},
  {205, 124, 20}, {230, 124, 20}, {5, 154, 20},
  {30, 154, 20},  {55, 154, 9},   {69, 154, 20},
  {94, 154, 9},   {108, 154, 20}, {133, 154, 12},
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},     {0, 0, -1},
  {0, 0, -1},     {0, 0, -1},
};

static int SquareFontMap[256][4] = {
  {0, 4, 3, 0},       {0, 0, -1, 0},      {0, 0, -1, 0},
  {0, 0, -1, 0},      {0, 0, -1, 0},      {0, 0, -1, 0},
  {0, 0, -1, 0},      {0, 0, -1, 0},      {0, 0, -1, 0},
  {0, 0, -1, 0},      {0, 0, -1, 0},      {0, 0, -1, 0},
  {0, 0, -1, 0},      {0, 0, -1, 0},      {0, 0, -1, 0},
  {0, 0, -1, 0},      {0, 0, -1, 0},      {0, 0, -1, 0},
  {0, 0, -1, 0},      {0, 0, -1, 0},      {0, 0, -1, 0},
  {0, 0, -1, 0},      {0, 0, -1, 0},      {0, 0, -1, 0},
  {0, 0, -1, 0},      {0, 0, -1, 0},      {0, 0, -1, 0},
  {0, 0, -1, 0},      {0, 0, -1, 0},      {0, 0, -1, 0},
  {0, 0, -1, 0},      {0, 0, -1, 0},      {0, 0, 0, PROP_SPACE_WIDTH},
  {14, 4, 7, 4},      {23, 4, 9, 6},      {34, 4, 13, 10},
  {49, 4, 13, 10},    {64, 4, 16, 13},    {82, 4, 13, 10},
  {97, 4, 7, 4},      {106, 4, 8, 5},     {116, 4, 8, 5},
  {126, 4, 8, 5},     {136, 4, 11, 8},    {149, 4, 7, 4},
  {158, 4, 9, 6},     {169, 4, 7, 4},     {178, 4, 11, 8},
  {191, 4, 13, 10},   {206, 4, 7, 4},     {215, 4, 13, 10},
  {230, 4, 13, 10},   {5, 28, 13, 10},    {20, 28, 13, 10},
  {35, 28, 13, 10},   {50, 28, 13, 10},   {65, 28, 13, 10},
  {80, 28, 13, 10},   {95, 28, 7, 4},     {104, 28, 7, 4},
  {113, 28, 11, 8},   {126, 28, 11, 8},   {139, 28, 11, 8},
  {152, 28, 13, 10},  {167, 28, 13, 10},  {182, 28, 13, 10},
  {197, 28, 13, 10},  {212, 28, 13, 10},  {227, 28, 13, 10},
  {5, 52, 13, 10},    {20, 52, 13, 10},   {35, 52, 13, 10},
  {50, 52, 13, 10},   {65, 52, 7, 4},     {74, 52, 13, 10},
  {89, 52, 13, 10},   {104, 52, 13, 10},  {119, 52, 14, 11},
  {135, 52, 13, 10},  {150, 52, 13, 10},  {165, 52, 13, 10},
  {180, 52, 13, 10},  {195, 52, 13, 10},  {210, 52, 13, 10},
  {225, 52, 13, 10},  {240, 52, 13, 10},  {5, 76, 13, 10},
  {20, 76, 16, 13},   {38, 76, 13, 10},   {53, 76, 13, 10},
  {68, 76, 13, 10},   {83, 76, 8, 5},     {93, 76, 11, 8},
  {106, 76, 8, 5},    {116, 76, 13, 10},  {131, 76, 12, 9},
  {0, 0, -1, 0},      {145, 76, 11, 8},   {158, 76, 11, 8},
  {171, 76, 11, 8},   {184, 76, 11, 8},   {197, 76, 11, 8},
  {210, 76, 11, 8},   {223, 76, 11, 8},   {236, 76, 11, 8},
  {5, 100, 7, 4},     {14, 100, 11, 8},   {27, 100, 11, 8},
  {40, 100, 11, 8},   {53, 100, 12, 9},   {67, 100, 11, 8},
  {80, 100, 11, 8},   {93, 100, 11, 8},   {106, 100, 11, 8},
  {119, 100, 11, 8},  {132, 100, 11, 8},  {145, 100, 11, 8},
  {158, 100, 11, 8},  {171, 100, 11, 8},  {184, 100, 14, 11},
  {200, 100, 11, 8},  {213, 100, 11, 8},  {226, 100, 11, 8},
  {239, 100, 9, 6},   {0, 0, -1, 0},      {5, 124, 9, 6},
  {0, 0, -1, 0},      {0, 0, -1, 0},      {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {16, 124, 13, 10},  {31, 124, 13, 10},  {46, 124, 13, 10},
  {61, 124, 13, 10},  {76, 124, 13, 10},  {91, 124, 13, 10},
  {106, 124, 18, 15}, {126, 124, 13, 10}, {141, 124, 13, 10},
  {156, 124, 13, 10}, {171, 124, 13, 10}, {186, 124, 13, 10},
  {201, 124, 7, 4},   {210, 124, 7, 4},   {219, 124, 8, 5},
  {229, 124, 10, 7},  {5, 148, 14, 11},   {21, 148, 13, 10},
  {36, 148, 13, 10},  {51, 148, 13, 10},  {66, 148, 13, 10},
  {81, 148, 13, 10},  {96, 148, 13, 10},  {0, 0, 0, 0},
  {111, 148, 14, 11}, {127, 148, 13, 10}, {142, 148, 13, 10},
  {157, 148, 13, 10}, {172, 148, 13, 10}, {187, 148, 13, 10},
  {202, 148, 13, 10}, {217, 148, 19, 16}, {238, 148, 11, 8},
  {5, 172, 11, 8},    {18, 172, 11, 8},   {31, 172, 11, 8},
  {44, 172, 11, 8},   {57, 172, 11, 8},   {70, 172, 16, 13},
  {88, 172, 11, 8},   {101, 172, 11, 8},  {114, 172, 11, 8},
  {127, 172, 11, 8},  {140, 172, 11, 8},  {153, 172, 7, 4},
  {162, 172, 7, 4},   {171, 172, 8, 5},   {181, 172, 9, 6},
  {192, 172, 12, 9},  {206, 172, 11, 8},  {219, 172, 11, 8},
  {232, 172, 11, 8},  {5, 196, 11, 8},    {18, 196, 11, 8},
  {31, 196, 11, 8},   {0, 0, 0, 0},       {44, 196, 12, 9},
  {58, 196, 11, 8},   {71, 196, 11, 8},   {84, 196, 11, 8},
  {97, 196, 11, 8},   {110, 196, 11, 8},  {123, 196, 11, 8},
  {136, 196, 11, 8},
};

static int SquareFontBigMap[256][4] = {
  {0, 4, 11, 1},      {0, 0, -1, 0},      {0, 0, -1, 0},
  {0, 0, -1, 0},      {0, 0, -1, 0},      {0, 0, -1, 0},
  {0, 0, -1, 0},      {0, 0, -1, 0},      {0, 0, -1, 0},
  {0, 0, -1, 0},      {0, 0, -1, 0},      {0, 0, -1, 0},
  {0, 0, -1, 0},      {0, 0, -1, 0},      {0, 0, -1, 0},
  {0, 0, -1, 0},      {0, 0, -1, 0},      {0, 0, -1, 0},
  {0, 0, -1, 0},      {0, 0, -1, 0},      {0, 0, -1, 0},
  {0, 0, -1, 0},      {0, 0, -1, 0},      {0, 0, -1, 0},
  {0, 0, -1, 0},      {0, 0, -1, 0},      {0, 0, -1, 0},
  {0, 0, -1, 0},      {0, 0, -1, 0},      {0, 0, -1, 0},
  {0, 0, -1, 0},      {0, 0, -1, 0},      {0, 0, 0, PROP_SPACE_WIDTH},
  {30, 4, 18, 8},     {48, 4, 22, 12},    {70, 4, 29, 19},
  {99, 4, 29, 19},    {128, 4, 35, 25},   {163, 4, 29, 19},
  {192, 4, 17, 7},    {209, 4, 21, 11},   {230, 4, 21, 11},
  {251, 4, 20, 10},   {271, 4, 25, 15},   {296, 4, 18, 8},
  {314, 4, 22, 12},   {336, 4, 18, 8},    {354, 4, 26, 16},
  {380, 4, 29, 19},   {409, 4, 18, 8},    {427, 4, 29, 19},
  {456, 4, 29, 19},   {10, 52, 29, 19},   {39, 52, 29, 19},
  {68, 52, 29, 19},   {97, 52, 29, 19},   {126, 52, 29, 19},
  {155, 52, 29, 19},  {184, 52, 18, 8},   {202, 52, 18, 8},
  {220, 52, 25, 15},  {245, 52, 25, 15},  {270, 52, 25, 15},
  {295, 52, 29, 19},  {324, 52, 29, 19},  {353, 52, 29, 19},
  {382, 52, 29, 19},  {411, 52, 29, 19},  {440, 52, 29, 19},
  {469, 52, 29, 19},  {10, 100, 29, 19},  {39, 100, 29, 19},
  {68, 100, 29, 19},  {97, 100, 18, 8},   {115, 100, 29, 19},
  {144, 100, 29, 19}, {173, 100, 29, 19}, {202, 100, 31, 21},
  {233, 100, 29, 19}, {262, 100, 29, 19}, {291, 100, 29, 19},
  {320, 100, 29, 19}, {349, 100, 29, 19}, {378, 100, 29, 19},
  {407, 100, 29, 19}, {436, 100, 29, 19}, {465, 100, 29, 19},
  {10, 148, 36, 26},  {46, 148, 30, 20},  {76, 148, 29, 19},
  {105, 148, 29, 19}, {134, 148, 21, 11}, {155, 148, 26, 16},
  {181, 148, 21, 11}, {202, 148, 30, 20}, {232, 148, 29, 19},
  {0, 0, -1, 0},      {261, 148, 27, 17}, {288, 148, 27, 17},
  {315, 148, 27, 17}, {342, 148, 27, 17}, {369, 148, 27, 17},
  {396, 148, 27, 17}, {423, 148, 27, 17}, {450, 148, 27, 17},
  {477, 148, 17, 7},  {10, 196, 27, 17},  {37, 196, 27, 17},
  {64, 196, 27, 17},  {91, 196, 28, 18},  {119, 196, 27, 17},
  {146, 196, 27, 17}, {173, 196, 27, 17}, {200, 196, 27, 17},
  {227, 196, 27, 17}, {254, 196, 27, 17}, {281, 196, 27, 17},
  {308, 196, 27, 17}, {335, 196, 27, 17}, {362, 196, 32, 22},
  {394, 196, 27, 17}, {421, 196, 27, 17}, {448, 196, 27, 17},
  {475, 196, 22, 12}, {0, 0, -1, 0},      {10, 244, 22, 12},
  {0, 0, -1, 0},      {0, 0, -1, 0},      {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {32, 244, 29, 19},  {61, 244, 29, 19},  {90, 244, 29, 19},
  {119, 244, 29, 19}, {148, 244, 29, 19}, {177, 244, 29, 19},
  {206, 244, 41, 31}, {247, 244, 29, 19}, {276, 244, 29, 19},
  {305, 244, 29, 19}, {334, 244, 29, 19}, {363, 244, 29, 19},
  {392, 244, 18, 8},  {410, 244, 18, 8},  {428, 244, 21, 11},
  {449, 244, 25, 15}, {474, 244, 32, 22}, {10, 292, 29, 19},
  {39, 292, 29, 19},  {68, 292, 29, 19},  {97, 292, 29, 19},
  {126, 292, 29, 19}, {155, 292, 29, 19}, {0, 0, 0, 0},
  {184, 292, 32, 22}, {216, 292, 29, 19}, {245, 292, 29, 19},
  {274, 292, 29, 19}, {303, 292, 29, 19}, {332, 292, 29, 19},
  {361, 292, 29, 19}, {390, 292, 42, 32}, {432, 292, 27, 17},
  {459, 292, 27, 17}, {10, 340, 27, 17},  {37, 340, 27, 17},
  {64, 340, 27, 17},  {91, 340, 27, 17},  {118, 340, 36, 26},
  {154, 340, 27, 17}, {181, 340, 27, 17}, {208, 340, 27, 17},
  {235, 340, 27, 17}, {262, 340, 27, 17}, {289, 340, 17, 7},
  {306, 340, 17, 7},  {323, 340, 19, 9},  {342, 340, 23, 13},
  {365, 340, 28, 18}, {393, 340, 27, 17}, {420, 340, 27, 17},
  {447, 340, 27, 17}, {474, 340, 27, 17}, {10, 388, 27, 17},
  {37, 388, 27, 17},  {0, 0, 0, 0},       {64, 388, 29, 19},
  {93, 388, 27, 17},  {120, 388, 27, 17}, {147, 388, 27, 17},
  {174, 388, 27, 17}, {201, 388, 27, 17}, {228, 388, 27, 17},
  {255, 388, 27, 17},
};

static int CMUSansCondensedMap[256][4] = {
  {0, 4, 3, 0},       {0, 0, -1, 0},      {0, 0, -1, 0},
  {0, 0, -1, 0},      {0, 0, -1, 0},      {0, 0, -1, 0},
  {0, 0, -1, 0},      {0, 0, -1, 0},      {0, 0, -1, 0},
  {0, 0, -1, 0},      {0, 0, -1, 0},      {0, 0, -1, 0},
  {0, 0, -1, 0},      {0, 0, -1, 0},      {0, 0, -1, 0},
  {0, 0, -1, 0},      {0, 0, -1, 0},      {0, 0, -1, 0},
  {0, 0, -1, 0},      {0, 0, -1, 0},      {0, 0, -1, 0},
  {0, 0, -1, 0},      {0, 0, -1, 0},      {0, 0, -1, 0},
  {0, 0, -1, 0},      {0, 0, -1, 0},      {0, 0, -1, 0},
  {0, 0, -1, 0},      {0, 0, -1, 0},      {0, 0, -1, 0},
  {0, 0, -1, 0},      {0, 0, -1, 0},      {0, 0, 0, PROP_SPACE_WIDTH},
  {16, 4, 8, 5},      {26, 4, 11, 8},     {39, 4, 16, 13},
  {57, 4, 11, 8},     {70, 4, 18, 15},    {90, 4, 15, 12},
  {107, 4, 8, 5},     {117, 4, 9, 6},     {128, 4, 9, 6},
  {139, 4, 11, 8},    {152, 4, 15, 12},   {169, 4, 8, 5},
  {179, 4, 9, 6},     {190, 4, 8, 5},     {200, 4, 11, 8},
  {213, 4, 11, 8},    {226, 4, 11, 8},    {239, 4, 11, 8},
  {5, 28, 11, 8},     {18, 28, 11, 8},    {31, 28, 11, 8},
  {44, 28, 11, 8},    {57, 28, 11, 8},    {70, 28, 11, 8},
  {83, 28, 11, 8},    {96, 28, 8, 5},     {106, 28, 8, 5},
  {116, 28, 15, 12},  {133, 28, 15, 12},  {150, 28, 15, 12},
  {167, 28, 11, 8},   {180, 28, 14, 11},  {196, 28, 14, 11},
  {212, 28, 14, 11},  {228, 28, 13, 10},  {5, 52, 14, 11},
  {21, 52, 13, 10},   {36, 52, 12, 9},    {50, 52, 14, 11},
  {66, 52, 14, 11},   {82, 52, 8, 5},     {92, 52, 11, 8},
  {105, 52, 14, 11},  {121, 52, 12, 9},   {135, 52, 17, 14},
  {154, 52, 14, 11},  {170, 52, 15, 12},  {187, 52, 13, 10},
  {202, 52, 15, 12},  {219, 52, 13, 10},  {234, 52, 12, 9},
  {5, 76, 14, 11},    {21, 76, 14, 11},   {37, 76, 14, 11},
  {53, 76, 18, 15},   {73, 76, 14, 11},   {89, 76, 14, 11},
  {105, 76, 13, 10},  {120, 76, 8, 5},    {130, 76, 11, 8},
  {143, 76, 8, 5},    {153, 76, 13, 10},  {168, 76, 15, 12},
  {185, 76, 11, 8},   {198, 76, 11, 8},   {211, 76, 11, 8},
  {224, 76, 10, 7},   {236, 76, 11, 8},   {5, 100, 11, 8},
  {18, 100, 8, 5},    {28, 100, 11, 8},   {41, 100, 11, 8},
  {54, 100, 7, 4},    {63, 100, 7, 4},    {72, 100, 11, 8},
  {85, 100, 7, 4},    {94, 100, 15, 12},  {111, 100, 11, 8},
  {124, 100, 11, 8},  {137, 100, 11, 8},  {150, 100, 11, 8},
  {163, 100, 9, 6},   {174, 100, 9, 6},   {185, 100, 9, 6},
  {196, 100, 11, 8},  {209, 100, 10, 7},  {221, 100, 14, 11},
  {237, 100, 10, 7},  {5, 124, 10, 7},    {17, 124, 10, 7},
  {29, 124, 11, 8},   {42, 124, 8, 5},    {52, 124, 11, 8},
  {65, 124, 13, 10},  {0, 0, -1, 0},      {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {0, 0, 0, 0},       {0, 0, 0, 0},       {0, 0, 0, 0},
  {80, 124, 14, 11},  {96, 124, 14, 11},  {112, 124, 14, 11},
  {128, 124, 14, 11}, {144, 124, 14, 11}, {160, 124, 14, 11},
  {176, 124, 17, 14}, {195, 124, 13, 10}, {210, 124, 13, 10},
  {225, 124, 13, 10}, {240, 124, 13, 10}, {5, 148, 13, 10},
  {20, 148, 8, 5},    {30, 148, 8, 5},    {40, 148, 8, 5},
  {50, 148, 8, 5},    {60, 148, 14, 11},  {76, 148, 14, 11},
  {92, 148, 15, 12},  {109, 148, 15, 12}, {126, 148, 15, 12},
  {143, 148, 15, 12}, {160, 148, 15, 12}, {0, 0, 0, 0},
  {177, 148, 15, 12}, {194, 148, 14, 11}, {210, 148, 14, 11},
  {226, 148, 14, 11}, {5, 172, 14, 11},   {21, 172, 14, 11},
  {37, 172, 12, 9},   {51, 172, 11, 8},   {64, 172, 11, 8},
  {77, 172, 11, 8},   {90, 172, 11, 8},   {103, 172, 11, 8},
  {116, 172, 11, 8},  {129, 172, 11, 8},  {142, 172, 14, 11},
  {158, 172, 10, 7},  {170, 172, 11, 8},  {183, 172, 11, 8},
  {196, 172, 11, 8},  {209, 172, 11, 8},  {222, 172, 7, 4},
  {231, 172, 7, 4},   {240, 172, 7, 4},   {5, 196, 8, 5},
  {15, 196, 11, 8},   {28, 196, 11, 8},   {41, 196, 11, 8},
  {54, 196, 11, 8},   {67, 196, 11, 8},   {80, 196, 11, 8},
  {93, 196, 11, 8},   {0, 0, 0, 0},       {106, 196, 11, 8},
  {119, 196, 11, 8},  {132, 196, 11, 8},  {145, 196, 11, 8},
  {158, 196, 11, 8},  {171, 196, 10, 7},  {183, 196, 11, 8},
  {196, 196, 10, 7},
};