/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.draw;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import mindustry.gen.Building;
import mindustry.world.draw.DrawBlock;

public class DrawSpikes
extends DrawBlock {
    public Color color = Color.valueOf("7457ce");
    public int amount = 10;
    public int layers = 1;
    public float stroke = 2.0f;
    public float rotateSpeed = 0.8f;
    public float radius = 6.0f;
    public float length = 4.0f;
    public float x = 0.0f;
    public float y = 0.0f;
    public float layerSpeed = -1.0f;

    public DrawSpikes(Color color) {
        this.color = color;
    }

    public DrawSpikes() {
    }

    @Override
    public void draw(Building build) {
        if (build.warmup() <= 0.001f) {
            return;
        }
        Draw.color(this.color, build.warmup() * this.color.a);
        Lines.stroke(this.stroke);
        float curSpeed = 1.0f;
        for (int i = 0; i < this.layers; ++i) {
            Lines.spikes(build.x + this.x, build.y + this.y, this.radius, this.length, this.amount, build.totalProgress() * this.rotateSpeed * curSpeed);
            curSpeed *= this.layerSpeed;
        }
        Draw.reset();
    }
}

