/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.draw;

import arc.Core;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Eachable;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.blocks.heat.HeatBlock;
import mindustry.world.draw.DrawBlock;

public class DrawHeatOutput
extends DrawBlock {
    public TextureRegion heat;
    public TextureRegion glow;
    public TextureRegion top1;
    public TextureRegion top2;
    public Color heatColor = new Color(1.0f, 0.22f, 0.22f, 0.8f);
    public float heatPulse = 0.3f;
    public float heatPulseScl = 10.0f;
    public float glowMult = 1.2f;
    public int rotOffset = 0;
    public boolean drawGlow = true;

    public DrawHeatOutput() {
    }

    public DrawHeatOutput(int rotOffset, boolean drawGlow) {
        this.rotOffset = rotOffset;
        this.drawGlow = drawGlow;
    }

    @Override
    public void draw(Building build) {
        HeatBlock heater;
        float rotdeg = (build.rotation + this.rotOffset) * 90;
        Draw.rect(Mathf.mod(build.rotation + this.rotOffset, 4) > 1 ? this.top2 : this.top1, build.x, build.y, rotdeg);
        if (build instanceof HeatBlock && (heater = (HeatBlock)((Object)build)).heat() > 0.0f) {
            Draw.z(31.0f);
            Draw.blend(Blending.additive);
            Draw.color(this.heatColor, heater.heatFrac() * (this.heatColor.a * (1.0f - this.heatPulse + Mathf.absin(this.heatPulseScl, this.heatPulse))));
            if (this.heat.found()) {
                Draw.rect(this.heat, build.x, build.y, rotdeg);
            }
            Draw.color(Draw.getColor().mul(this.glowMult));
            if (this.drawGlow && this.glow.found()) {
                Draw.rect(this.glow, build.x, build.y);
            }
            Draw.blend();
            Draw.color();
        }
    }

    @Override
    public void drawPlan(Block block, BuildPlan plan, Eachable<BuildPlan> list) {
        Draw.rect(Mathf.mod(plan.rotation + this.rotOffset, 4) > 1 ? this.top2 : this.top1, plan.drawx(), plan.drawy(), (float)((plan.rotation + this.rotOffset) * 90));
    }

    @Override
    public void load(Block block) {
        this.heat = Core.atlas.find(block.name + "-heat");
        this.glow = Core.atlas.find(block.name + "-glow");
        this.top1 = Core.atlas.find(block.name + "-top1");
        this.top2 = Core.atlas.find(block.name + "-top2");
    }
}

