/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.environment;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.math.Mathf;
import arc.math.geom.Point2;
import arc.struct.EnumSet;
import arc.util.Time;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.graphics.Pal;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.meta.BlockFlag;

public class SteamVent
extends Floor {
    public static final Point2[] offsets;
    public Block parent = Blocks.air;
    public Effect effect = Fx.ventSteam;
    public Color effectColor = Pal.vent;
    public float effectSpacing = 15.0f;

    public SteamVent(String name) {
        super(name);
        this.variants = 2;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.steamVent});
    }

    @Override
    public void drawMain(Tile tile) {
        Block block = this.parent;
        if (block instanceof Floor) {
            Floor floor = (Floor)block;
            floor.drawMain(tile);
        }
        if (this.checkAdjacent(tile)) {
            Draw.rect(this.variantRegions[Mathf.randomSeed((long)tile.pos(), 0, Math.max(0, this.variantRegions.length - 1))], tile.worldx() - 8.0f, tile.worldy() - 8.0f);
        }
    }

    @Override
    public boolean updateRender(Tile tile) {
        return this.checkAdjacent(tile);
    }

    @Override
    public boolean shouldIndex(Tile tile) {
        return this.isCenterVent(tile);
    }

    public boolean isCenterVent(Tile tile) {
        Tile topRight = tile.nearby(1, 1);
        return topRight != null && topRight.floor() == tile.floor() && this.checkAdjacent(topRight);
    }

    @Override
    public void renderUpdate(Floor.UpdateRenderState state) {
        if (state.tile.nearby(-1, -1) != null && state.tile.nearby(-1, -1).block() == Blocks.air) {
            float f;
            state.data += Time.delta;
            if (f >= this.effectSpacing) {
                this.effect.at((float)(state.tile.x * 8 - 8), (float)(state.tile.y * 8 - 8), this.effectColor);
                state.data = 0.0f;
            }
        }
    }

    public boolean checkAdjacent(Tile tile) {
        for (Point2 point : offsets) {
            Tile other = Vars.world.tile(tile.x + point.x, tile.y + point.y);
            if (other != null && other.floor() == this) continue;
            return false;
        }
        return true;
    }

    static {
        for (Point2 p : offsets = new Point2[]{new Point2(0, 0), new Point2(1, 0), new Point2(1, 1), new Point2(0, 1), new Point2(-1, 1), new Point2(-1, 0), new Point2(-1, -1), new Point2(0, -1), new Point2(1, -1)}) {
            p.sub(1, 1);
        }
    }
}

