/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense;

import arc.Core;
import arc.audio.Sound;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Time;
import mindustry.Vars;
import mindustry.entities.Lightning;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Sounds;
import mindustry.graphics.Pal;
import mindustry.world.Block;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class Wall
extends Block {
    public float lightningChance = -1.0f;
    public float lightningDamage = 20.0f;
    public int lightningLength = 17;
    public Color lightningColor = Pal.surge;
    public Sound lightningSound = Sounds.spark;
    public float chanceDeflect = -1.0f;
    public boolean flashHit;
    public Color flashColor = Color.white;
    public Sound deflectSound = Sounds.none;

    public Wall(String name) {
        super(name);
        this.solid = true;
        this.destructible = true;
        this.group = BlockGroup.walls;
        this.buildCostMultiplier = 6.0f;
        this.canOverdrive = false;
        this.drawDisabled = false;
        this.crushDamageMultiplier = 5.0f;
        this.priority = -3.0f;
        this.envEnabled = -1;
    }

    @Override
    public void setStats() {
        super.setStats();
        if (this.chanceDeflect > 0.0f) {
            this.stats.add(Stat.baseDeflectChance, this.chanceDeflect, StatUnit.none);
        }
        if (this.lightningChance > 0.0f) {
            this.stats.add(Stat.lightningChance, this.lightningChance * 100.0f, StatUnit.percent);
            this.stats.add(Stat.lightningDamage, this.lightningDamage, StatUnit.none);
        }
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{Core.atlas.find(Core.atlas.has(this.name) ? this.name : this.name + "1")};
    }

    public class WallBuild
    extends Building {
        public float hit;

        @Override
        public void draw() {
            super.draw();
            if (Wall.this.flashHit) {
                if (this.hit < 1.0E-4f) {
                    return;
                }
                Draw.color(Wall.this.flashColor);
                Draw.alpha(this.hit * 0.5f);
                Draw.blend(Blending.additive);
                Fill.rect(this.x, this.y, 8 * Wall.this.size, 8 * Wall.this.size);
                Draw.blend();
                Draw.reset();
                if (!Vars.state.isPaused()) {
                    this.hit = Mathf.clamp(this.hit - Time.delta / 10.0f);
                }
            }
        }

        @Override
        public boolean collision(Bullet bullet) {
            super.collision(bullet);
            this.hit = 1.0f;
            if (Wall.this.lightningChance > 0.0f && Mathf.chance(Wall.this.lightningChance)) {
                Lightning.create(this.team, Wall.this.lightningColor, Wall.this.lightningDamage, this.x, this.y, bullet.rotation() + 180.0f, Wall.this.lightningLength);
                Wall.this.lightningSound.at(this.tile, Mathf.random(0.9f, 1.1f));
            }
            if (Wall.this.chanceDeflect > 0.0f) {
                if (bullet.vel.len() <= 0.1f || !bullet.type.reflectable) {
                    return true;
                }
                if (!Mathf.chance(Wall.this.chanceDeflect / bullet.damage())) {
                    return true;
                }
                Wall.this.deflectSound.at(this.tile, Mathf.random(0.9f, 1.1f));
                bullet.trns(-bullet.vel.x, -bullet.vel.y);
                float penX = Math.abs(this.x - bullet.x);
                float penY = Math.abs(this.y - bullet.y);
                if (penX > penY) {
                    bullet.vel.x *= -1.0f;
                } else {
                    bullet.vel.y *= -1.0f;
                }
                bullet.owner = this;
                bullet.team = this.team;
                bullet.time += 1.0f;
                return false;
            }
            return true;
        }
    }
}

