/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense;

import arc.audio.Sound;
import arc.func.Boolf;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Rect;
import arc.struct.Seq;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Sounds;
import mindustry.gen.Unit;
import mindustry.logic.LAccess;
import mindustry.world.Tile;
import mindustry.world.blocks.defense.Wall;

public class AutoDoor
extends Wall {
    protected static final Rect rect = new Rect();
    protected static final Seq<Unit> units = new Seq();
    protected static final Boolf<Unit> groundCheck = u -> u.isGrounded() && !u.type.allowLegStep;
    public final int timerToggle;
    public float checkInterval;
    public Effect openfx;
    public Effect closefx;
    public Sound doorSound;
    public TextureRegion openRegion;
    public float triggerMargin;

    public AutoDoor(String name) {
        super(name);
        this.timerToggle = this.timers++;
        this.checkInterval = 20.0f;
        this.openfx = Fx.dooropen;
        this.closefx = Fx.doorclose;
        this.doorSound = Sounds.door;
        this.triggerMargin = 12.0f;
        this.solid = false;
        this.solidifes = true;
        this.update = true;
        this.teamPassable = true;
        this.noUpdateDisabled = true;
        this.drawDisabled = true;
    }

    public static void autoDoorToggle(Tile tile, boolean open) {
        Building building;
        if (tile == null || !((building = tile.build) instanceof AutoDoorBuild)) {
            return;
        }
        AutoDoorBuild build = (AutoDoorBuild)building;
        build.setOpen(open);
    }

    public class AutoDoorBuild
    extends Building {
        public boolean open = false;

        public AutoDoorBuild() {
            this.timer.reset(AutoDoor.this.timerToggle, Mathf.random(AutoDoor.this.checkInterval));
        }

        @Override
        public void updateTile() {
            if (this.timer(AutoDoor.this.timerToggle, AutoDoor.this.checkInterval) && !Vars.net.client()) {
                units.clear();
                this.team.data().tree().intersect(rect.setSize((float)(AutoDoor.this.size * 8) + AutoDoor.this.triggerMargin * 2.0f).setCenter(this.x, this.y), units);
                boolean shouldOpen = units.contains((Unit)((Object)groundCheck));
                if (this.open != shouldOpen) {
                    Call.autoDoorToggle(this.tile, shouldOpen);
                }
            }
        }

        @Override
        public double sense(LAccess sensor) {
            if (sensor == LAccess.enabled) {
                return this.open ? 1.0 : 0.0;
            }
            return super.sense(sensor);
        }

        public void setOpen(boolean open) {
            this.open = open;
            Vars.pathfinder.updateTile(this.tile);
            if (this.wasVisible) {
                (!open ? AutoDoor.this.closefx : AutoDoor.this.openfx).at((Position)this, (float)AutoDoor.this.size);
                AutoDoor.this.doorSound.at(this);
            }
        }

        @Override
        public void draw() {
            Draw.rect(this.open ? AutoDoor.this.openRegion : AutoDoor.this.region, this.x, this.y);
        }

        @Override
        public boolean checkSolid() {
            return !this.open;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.bool(this.open);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.open = read.bool();
        }
    }
}

