/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.input.KeyCode;
import arc.math.Mathf;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Button;
import arc.scene.ui.Dialog;
import arc.scene.ui.Image;
import arc.scene.ui.ImageButton;
import arc.scene.ui.Label;
import arc.scene.ui.TextButton;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.scene.utils.Elem;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.Scaling;
import arc.util.Strings;
import java.util.regex.Pattern;
import mindustry.Vars;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.game.Schematic;
import mindustry.game.Schematics;
import mindustry.gen.Icon;
import mindustry.gen.Iconc;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.input.Binding;
import mindustry.type.ItemSeq;
import mindustry.type.ItemStack;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.world.blocks.storage.CoreBlock;

public class SchematicsDialog
extends BaseDialog {
    private static final float tagh = 42.0f;
    private SchematicInfoDialog info = new SchematicInfoDialog();
    private Schematic firstSchematic;
    private String search = "";
    private TextField searchField;
    private Runnable rebuildPane = () -> {};
    private Runnable rebuildTags = () -> {};
    private Pattern ignoreSymbols = Pattern.compile("[`~!@#$%^&*()\\-_=+{}|;:'\",<.>/?]");
    private Seq<String> tags;
    private Seq<String> selectedTags = new Seq();
    private boolean checkedTags;

    public SchematicsDialog() {
        super("@schematics");
        Core.assets.load((String)"sprites/schematic-background.png", Texture.class).loaded = t -> t.setWrap(Texture.TextureWrap.repeat);
        this.tags = Core.settings.getJson("schematic-tags", Seq.class, String.class, Seq::new);
        this.shouldPause = true;
        this.addCloseButton();
        this.buttons.button("@schematic.import", Icon.download, this::showImport);
        this.makeButtonOverlay();
        this.shown(this::setup);
        this.onResize(this::setup);
    }

    void setup() {
        if (!this.checkedTags) {
            this.checkTags();
            this.checkedTags = true;
        }
        this.search = "";
        this.cont.top();
        this.cont.clear();
        this.cont.table((Table s) -> {
            s.left();
            s.image(Icon.zoom);
            this.searchField = s.field(this.search, res -> {
                this.search = res;
                this.rebuildPane.run();
            }).growX().get();
            this.searchField.setMessageText("@schematic.search");
            this.searchField.clicked(KeyCode.mouseRight, () -> {
                if (!this.search.isEmpty()) {
                    this.search = "";
                    this.searchField.clearText();
                    this.rebuildPane.run();
                }
            });
        }).fillX().padBottom(4.0f);
        this.cont.row();
        this.cont.table((Table in) -> {
            in.left();
            in.add("@schematic.tags").padRight(4.0f);
            in.pane(Styles.noBarPane, (Table t) -> {
                this.rebuildTags = () -> {
                    t.clearChildren();
                    t.left();
                    t.defaults().pad(2.0f).height(42.0f);
                    for (String tag : this.tags) {
                        t.button(tag, Styles.togglet, () -> {
                            if (this.selectedTags.contains(tag)) {
                                this.selectedTags.remove(tag);
                            } else {
                                this.selectedTags.add(tag);
                            }
                            this.rebuildPane.run();
                        }).checked(this.selectedTags.contains(tag)).with(c -> c.getLabel().setWrap(false));
                    }
                };
                this.rebuildTags.run();
            }).fillX().height(42.0f).scrollY(false);
            in.button(Icon.pencilSmall, this::showAllTags).size(42.0f).pad(2.0f).tooltip("@schematic.edittags");
        }).height(42.0f).fillX();
        this.cont.row();
        this.cont.pane((Table t) -> {
            t.top();
            t.update(() -> {
                if (Core.input.keyTap(Binding.chat) && Core.scene.getKeyboardFocus() == this.searchField && this.firstSchematic != null) {
                    if (!Vars.state.rules.schematicsAllowed) {
                        Vars.ui.showInfo("@schematic.disabled");
                    } else {
                        Vars.control.input.useSchematic(this.firstSchematic);
                        this.hide();
                    }
                }
            });
            this.rebuildPane = () -> {
                int cols = Math.max((int)((float)Core.graphics.getWidth() / Scl.scl(230.0f)), 1);
                t.clear();
                int i = 0;
                String searchString = this.ignoreSymbols.matcher(this.search.toLowerCase()).replaceAll("");
                this.firstSchematic = null;
                for (Schematic s : Vars.schematics.all()) {
                    if (this.selectedTags.any() && !s.labels.containsAll(this.selectedTags) || !this.search.isEmpty() && !this.ignoreSymbols.matcher(s.name().toLowerCase()).replaceAll("").contains(searchString)) continue;
                    if (this.firstSchematic == null) {
                        this.firstSchematic = s;
                    }
                    Button[] sel = new Button[]{null};
                    sel[0] = t.button((Button b) -> {
                        b.top();
                        b.margin(0.0f);
                        b.table((Table buttons) -> {
                            buttons.left();
                            buttons.defaults().size(50.0f);
                            ImageButton.ImageButtonStyle style = Styles.emptyi;
                            buttons.button((Drawable)Icon.info, style, () -> this.showInfo(s)).tooltip("@info.title");
                            buttons.button((Drawable)Icon.upload, style, () -> this.showExport(s)).tooltip("@editor.export");
                            buttons.button((Drawable)Icon.pencil, style, () -> this.showEdit(s)).tooltip("@schematic.edit");
                            if (s.hasSteamID()) {
                                buttons.button((Drawable)Icon.link, style, () -> Vars.platform.viewListing(s)).tooltip("@view.workshop");
                            } else {
                                buttons.button((Drawable)Icon.trash, style, () -> {
                                    if (s.mod != null) {
                                        Vars.ui.showInfo(Core.bundle.format("mod.item.remove", s.mod.meta.displayName));
                                    } else {
                                        Vars.ui.showConfirm("@confirm", "@schematic.delete.confirm", () -> {
                                            Vars.schematics.remove(s);
                                            this.rebuildPane.run();
                                        });
                                    }
                                }).tooltip("@save.delete");
                            }
                        }).growX().height(50.0f);
                        b.row();
                        b.stack(new SchematicImage(s).setScaling(Scaling.fit), new Table(n -> {
                            n.top();
                            n.table(Styles.black3, c -> {
                                Label label = c.add(s.name()).style(Styles.outlineLabel).color(Color.white).top().growX().maxWidth(192.0f).get();
                                label.setEllipsis(true);
                                label.setAlignment(1);
                            }).growX().margin(1.0f).pad(4.0f).maxWidth(Scl.scl(192.0f)).padBottom(0.0f);
                        })).size(200.0f);
                    }, () -> {
                        if (sel[0].childrenPressed()) {
                            return;
                        }
                        if (Vars.state.isMenu()) {
                            this.showInfo(s);
                        } else if (!Vars.state.rules.schematicsAllowed) {
                            Vars.ui.showInfo("@schematic.disabled");
                        } else {
                            Vars.control.input.useSchematic(s);
                            this.hide();
                        }
                    }).pad(4.0f).style(Styles.flati).get();
                    sel[0].getStyle().up = Tex.pane;
                    if (++i % cols != 0) continue;
                    t.row();
                }
                if (this.firstSchematic == null) {
                    if (!searchString.isEmpty() || this.selectedTags.any()) {
                        t.add("@none.found");
                    } else {
                        t.add("@none").color(Color.lightGray);
                    }
                }
            };
            this.rebuildPane.run();
        }).grow().scrollX(false);
    }

    public void showInfo(Schematic schematic) {
        this.info.show(schematic);
    }

    public void showImport() {
        BaseDialog dialog = new BaseDialog("@editor.import");
        dialog.cont.pane((Table p) -> {
            p.margin(10.0f);
            p.table(Tex.button, t -> {
                TextButton.TextButtonStyle style = Styles.flatt;
                t.defaults().size(280.0f, 60.0f).left();
                t.row();
                t.button("@schematic.copy.import", (Drawable)Icon.copy, style, () -> {
                    dialog.hide();
                    try {
                        Schematic s = Schematics.readBase64(Core.app.getClipboardText());
                        s.removeSteamID();
                        Vars.schematics.add(s);
                        this.setup();
                        Vars.ui.showInfoFade("@schematic.saved");
                        this.checkTags(s);
                        this.showInfo(s);
                    }
                    catch (Throwable e) {
                        Vars.ui.showException(e);
                    }
                }).marginLeft(12.0f).disabled(b -> Core.app.getClipboardText() == null || !Core.app.getClipboardText().startsWith("bXNjaA"));
                t.row();
                t.button("@schematic.importfile", (Drawable)Icon.download, style, () -> Vars.platform.showFileChooser(true, "msch", file -> {
                    dialog.hide();
                    try {
                        Schematic s = Schematics.read(file);
                        s.removeSteamID();
                        Vars.schematics.add(s);
                        this.setup();
                        this.showInfo(s);
                        this.checkTags(s);
                    }
                    catch (Exception e) {
                        Vars.ui.showException(e);
                    }
                })).marginLeft(12.0f);
                t.row();
                if (Vars.steam) {
                    t.button("@schematic.browseworkshop", (Drawable)Icon.book, style, () -> {
                        dialog.hide();
                        Vars.platform.openWorkshop();
                    }).marginLeft(12.0f);
                }
            });
        });
        dialog.addCloseButton();
        dialog.show();
    }

    public void showExport(Schematic s) {
        BaseDialog dialog = new BaseDialog("@editor.export");
        dialog.cont.pane((Table p) -> {
            p.margin(10.0f);
            p.table(Tex.button, t -> {
                TextButton.TextButtonStyle style = Styles.flatt;
                t.defaults().size(280.0f, 60.0f).left();
                if (Vars.steam && !s.hasSteamID()) {
                    t.button("@schematic.shareworkshop", (Drawable)Icon.book, style, () -> Vars.platform.publish(s)).marginLeft(12.0f);
                    t.row();
                    dialog.hide();
                }
                t.button("@schematic.copy", (Drawable)Icon.copy, style, () -> {
                    dialog.hide();
                    Vars.ui.showInfoFade("@copied");
                    Core.app.setClipboardText(Vars.schematics.writeBase64(s));
                }).marginLeft(12.0f);
                t.row();
                t.button("@schematic.exportfile", (Drawable)Icon.export, style, () -> {
                    dialog.hide();
                    Vars.platform.export(s.name(), "msch", file -> Schematics.write(s, file));
                }).marginLeft(12.0f);
            });
        });
        dialog.addCloseButton();
        dialog.show();
    }

    public void showEdit(final Schematic s) {
        new BaseDialog("@schematic.edit"){
            {
                super(title);
                this.setFillParent(true);
                this.addCloseListener();
                this.cont.margin(30.0f);
                this.cont.add("@schematic.tags").padRight(6.0f);
                this.cont.table((Table tags) -> SchematicsDialog.this.buildTags(s, (Table)tags, false)).maxWidth(400.0f).fillX().left().row();
                this.cont.margin(30.0f).add("@name").padRight(6.0f);
                TextField nameField = this.cont.field(s.name(), null).size(400.0f, 55.0f).left().get();
                this.cont.row();
                this.cont.margin(30.0f).add("@editor.description").padRight(6.0f);
                TextField descField = this.cont.area(s.description(), Styles.areaField, t -> {}).size(400.0f, 140.0f).left().get();
                Runnable accept = () -> {
                    s2.tags.put("name", nameField.getText());
                    s2.tags.put("description", descField.getText());
                    s.save();
                    this.hide();
                    SchematicsDialog.this.rebuildPane.run();
                };
                this.buttons.defaults().size(210.0f, 64.0f).pad(4.0f);
                this.buttons.button("@ok", Icon.ok, accept).disabled(b -> nameField.getText().isEmpty());
                this.buttons.button("@cancel", Icon.cancel, this::hide);
                this.keyDown(KeyCode.enter, () -> {
                    if (!nameField.getText().isEmpty() && Core.scene.getKeyboardFocus() != descField) {
                        accept.run();
                    }
                });
            }
        }.show();
    }

    void checkTags() {
        ObjectSet<String> encountered = new ObjectSet<String>();
        encountered.addAll(this.tags);
        for (Schematic s : Vars.schematics.all()) {
            for (String tag : s.labels) {
                if (!encountered.add(tag)) continue;
                this.tags.add(tag);
            }
        }
    }

    void checkTags(Schematic s) {
        boolean any = false;
        for (String tag : s.labels) {
            if (this.tags.contains(tag)) continue;
            this.tags.add(tag);
            any = true;
        }
        if (any) {
            this.rebuildTags.run();
        }
    }

    void tagsChanged() {
        this.rebuildTags.run();
        if (this.selectedTags.any()) {
            this.rebuildPane.run();
        }
        Core.settings.putJson("schematic-tags", String.class, this.tags);
    }

    void addTag(Schematic s, String tag) {
        s.labels.add(tag);
        s.save();
        this.tagsChanged();
    }

    void removeTag(Schematic s, String tag) {
        s.labels.remove(tag);
        s.save();
        this.tagsChanged();
    }

    void showNewTag(Cons<String> result) {
        Vars.ui.showTextInput("@schematic.addtag", "", "", out -> {
            if (this.tags.contains((String)out)) {
                Vars.ui.showInfo("@schematic.tagexists");
            } else {
                this.tags.add((String)out);
                this.tagsChanged();
                result.get((String)out);
            }
        });
    }

    void showNewIconTag(final Cons<String> cons) {
        new Dialog(){
            {
                this.closeOnBack();
                this.setFillParent(true);
                this.cont.pane((Table t) -> this.resized(true, () -> {
                    t.clearChildren();
                    t.marginRight(19.0f).marginLeft(12.0f);
                    t.defaults().size(48.0f);
                    int cols = (int)Math.min(20.0f, (float)Core.graphics.getWidth() / Scl.scl(52.0f));
                    int i = 0;
                    for (String string : Vars.accessibleIcons) {
                        String out = (char)Iconc.codes.get(string) + "";
                        if (SchematicsDialog.this.tags.contains(out)) continue;
                        t.button(Icon.icons.get(string), Styles.flati, 32.0f, () -> {
                            SchematicsDialog.this.tags.add(out);
                            SchematicsDialog.this.tagsChanged();
                            cons.get(out);
                            this.hide();
                        });
                        if (++i % cols != 0) continue;
                        t.row();
                    }
                    for (ContentType contentType : Vars.defaultContentIcons) {
                        Seq<UnlockableContent> all = Vars.content.getBy(contentType).as().select(u -> !u.isHidden() && u.unlockedNow() && u.hasEmoji());
                        t.row();
                        if (all.count(u -> !SchematicsDialog.this.tags.contains(u.emoji())) > 0) {
                            t.image().colspan(cols).growX().width(Float.NEGATIVE_INFINITY).height(3.0f).color(Pal.accent);
                        }
                        t.row();
                        i = 0;
                        for (UnlockableContent u2 : all) {
                            if (SchematicsDialog.this.tags.contains(u2.emoji())) continue;
                            t.button(new TextureRegionDrawable(u2.uiIcon), Styles.flati, 32.0f, () -> {
                                String out = u2.emoji() + "";
                                SchematicsDialog.this.tags.add(out);
                                SchematicsDialog.this.tagsChanged();
                                cons.get(out);
                                this.hide();
                            }).tooltip(u2.localizedName);
                            if (++i % cols != 0) continue;
                            t.row();
                        }
                    }
                })).scrollX(false);
                this.buttons.button("@back", Icon.left, this::hide).size(210.0f, 64.0f);
            }
        }.show();
    }

    void showAllTags() {
        BaseDialog dialog = new BaseDialog("@schematic.edittags");
        dialog.addCloseButton();
        Runnable[] rebuild = new Runnable[]{null};
        dialog.cont.pane((Table p) -> {
            rebuild[0] = () -> {
                p.clearChildren();
                p.margin(12.0f).defaults().fillX().left();
                float sum = 0.0f;
                Table current = new Table().left();
                for (String tag : this.tags) {
                    float si = 40.0f;
                    Table next = new Table(Tex.whiteui, n -> {
                        n.setColor(Pal.gray);
                        n.margin(5.0f);
                        n.table((Table move) -> {
                            move.button((Drawable)Icon.upOpen, Styles.emptyi, () -> {
                                int idx = this.tags.indexOf(tag);
                                if (idx > 0) {
                                    this.tags.swap(idx, idx - 1);
                                    this.tagsChanged();
                                    rebuild[0].run();
                                }
                            }).size(si).tooltip("@editor.moveup").row();
                            move.button((Drawable)Icon.downOpen, Styles.emptyi, () -> {
                                int idx = this.tags.indexOf(tag);
                                if (idx < this.tags.size - 1) {
                                    this.tags.swap(idx, idx + 1);
                                    this.tagsChanged();
                                    rebuild[0].run();
                                }
                            }).size(si).tooltip("@editor.movedown");
                        }).fillY();
                        n.table((Table t) -> {
                            t.add(tag).left().row();
                            t.add(Core.bundle.format("schematic.tagged", Vars.schematics.all().count(s -> s.labels.contains(tag)))).left().update((T b) -> b.setColor(b.hasMouse() ? Pal.accent : Color.lightGray)).get().clicked(() -> {
                                dialog.hide();
                                this.selectedTags.clear().add(tag);
                                this.rebuildTags.run();
                                this.rebuildPane.run();
                            });
                        }).growX().fillY();
                        n.table((Table b) -> {
                            b.margin(2.0f);
                            b.button((Drawable)Icon.pencil, Styles.emptyi, () -> Vars.ui.showTextInput("@schematic.renametag", "@name", tag, result -> {
                                if (result.equals(tag)) {
                                    return;
                                }
                                if (this.tags.contains((String)result)) {
                                    Vars.ui.showInfo("@schematic.tagexists");
                                } else {
                                    for (Schematic s : Vars.schematics.all()) {
                                        if (!s.labels.any()) continue;
                                        s.labels.replace(tag, (String)result);
                                        s.save();
                                    }
                                    this.selectedTags.replace(tag, (String)result);
                                    this.tags.replace(tag, (String)result);
                                    this.tagsChanged();
                                    rebuild[0].run();
                                }
                            })).size(si).tooltip("@schematic.renametag").row();
                            b.button((Drawable)Icon.trash, Styles.emptyi, () -> Vars.ui.showConfirm("@schematic.tagdelconfirm", () -> {
                                for (Schematic s : Vars.schematics.all()) {
                                    if (!s.labels.any()) continue;
                                    s.labels.remove(tag);
                                    s.save();
                                }
                                this.selectedTags.remove(tag);
                                this.tags.remove(tag);
                                this.tagsChanged();
                                this.rebuildPane.run();
                                rebuild[0].run();
                            })).size(si).tooltip("@save.delete");
                        }).fillY();
                    });
                    next.pack();
                    float w = next.getWidth() + Scl.scl(9.0f);
                    if (w * 2.0f + sum >= (float)Core.graphics.getWidth() * 0.9f) {
                        p.add(current).row();
                        current = new Table();
                        current.left();
                        sum = 0.0f;
                    }
                    current.add(next).minWidth(210.0f).pad(4.0f);
                    sum += w;
                }
                if (sum > 0.0f) {
                    p.add(current).row();
                }
                p.table((Table t) -> {
                    t.left().defaults().fillX().height(42.0f).pad(2.0f);
                    t.button("@schematic.texttag", Icon.add, () -> this.showNewTag(res -> rebuild[0].run())).wrapLabel(false).get().getLabelCell().padLeft(5.0f);
                    t.button("@schematic.icontag", Icon.add, () -> this.showNewIconTag(res -> rebuild[0].run())).wrapLabel(false).get().getLabelCell().padLeft(5.0f);
                });
            };
            this.resized(true, rebuild[0]);
        }).scrollX(false);
        dialog.show();
    }

    void buildTags(Schematic schem, Table t) {
        this.buildTags(schem, t, true);
    }

    void buildTags(Schematic schem, Table t, boolean name) {
        t.clearChildren();
        t.left();
        schem.labels.sort(s -> this.tags.indexOf((String)s));
        if (name) {
            t.add("@schematic.tags").padRight(4.0f);
        }
        t.pane((Table s) -> {
            s.left();
            s.defaults().pad(3.0f).height(42.0f);
            for (String tag : schem.labels) {
                s.table(Tex.button, i -> {
                    i.add(tag).padRight(4.0f).height(42.0f).labelAlign(1);
                    i.button((Drawable)Icon.cancelSmall, Styles.emptyi, () -> {
                        this.removeTag(schem, tag);
                        this.buildTags(schem, t, name);
                    }).size(42.0f).padRight(-9.0f).padLeft(-9.0f);
                });
            }
        }).fillX().left().height(42.0f).scrollY(false);
        t.button(Icon.addSmall, () -> {
            BaseDialog dialog = new BaseDialog("@schematic.addtag");
            dialog.addCloseButton();
            dialog.cont.pane((Table p) -> this.resized(true, () -> {
                p.clearChildren();
                p.defaults().fillX().left();
                float sum = 0.0f;
                Table current = new Table().left();
                for (String tag : this.tags) {
                    if (schem.labels.contains(tag)) continue;
                    TextButton next = Elem.newButton(tag, () -> {
                        this.addTag(schem, tag);
                        this.buildTags(schem, t, name);
                        dialog.hide();
                    });
                    next.getLabel().setWrap(false);
                    next.pack();
                    float w = next.getPrefWidth() + Scl.scl(6.0f);
                    float f = Core.graphics.getWidth();
                    float f2 = Core.graphics.isPortrait() ? 1.0f : 0.8f;
                    if (w + sum >= f * f2) {
                        p.add(current).row();
                        current = new Table();
                        current.left();
                        current.add(next).height(42.0f).pad(2.0f);
                        sum = 0.0f;
                    } else {
                        current.add(next).height(42.0f).pad(2.0f);
                    }
                    sum += w;
                }
                if (sum > 0.0f) {
                    p.add(current).row();
                }
                Cons<String> handleTag = res -> {
                    dialog.hide();
                    this.addTag(schem, (String)res);
                    this.buildTags(schem, t, name);
                };
                p.row();
                p.table((Table v) -> {
                    v.left().defaults().fillX().height(42.0f).pad(2.0f);
                    v.button("@schematic.texttag", Icon.add, () -> this.showNewTag(handleTag)).wrapLabel(false).get().getLabelCell().padLeft(4.0f);
                    v.button("@schematic.icontag", Icon.add, () -> this.showNewIconTag(handleTag)).wrapLabel(false).get().getLabelCell().padLeft(4.0f);
                });
            }));
            dialog.show();
        }).size(42.0f).tooltip("@schematic.addtag");
    }

    @Override
    public Dialog show() {
        super.show();
        if (Core.app.isDesktop() && this.searchField != null) {
            Core.scene.setKeyboardFocus(this.searchField);
        }
        return this;
    }

    public class SchematicInfoDialog
    extends BaseDialog {
        SchematicInfoDialog() {
            super("");
            this.setFillParent(true);
            this.addCloseListener();
        }

        public void show(Schematic schem) {
            this.cont.clear();
            this.title.setText("[[" + Core.bundle.get("schematic") + "] " + schem.name());
            this.cont.add(Core.bundle.format("schematic.info", schem.width, schem.height, schem.tiles.size)).color(Color.lightGray).row();
            this.cont.table((Table tags) -> SchematicsDialog.this.buildTags(schem, (Table)tags)).fillX().left().row();
            this.cont.add(new SchematicImage(schem)).maxSize(800.0f).row();
            ItemSeq arr = schem.requirements();
            this.cont.table((Table r) -> {
                int i = 0;
                for (ItemStack s : arr) {
                    r.image(s.item.uiIcon).left().size(32.0f);
                    r.label(() -> {
                        CoreBlock.CoreBuild core = Vars.player.core();
                        if (core == null || Vars.state.isMenu() || Vars.state.rules.infiniteResources || core.items.has(s.item, s.amount)) {
                            return "[lightgray]" + s.amount + "";
                        }
                        return (core.items.has(s.item, s.amount) ? "[lightgray]" : "[scarlet]") + Math.min(core.items.get(s.item), s.amount) + "[lightgray]/" + s.amount;
                    }).padLeft(2.0f).left().padRight(4.0f);
                    if (++i % 4 != 0) continue;
                    r.row();
                }
            });
            this.cont.row();
            float cons = schem.powerConsumption() * 60.0f;
            float prod = schem.powerProduction() * 60.0f;
            if (!Mathf.zero(cons) || !Mathf.zero(prod)) {
                this.cont.table((Table t) -> {
                    if (!Mathf.zero(prod)) {
                        t.image(Icon.powerSmall).color(Pal.powerLight).padRight(3.0f);
                        t.add("+" + Strings.autoFixed(prod, 2)).color(Pal.powerLight).left();
                        if (!Mathf.zero(cons)) {
                            t.add().width(15.0f);
                        }
                    }
                    if (!Mathf.zero(cons)) {
                        t.image(Icon.powerSmall).color(Pal.remove).padRight(3.0f);
                        t.add("-" + Strings.autoFixed(cons, 2)).color(Pal.remove).left();
                    }
                });
            }
            this.buttons.clearChildren();
            this.buttons.defaults().size(Core.graphics.isPortrait() ? 150.0f : 210.0f, 64.0f);
            this.buttons.button("@back", Icon.left, this::hide);
            this.buttons.button("@editor.export", Icon.upload, () -> SchematicsDialog.this.showExport(schem));
            this.buttons.button("@edit", Icon.edit, () -> SchematicsDialog.this.showEdit(schem));
            this.show();
        }
    }

    public static class SchematicImage
    extends Image {
        public float scaling = 16.0f;
        public float thickness = 4.0f;
        public Color borderColor = Pal.gray;
        private Schematic schematic;
        private Texture lastTexture;
        boolean set;

        public SchematicImage(Schematic s) {
            super(Tex.clear);
            this.setScaling(Scaling.fit);
            this.schematic = s;
            if (Vars.schematics.hasPreview(s)) {
                this.setPreview();
                this.set = true;
            }
        }

        @Override
        public void draw() {
            boolean checked = this.parent.parent instanceof Button && ((Button)this.parent.parent).isOver();
            boolean wasSet = this.set;
            if (!this.set) {
                Core.app.post(this::setPreview);
                this.set = true;
            } else if (this.lastTexture != null && this.lastTexture.isDisposed()) {
                wasSet = false;
                this.set = false;
            }
            Texture background = Core.assets.get("sprites/schematic-background.png", Texture.class);
            TextureRegion region = Draw.wrap(background);
            float xr = this.width / this.scaling;
            float yr = this.height / this.scaling;
            region.setU2(xr);
            region.setV2(yr);
            Draw.color();
            Draw.alpha(this.parentAlpha);
            Draw.rect(region, this.x + this.width / 2.0f, this.y + this.height / 2.0f, this.width, this.height);
            if (wasSet) {
                super.draw();
            } else {
                Draw.rect(Icon.refresh.getRegion(), this.x + this.width / 2.0f, this.y + this.height / 2.0f, this.width / 4.0f, this.height / 4.0f);
            }
            Draw.color(checked ? Pal.accent : this.borderColor);
            Draw.alpha(this.parentAlpha);
            Lines.stroke(Scl.scl(this.thickness));
            Lines.rect(this.x, this.y, this.width, this.height);
            Draw.reset();
        }

        private void setPreview() {
            this.lastTexture = Vars.schematics.getPreview(this.schematic);
            TextureRegionDrawable draw = new TextureRegionDrawable(new TextureRegion(this.lastTexture));
            this.setDrawable(draw);
            this.setScaling(Scaling.fit);
        }
    }
}

