/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.files.Fi;
import arc.graphics.Texture;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Dialog;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.TextButton;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Scaling;
import arc.util.Strings;
import arc.util.Time;
import java.io.IOException;
import mindustry.Vars;
import mindustry.core.GameState;
import mindustry.game.Gamemode;
import mindustry.game.Saves;
import mindustry.gen.Icon;
import mindustry.io.SaveIO;
import mindustry.io.SaveMeta;
import mindustry.ui.BorderImage;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;

public class LoadDialog
extends BaseDialog {
    Table slots;
    String searchString;
    Seq<Gamemode> hidden;
    TextField searchField;
    ScrollPane pane;

    public LoadDialog() {
        this("@loadgame");
    }

    public LoadDialog(String title) {
        super(title);
        this.setup();
        this.shown(() -> {
            this.searchString = "";
            this.setup();
        });
        this.onResize(this::setup);
        this.addCloseButton();
        this.addSetup();
    }

    protected void setup() {
        this.cont.clear();
        this.slots = new Table();
        this.hidden = new Seq();
        this.pane = new ScrollPane((Element)this.slots);
        this.rebuild();
        Table search = new Table();
        search.image(Icon.zoom);
        this.searchField = search.field("", t -> {
            this.searchString = t.length() > 0 ? t.toLowerCase() : null;
            this.rebuild();
        }).maxTextLength(50).growX().get();
        this.searchField.setMessageText("@save.search");
        for (Gamemode mode : Gamemode.all) {
            boolean sandbox;
            TextureRegionDrawable icon = Vars.ui.getIcon("mode" + Strings.capitalize(mode.name()));
            boolean bl = sandbox = mode == Gamemode.sandbox;
            if (!Core.atlas.isFound(icon.getRegion()) && !sandbox) continue;
            search.button((Drawable)(sandbox ? Icon.terrain : icon), Styles.emptyTogglei, () -> {
                if (!this.hidden.addUnique(mode)) {
                    this.hidden.remove(mode);
                }
                this.rebuild();
            }).size(60.0f).padLeft(-12.0f).checked(b -> !this.hidden.contains(mode)).tooltip("@mode." + mode.name() + ".name");
        }
        this.pane.setFadeScrollBars(false);
        this.pane.setScrollingDisabled(true, false);
        this.cont.add(search).growX();
        this.cont.row();
        this.cont.add(this.pane).growY();
    }

    public void rebuild() {
        this.slots.clear();
        this.slots.marginRight(24.0f).marginLeft(20.0f);
        Time.runTask(2.0f, () -> Core.scene.setScrollFocus(this.pane));
        Seq<Saves.SaveSlot> array = Vars.control.saves.getSaveSlots();
        array.sort((slot, other) -> -Long.compare(slot.getTimestamp(), other.getTimestamp()));
        int maxwidth = Math.max((int)((float)Core.graphics.getWidth() / Scl.scl(470.0f)), 1);
        int i = 0;
        boolean any = false;
        for (Saves.SaveSlot slot2 : array) {
            if (slot2.isHidden() || this.searchString != null && !Strings.stripColors(slot2.getName()).toLowerCase().contains(this.searchString) || !this.hidden.isEmpty() && this.hidden.contains(slot2.mode())) continue;
            any = true;
            TextButton button = new TextButton("", Styles.grayt);
            button.getLabel().remove();
            button.clearChildren();
            button.defaults().left();
            button.table((Table title) -> {
                title.add("[accent]" + slot2.getName()).left().growX().width(230.0f).wrap();
                title.table((Table t) -> {
                    t.right();
                    t.defaults().size(40.0f);
                    t.button((Drawable)Icon.save, Styles.emptyTogglei, () -> slot2.setAutosave(!slot2.isAutosave())).checked(slot2.isAutosave()).right();
                    t.button((Drawable)Icon.trash, Styles.emptyi, () -> Vars.ui.showConfirm("@confirm", "@save.delete.confirm", () -> {
                        slot2.delete();
                        this.rebuild();
                    })).right();
                    t.button((Drawable)Icon.pencil, Styles.emptyi, () -> Vars.ui.showTextInput("@save.rename", "@save.rename.text", slot2.getName(), text -> {
                        slot2.setName((String)text);
                        this.rebuild();
                    })).right();
                    t.button((Drawable)Icon.export, Styles.emptyi, () -> Vars.platform.export("save-" + slot2.getName(), "msav", slot2::exportFile)).right();
                }).padRight(-10.0f).growX();
            }).growX().colspan(2);
            button.row();
            String color = "[lightgray]";
            TextureAtlas.AtlasRegion def = Core.atlas.find("nomap");
            button.left().add(new BorderImage(def, 4.0f)).update((T im) -> {
                TextureRegionDrawable draw = (TextureRegionDrawable)im.getDrawable();
                if (draw.getRegion().texture.isDisposed()) {
                    draw.setRegion(def);
                }
                Texture text = slot2.previewTexture();
                if (draw.getRegion() == def && text != null) {
                    draw.setRegion(new TextureRegion(text));
                }
                im.setScaling(Scaling.fit);
            }).left().size(160.0f).padRight(6.0f);
            button.table((Table meta) -> {
                meta.left().top();
                meta.defaults().padBottom(-2.0f).left().width(290.0f);
                meta.row();
                meta.labelWrap(Core.bundle.format("save.map", color + (slot2.getMap() == null ? Core.bundle.get("unknown") : slot2.getMap().name())));
                meta.row();
                meta.labelWrap(slot2.mode().toString() + " /" + color + " " + Core.bundle.format("save.wave", color + slot2.getWave()));
                meta.row();
                meta.labelWrap(() -> Core.bundle.format("save.autosave", color + Core.bundle.get(slot2.isAutosave() ? "on" : "off")));
                meta.row();
                meta.labelWrap(() -> Core.bundle.format("save.playtime", color + slot2.getPlayTime()));
                meta.row();
                meta.labelWrap(color + slot2.getDate());
                meta.row();
            }).left().growX().width(250.0f);
            this.modifyButton(button, slot2);
            this.slots.add(button).uniformX().fillX().pad(4.0f).padRight(8.0f).margin(10.0f);
            if (++i % maxwidth != 0) continue;
            this.slots.row();
        }
        if (!any) {
            this.slots.add("@save.none");
        }
    }

    public void addSetup() {
        this.buttons.button("@save.import", Icon.add, () -> Vars.platform.showFileChooser(true, "msav", file -> {
            if (SaveIO.isSaveValid(file)) {
                SaveMeta meta = SaveIO.getMeta(file);
                if (meta.rules.sector != null) {
                    Vars.ui.showErrorMessage("@save.nocampaign");
                } else {
                    try {
                        Vars.control.saves.importSave((Fi)file);
                        this.rebuild();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        Vars.ui.showException("@save.import.fail", e);
                    }
                }
            } else {
                Vars.ui.showErrorMessage("@save.import.invalid");
            }
        })).fillX().margin(10.0f);
    }

    public void runLoadSave(Saves.SaveSlot slot) {
        slot.cautiousLoad(() -> Vars.ui.loadAnd(() -> {
            this.hide();
            Vars.ui.paused.hide();
            try {
                Vars.net.reset();
                slot.load();
                Vars.state.rules.editor = false;
                Vars.state.rules.sector = null;
                Vars.state.set(GameState.State.playing);
            }
            catch (SaveIO.SaveException e) {
                Log.err(e);
                Vars.logic.reset();
                Vars.ui.showErrorMessage("@save.corrupted");
            }
        }));
    }

    public void modifyButton(TextButton button, Saves.SaveSlot slot) {
        button.clicked(() -> {
            if (!button.childrenPressed()) {
                this.runLoadSave(slot);
            }
        });
    }

    @Override
    public Dialog show() {
        super.show();
        if (Core.app.isDesktop() && this.searchField != null) {
            Core.scene.setKeyboardFocus(this.searchField);
        }
        return this;
    }
}

