/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.scene.Element;
import arc.scene.ui.ImageButton;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Table;
import arc.util.Strings;
import arc.util.Time;
import java.util.Locale;
import mindustry.Vars;
import mindustry.core.Version;
import mindustry.game.EventType;
import mindustry.gen.Tex;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.ui.dialogs.PaletteDialog;

public class HostDialog
extends BaseDialog {
    float w = 300.0f;

    public HostDialog() {
        super("@hostserver");
        this.addCloseButton();
        this.cont.table((Table t) -> {
            t.add("@name").padRight(10.0f);
            t.field(Core.settings.getString("name"), text -> {
                Vars.player.name((String)text);
                Core.settings.put("name", text);
                Vars.ui.listfrag.rebuild();
            }).grow().pad(8.0f).get().setMaxLength(40);
            ImageButton button = t.button(Tex.whiteui, Styles.squarei, 40.0f, () -> new PaletteDialog().show((Color color) -> {
                Vars.player.color.set((Color)color);
                Core.settings.put("color-0", color.rgba());
            })).size(54.0f).get();
            button.update(() -> {
                button.getStyle().imageUpColor = Vars.player.color();
            });
        }).width(this.w).height(70.0f).pad(4.0f).colspan(3);
        if (Vars.steam) {
            this.cont.row();
            this.cont.add().width(65.0f);
            this.cont.check("@steam.friendsonly", !Core.settings.getBool("steampublichost"), val -> Core.settings.put("steampublichost", !val)).colspan(2).left().with(c -> Vars.ui.addDescTooltip((Element)c, "@steam.friendsonly.tooltip")).padBottom(15.0f).row();
        }
        this.cont.row();
        TextField[] portField = new TextField[]{null};
        this.cont.table((Table t) -> {
            t.add("@server.port").padRight(10.0f);
            portField[0] = t.field(String.valueOf(Core.settings.getInt("port", 6567)), text -> Core.settings.put("port", Strings.parseInt(text, 6567))).pad(8.0f).grow().maxTextLength(5).valid(text -> {
                int port = Strings.parseInt(text);
                return port >= 1 && port <= 65535;
            }).get();
        }).width(this.w).height(70.0f).pad(4.0f).colspan(3);
        this.cont.row();
        this.cont.add().width(65.0f);
        this.cont.button("@host", () -> {
            if (Core.settings.getString("name").trim().isEmpty()) {
                Vars.ui.showInfo("@noname");
                return;
            }
            this.runHost();
        }).width(this.w).height(70.0f).disabled(b -> !portField[0].isValid());
        if (!Vars.steam) {
            this.cont.button("?", () -> Vars.ui.showInfo("@host.info")).size(65.0f, 70.0f).padLeft(6.0f);
        } else {
            this.cont.add().size(65.0f, 70.0f).padLeft(6.0f);
        }
        this.shown(() -> {
            if (!Vars.steam) {
                Core.app.post(() -> Core.settings.getBoolOnce("hostinfo", () -> Vars.ui.showInfo("@host.info")));
            }
        });
    }

    public void runHost() {
        Vars.ui.loadfrag.show("@hosting");
        Time.runTask(5.0f, () -> {
            try {
                Vars.net.host(Core.settings.getInt("port", 6567));
                Vars.player.admin = true;
                Events.fire(new EventType.HostEvent());
                if (Vars.steam && Core.settings.getBool("steampublichost") && (Version.modifier.contains("beta") || Version.modifier.contains("alpha"))) {
                    Core.settings.put("steampublichost", false);
                    Vars.platform.updateLobby();
                    Core.settings.getBoolOnce("betapublic", () -> Vars.ui.showInfo("@public.beta"));
                }
            }
            catch (Exception e) {
                Vars.ui.showException(e.getMessage() != null && e.getMessage().toLowerCase(Locale.ROOT).contains("address already in use") ? "@server.error.addressinuse" : "@server.error", e);
            }
            Vars.ui.loadfrag.hide();
            this.hide();
        });
    }
}

