/*
 * Decompiled with CFR 0.152.
 */
package mindustry.type.weapons;

import arc.graphics.Color;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.units.WeaponMount;
import mindustry.gen.Bullet;
import mindustry.gen.Groups;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.type.Weapon;

public class PointDefenseWeapon
extends Weapon {
    public Color color = Color.white;
    public Effect beamEffect = Fx.pointBeam;

    public PointDefenseWeapon(String name) {
        super(name);
        this.predictTarget = false;
        this.autoTarget = true;
        this.controllable = false;
        this.rotate = true;
        this.useAmmo = false;
        this.useAttackRange = false;
        this.targetInterval = 10.0f;
    }

    public PointDefenseWeapon() {
        this.predictTarget = false;
        this.autoTarget = true;
        this.controllable = false;
        this.rotate = true;
        this.useAmmo = false;
        this.useAttackRange = false;
        this.targetInterval = 10.0f;
    }

    @Override
    protected Teamc findTarget(Unit unit, float x, float y, float range, boolean air, boolean ground) {
        return Groups.bullet.intersect(x - range, y - range, range * 2.0f, range * 2.0f).min(b -> b.team != unit.team && b.type().hittable, b -> b.dst2(x, y));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean checkTarget(Unit unit, Teamc target, float x, float y, float range) {
        if (!target.within(unit, range)) return true;
        if (target.team() == unit.team) return true;
        if (!(target instanceof Bullet)) return true;
        Bullet bullet = (Bullet)target;
        if (bullet.type == null) return true;
        if (!bullet.type.hittable) return true;
        return false;
    }

    @Override
    protected void shoot(Unit unit, WeaponMount mount, float shootX, float shootY, float rotation) {
        Teamc teamc = mount.target;
        if (!(teamc instanceof Bullet)) {
            return;
        }
        Bullet target = (Bullet)teamc;
        float bulletDamage = this.bullet.damage * unit.damageMultiplier() * Vars.state.rules.unitDamage(unit.team);
        if (target.damage() > bulletDamage) {
            target.damage(target.damage() - bulletDamage);
        } else {
            target.remove();
        }
        this.beamEffect.at(shootX, shootY, rotation, this.color, new Vec2().set(target));
        this.bullet.shootEffect.at(shootX, shootY, rotation, this.color);
        this.bullet.hitEffect.at(target.x, target.y, this.color);
        this.shootSound.at(shootX, shootY, Mathf.random(0.9f, 1.1f));
        mount.recoil = 1.0f;
        mount.heat = 1.0f;
    }
}

