/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.part;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.math.Mathf;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.entities.part.DrawPart;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;

public class FlarePart
extends DrawPart {
    public int sides = 4;
    public float radius = 100.0f;
    public float radiusTo = -1.0f;
    public float stroke = 6.0f;
    public float innerScl = 0.5f;
    public float innerRadScl = 0.33f;
    public float x;
    public float y;
    public float rotation;
    public float rotMove;
    public float spinSpeed;
    public boolean followRotation;
    public Color color1 = Pal.techBlue;
    public Color color2 = Color.white;
    public boolean clampProgress = true;
    public DrawPart.PartProgress progress = DrawPart.PartProgress.warmup;
    public float layer = 110.0f;

    @Override
    public void draw(DrawPart.PartParams params) {
        int j;
        float z = Draw.z();
        if (this.layer > 0.0f) {
            Draw.z(this.layer);
        }
        float prog = this.progress.getClamp(params, this.clampProgress);
        int i = params.sideOverride == -1 ? 0 : params.sideOverride;
        float sign = (i == 0 ? 1 : -1) * params.sideMultiplier;
        Tmp.v1.set(this.x * sign, this.y).rotate(params.rotation - 90.0f);
        float rx = params.x + Tmp.v1.x;
        float ry = params.y + Tmp.v1.y;
        float rot = (this.followRotation ? params.rotation : 0.0f) + this.rotMove * prog + this.rotation + Time.time * this.spinSpeed;
        float rad = this.radiusTo < 0.0f ? this.radius : Mathf.lerp(this.radius, this.radiusTo, prog);
        Draw.color(this.color1);
        for (j = 0; j < this.sides; ++j) {
            Drawf.tri(rx, ry, this.stroke, rad, (float)j * 360.0f / (float)this.sides + rot);
        }
        Draw.color(this.color2);
        for (j = 0; j < this.sides; ++j) {
            Drawf.tri(rx, ry, this.stroke * this.innerScl, rad * this.innerRadScl, (float)j * 360.0f / (float)this.sides + rot);
        }
        Draw.color();
        Draw.z(z);
    }

    @Override
    public void load(String name) {
    }
}

