/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.part;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.math.Mathf;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.part.DrawPart;

public class EffectSpawnerPart
extends DrawPart {
    public float x;
    public float y;
    public float width;
    public float height;
    public float rotation;
    public boolean mirror = false;
    public float effectChance = 0.1f;
    public float effectRot;
    public float effectRandRot;
    public Effect effect = Fx.sparkShoot;
    public Color effectColor = Color.white;
    public boolean useProgress = true;
    public DrawPart.PartProgress progress = DrawPart.PartProgress.warmup;
    public boolean debugDraw = false;

    @Override
    public void draw(DrawPart.PartParams params) {
        float rot;
        float sign;
        int i;
        if (this.debugDraw) {
            for (i = 0; i < (this.mirror ? 2 : 1); ++i) {
                sign = i == 0 ? 1.0f : -1.0f;
                rot = params.rotation + this.rotation * sign;
                Tmp.v1.set(this.x * sign, this.y).rotate(params.rotation - 90.0f).add(params.x, params.y);
                float z = Draw.z();
                Draw.z(122.0f);
                Draw.color(Color.red);
                Draw.rect("error", Tmp.v1.x, Tmp.v1.y, this.width, this.height, rot - 90.0f);
                Draw.color();
                Draw.z(z);
            }
        }
        if (Vars.state.isPaused()) {
            return;
        }
        for (i = 0; i < (this.mirror ? 2 : 1); ++i) {
            if (Vars.state.isPaused() || !Mathf.chanceDelta(this.effectChance * (this.useProgress ? this.progress.getClamp(params) : 1.0f))) continue;
            sign = i == 0 ? 1.0f : -1.0f;
            rot = params.rotation + this.rotation * sign;
            Tmp.v1.set(this.x * sign, this.y).rotate(params.rotation - 90.0f).add(params.x, params.y);
            Tmp.v1.add(Tmp.v2.set(Mathf.random(-this.height * 0.5f, this.height * 0.5f), Mathf.random(-this.width * 0.5f, this.width * 0.5f)).rotate(rot));
            this.effect.at(Tmp.v1.x, Tmp.v1.y, rot + this.effectRot * sign + Mathf.random(-this.effectRandRot, this.effectRandRot), this.effectColor);
        }
    }
}

