/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.bullet;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.util.Nullable;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Fires;
import mindustry.entities.Puddles;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Bullet;
import mindustry.type.Liquid;
import mindustry.world.Tile;

public class LiquidBulletType
extends BulletType {
    public Liquid liquid;
    public float puddleSize = 6.0f;
    public float orbSize = 3.0f;
    public float boilTime = 5.0f;

    public LiquidBulletType(@Nullable Liquid liquid) {
        super(3.5f, 0.0f);
        if (liquid != null) {
            this.liquid = liquid;
            this.status = liquid.effect;
            this.hitColor = liquid.color;
            this.lightColor = liquid.lightColor;
            this.lightOpacity = liquid.lightColor.a;
        }
        this.ammoMultiplier = 1.0f;
        this.lifetime = 34.0f;
        this.statusDuration = 120.0f;
        this.despawnEffect = Fx.none;
        this.hitEffect = Fx.hitLiquid;
        this.smokeEffect = Fx.none;
        this.shootEffect = Fx.none;
        this.drag = 0.001f;
        this.knockback = 0.55f;
        this.displayAmmoMultiplier = false;
    }

    public LiquidBulletType() {
        this(null);
    }

    @Override
    public void update(Bullet b) {
        Tile tile;
        super.update(b);
        if (this.liquid.willBoil() && b.time >= Mathf.randomSeed(b.id, this.boilTime)) {
            Fx.vaporSmall.at(b.x, b.y, this.liquid.gasColor);
            b.remove();
            return;
        }
        if (this.liquid.canExtinguish() && (tile = Vars.world.tileWorld(b.x, b.y)) != null && Fires.has(tile.x, tile.y)) {
            Fires.extinguish(tile, 100.0f);
            b.remove();
            this.hit(b);
        }
    }

    @Override
    public void draw(Bullet b) {
        super.draw(b);
        if (this.liquid.willBoil()) {
            Draw.color(this.liquid.color, Tmp.c3.set(this.liquid.gasColor).a(0.4f), b.time / Mathf.randomSeed(b.id, this.boilTime));
            Fill.circle(b.x, b.y, this.orbSize * (b.fin() * 1.1f + 1.0f));
        } else {
            Draw.color(this.liquid.color, Color.white, b.fout() / 100.0f);
            Fill.circle(b.x, b.y, this.orbSize);
        }
        Draw.reset();
    }

    @Override
    public void despawned(Bullet b) {
        super.despawned(b);
        if (!this.liquid.willBoil()) {
            this.hitEffect.at(b.x, b.y, b.rotation(), this.liquid.color);
        }
    }

    @Override
    public void hit(Bullet b, float hitx, float hity) {
        this.hitEffect.at(hitx, hity, this.liquid.color);
        Puddles.deposit(Vars.world.tileWorld(hitx, hity), this.liquid, this.puddleSize);
        if (this.liquid.temperature <= 0.5f && this.liquid.flammability < 0.3f) {
            float intensity = 400.0f * this.puddleSize / 6.0f;
            Fires.extinguish(Vars.world.tileWorld(hitx, hity), intensity);
            for (Point2 p : Geometry.d4) {
                Fires.extinguish(Vars.world.tileWorld(hitx + (float)(p.x * 8), hity + (float)(p.y * 8)), intensity);
            }
        }
    }
}

