/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai;

import arc.func.Boolf;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.struct.IntSet;
import arc.struct.Seq;
import arc.util.Interval;
import arc.util.Nullable;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.ai.BaseRegistry;
import mindustry.ai.Pathfinder;
import mindustry.content.Fx;
import mindustry.core.World;
import mindustry.game.Schematic;
import mindustry.game.Schematics;
import mindustry.game.Teams;
import mindustry.gen.Building;
import mindustry.gen.Unit;
import mindustry.type.Item;
import mindustry.world.Build;
import mindustry.world.Edges;
import mindustry.world.Tile;
import mindustry.world.blocks.payloads.PayloadBlock;
import mindustry.world.blocks.payloads.PayloadConveyor;
import mindustry.world.blocks.production.Drill;
import mindustry.world.blocks.storage.CoreBlock;

public class BaseBuilderAI {
    private static final Vec2 axis = new Vec2();
    private static final Vec2 rotator = new Vec2();
    private static final int attempts = 6;
    private static final int coreUnitMultiplier = 2;
    private static final float emptyChance = 0.01f;
    private static final int timerStep = 0;
    private static final int timerSpawn = 1;
    private static final int timerRefreshPath = 2;
    private static final float placeIntervalMin = 12.0f;
    private static final float placeIntervalMax = 2.0f;
    private static final int pathStep = 50;
    private static final Seq<Tile> tmpTiles = new Seq();
    private static int correct = 0;
    private static int incorrect = 0;
    private boolean foundPath;
    final Teams.TeamData data;
    final Interval timer = new Interval(4);
    IntSet path = new IntSet();
    IntSet calcPath = new IntSet();
    @Nullable
    Tile calcTile;
    boolean calculating;
    boolean startedCalculating;
    int calcCount = 0;
    int totalCalcs = 0;

    public BaseBuilderAI(Teams.TeamData data) {
        this.data = data;
    }

    public void update() {
        if (this.data.team.cores().size > 0) {
            CoreBlock.CoreBuild core = this.data.team.cores().first();
            for (Item item : Vars.content.items()) {
                core.items.set(item, core.getMaximumAccepted(item));
            }
        }
        if (this.data.team.rules().aiCoreSpawn && this.timer.get(1, 360.0f) && this.data.hasCore()) {
            CoreBlock block = (CoreBlock)this.data.core().block;
            int coreUnits = this.data.countType(block.unitType);
            if (!Vars.state.isEditor() && coreUnits < this.data.cores.size * 2) {
                Unit unit = block.unitType.create(this.data.team);
                unit.set(this.data.cores.random());
                unit.add();
                Fx.spawn.at(unit);
            }
        }
        if (!this.calculating && (this.timer.get(2, 10800.0f) || !this.startedCalculating) && this.data.hasCore()) {
            this.calculating = true;
            this.startedCalculating = true;
            this.calcPath.clear();
        }
        if (this.calculating && this.calcCount >= Vars.world.width() * Vars.world.height()) {
            this.calculating = false;
            this.calcCount = 0;
            this.calcPath.clear();
            ++this.totalCalcs;
        }
        if (this.calculating) {
            if (this.calcTile == null) {
                Vars.spawner.eachGroundSpawn((x, y) -> {
                    this.calcTile = Vars.world.tile(x, y);
                });
                if (this.calcTile == null) {
                    this.calculating = false;
                }
            } else {
                Pathfinder.Flowfield field = Vars.pathfinder.getField(this.data.team, 0, 0);
                if (field.hasCompleteWeights()) {
                    int[] weights = field.completeWeights;
                    for (int i = 0; i < 50; ++i) {
                        int minCost = Integer.MAX_VALUE;
                        short cx = this.calcTile.x;
                        short cy = this.calcTile.y;
                        boolean foundAny = false;
                        for (Point2 p : Geometry.d4) {
                            int nx = cx + p.x;
                            int ny = cy + p.y;
                            int packed = Vars.world.packArray(nx, ny);
                            Tile other = Vars.world.tile(nx, ny);
                            if (other == null || weights[packed] >= minCost || weights[packed] == -1) continue;
                            minCost = weights[packed];
                            this.calcTile = other;
                            foundAny = true;
                        }
                        if (!foundAny) {
                            this.calcCount = Integer.MAX_VALUE;
                            break;
                        }
                        this.calcPath.add(this.calcTile.pos());
                        for (Point2 p : Geometry.d8) {
                            this.calcPath.add(Point2.pack(p.x + this.calcTile.x, p.y + this.calcTile.y));
                        }
                        Building building = this.calcTile.build;
                        if (building instanceof CoreBlock.CoreBuild) {
                            CoreBlock.CoreBuild b = (CoreBlock.CoreBuild)building;
                            if (b.team != this.data.team) {
                                this.calculating = false;
                                this.calcCount = 0;
                                this.path.clear();
                                this.path.addAll(this.calcPath);
                                this.calcPath.clear();
                                this.calcTile = null;
                                ++this.totalCalcs;
                                this.foundPath = true;
                                break;
                            }
                        }
                        ++this.calcCount;
                    }
                }
            }
        }
        if ((this.foundPath || !this.calculating) && this.data.plans.isEmpty() && this.timer.get(0, Mathf.lerp(12.0f, 2.0f, this.data.team.rules().buildAiTier))) {
            for (int i = 0; i < 6; ++i) {
                BaseRegistry.BasePart part;
                int range = 150;
                Position pos = this.randomPosition();
                if (pos == null) {
                    return;
                }
                Tmp.v1.rnd(Mathf.random(range));
                int wx = (int)((float)World.toTile(pos.getX()) + Tmp.v1.x);
                int wy = (int)((float)World.toTile(pos.getY()) + Tmp.v1.y);
                Tile tile = Vars.world.tiles.getc(wx, wy);
                if (Vars.spawner.getSpawns().contains((Tile)((Object)((Boolf<Tile>)t -> t.within(tile, 320.0f))))) continue;
                Seq<BaseRegistry.BasePart> parts = null;
                if (tile.drop() != null && Vars.bases.forResource(tile.drop()).any()) {
                    parts = Vars.bases.forResource(tile.drop());
                } else if (Mathf.chance(0.01f)) {
                    parts = Vars.bases.parts;
                }
                if (parts != null && this.tryPlace(part = parts.random(), tile.x, tile.y)) break;
            }
        }
    }

    private Position randomPosition() {
        if (this.data.hasCore()) {
            return this.data.cores.random();
        }
        if (this.data.team == Vars.state.rules.waveTeam) {
            return Vars.spawner.getSpawns().random();
        }
        return null;
    }

    private boolean tryPlace(BaseRegistry.BasePart part, int x, int y) {
        int rotation = Mathf.range(2);
        axis.set((int)((float)part.schematic.width / 2.0f), (int)((float)part.schematic.height / 2.0f));
        Schematic result = Schematics.rotate(part.schematic, rotation);
        int rotdeg = rotation * 90;
        rotator.set(part.centerX, part.centerY).rotateAround(axis, rotdeg);
        int cx = x - (int)BaseBuilderAI.rotator.x;
        int cy = y - (int)BaseBuilderAI.rotator.y;
        for (Schematic.Stile tile : result.tiles) {
            int realX = tile.x + cx;
            int realY = tile.y + cy;
            if (!Build.validPlace(tile.block, this.data.team, realX, realY, tile.rotation)) {
                return false;
            }
            Tile wtile = Vars.world.tile(realX, realY);
            if (tile.block instanceof PayloadConveyor || tile.block instanceof PayloadBlock) {
                for (Point2 point : Edges.getEdges(tile.block.size)) {
                    Building t2 = Vars.world.build(tile.x + point.x, tile.y + point.y);
                    if (t2 == null) continue;
                    return false;
                }
            }
            tmpTiles.clear();
            if (!tile.block.solid || wtile == null || !wtile.getLinkedTilesAs(tile.block, tmpTiles).contains((Tile)((Object)((Boolf<Tile>)t -> this.path.contains(t.pos()))))) continue;
            return false;
        }
        incorrect = 0;
        correct = 0;
        boolean anyDrills = false;
        if (part.required instanceof Item) {
            for (Schematic.Stile tile : result.tiles) {
                if (!(tile.block instanceof Drill)) continue;
                anyDrills = true;
                tile.block.iterateTaken(tile.x + cx, tile.y + cy, (ex, ey) -> {
                    Tile res = Vars.world.rawTile(ex, ey);
                    if (res.drop() == part.required) {
                        ++correct;
                    } else if (res.drop() != null) {
                        ++incorrect;
                    }
                });
            }
        }
        if (anyDrills && (incorrect != 0 || correct == 0)) {
            return false;
        }
        for (Schematic.Stile tile : result.tiles) {
            this.data.plans.add(new Teams.BlockPlan(cx + tile.x, cy + tile.y, tile.rotation, tile.block, tile.config));
        }
        return true;
    }
}

