/*
 * Decompiled with CFR 0.152.
 */
package arc.util;

import arc.Core;
import arc.files.Fi;
import arc.graphics.Gl;
import arc.graphics.Pixmap;
import arc.graphics.PixmapIO;
import arc.graphics.Texture;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Buffers;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public final class ScreenUtils {
    public static void saveScreenshot(Fi file) {
        ScreenUtils.saveScreenshot(file, 0, 0, Core.graphics.getWidth(), Core.graphics.getHeight());
    }

    public static void saveScreenshot(Fi file, int x, int y, int width, int height) {
        Pixmap pixmap = ScreenUtils.getFrameBufferPixmap(x, y, width, height, true);
        PixmapIO.writePng(file, pixmap);
        pixmap.dispose();
    }

    public static TextureRegion getFrameBufferTexture() {
        int w = Core.graphics.getBackBufferWidth();
        int h = Core.graphics.getBackBufferHeight();
        return ScreenUtils.getFrameBufferTexture(0, 0, w, h);
    }

    public static TextureRegion getFrameBufferTexture(int x, int y, int w, int h) {
        int potW = Mathf.nextPowerOfTwo(w);
        int potH = Mathf.nextPowerOfTwo(h);
        Pixmap pixmap = ScreenUtils.getFrameBufferPixmap(x, y, w, h);
        Pixmap potPixmap = new Pixmap(potW, potH);
        potPixmap.draw(pixmap, 0, 0);
        Texture texture = new Texture(potPixmap);
        TextureRegion textureRegion = new TextureRegion(texture, 0, h, w, -h);
        potPixmap.dispose();
        pixmap.dispose();
        return textureRegion;
    }

    public static Pixmap getFrameBufferPixmap(int x, int y, int w, int h) {
        Gl.pixelStorei(3333, 1);
        Pixmap pixmap = new Pixmap(w, h);
        ByteBuffer pixels = pixmap.pixels;
        Gl.readPixels(x, y, w, h, 6408, 5121, pixels);
        return pixmap;
    }

    public static Pixmap getFrameBufferPixmap(int x, int y, int w, int h, boolean flip) {
        byte[] lines = ScreenUtils.getFrameBufferPixels(x, y, w, h, flip);
        Pixmap pixmap = new Pixmap(w, h);
        Buffers.copy(lines, 0, (Buffer)pixmap.pixels, lines.length);
        return pixmap;
    }

    public static byte[] getFrameBufferPixels(boolean flipY) {
        int w = Core.graphics.getBackBufferWidth();
        int h = Core.graphics.getBackBufferHeight();
        return ScreenUtils.getFrameBufferPixels(0, 0, w, h, flipY);
    }

    public static byte[] getFrameBufferPixels(int x, int y, int w, int h, boolean flipY) {
        Gl.pixelStorei(3333, 1);
        ByteBuffer pixels = Buffers.newByteBuffer(w * h * 4);
        Gl.readPixels(x, y, w, h, 6408, 5121, pixels);
        int numBytes = w * h * 4;
        byte[] lines = new byte[numBytes];
        if (flipY) {
            int numBytesPerLine = w * 4;
            for (int i = 0; i < h; ++i) {
                pixels.position((h - i - 1) * numBytesPerLine);
                pixels.get(lines, i * numBytesPerLine, numBytesPerLine);
            }
        } else {
            pixels.clear();
            pixels.get(lines);
        }
        return lines;
    }
}

