/*
 * Decompiled with CFR 0.152.
 */
package arc.scene.event;

import arc.Core;
import arc.Graphics;
import arc.func.Boolp;
import arc.scene.Element;
import arc.scene.event.ClickListener;
import arc.scene.event.InputEvent;
import arc.scene.utils.Disableable;

public class HandCursorListener
extends ClickListener {
    public Boolp enabled = () -> true;
    public boolean checkEnabled = true;

    public HandCursorListener(Boolp enabled, boolean check) {
        this.enabled = enabled;
        this.checkEnabled = check;
    }

    public HandCursorListener() {
    }

    @Override
    public void enter(InputEvent event, float x, float y, int pointer, Element fromActor) {
        super.enter(event, x, y, pointer, fromActor);
        if (pointer != -1 || !this.enabled.get() || this.checkEnabled && (HandCursorListener.isDisabled(event.targetActor) || HandCursorListener.isDisabled(fromActor))) {
            return;
        }
        Core.graphics.cursor(Graphics.Cursor.SystemCursor.hand);
    }

    @Override
    public void exit(InputEvent event, float x, float y, int pointer, Element toActor) {
        super.exit(event, x, y, pointer, toActor);
        if (pointer == -1) {
            Core.graphics.restoreCursor();
        }
    }

    static boolean isDisabled(Element element) {
        return element != null && (element instanceof Disableable && ((Disableable)((Object)element)).isDisabled() || !element.visible || HandCursorListener.isDisabled(element.parent));
    }
}

