/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.g2d;

import arc.Core;
import arc.files.Fi;
import arc.func.Prov;
import arc.graphics.Pixmap;
import arc.graphics.Pixmaps;
import arc.graphics.Texture;
import arc.graphics.g2d.NinePatch;
import arc.graphics.g2d.PixmapRegion;
import arc.graphics.g2d.TextureRegion;
import arc.scene.style.BaseDrawable;
import arc.scene.style.Drawable;
import arc.scene.style.ScaledNinePatchDrawable;
import arc.scene.style.TextureRegionDrawable;
import arc.struct.ObjectMap;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.ArcRuntimeException;
import arc.util.Disposable;
import arc.util.io.Reads;
import java.io.IOException;

public class TextureAtlas
implements Disposable {
    private final ObjectSet<Texture> textures = new ObjectSet(4);
    private final Seq<AtlasRegion> regions = new Seq();
    private final ObjectMap<String, Drawable> drawables = new ObjectMap();
    private final ObjectMap<String, AtlasRegion> regionmap = new ObjectMap();
    private final ObjectMap<Texture, Pixmap> pixmaps = new ObjectMap();
    protected AtlasRegion error;
    protected AtlasRegion white;
    protected float drawableScale = 1.0f;

    public static TextureAtlas blankAtlas() {
        TextureAtlas a = new TextureAtlas();
        a.white = new AtlasRegion(Pixmaps.blankTextureRegion());
        return a;
    }

    public TextureAtlas() {
    }

    public TextureAtlas(String internalPackFile) {
        this(Core.files.internal(internalPackFile));
    }

    public TextureAtlas(Fi packFile) {
        this(packFile, packFile.parent());
    }

    public TextureAtlas(Fi packFile, boolean flip) {
        this(packFile, packFile.parent(), flip);
    }

    public TextureAtlas(Fi packFile, Fi imagesDir) {
        this(packFile, imagesDir, false);
    }

    public TextureAtlas(Fi packFile, Fi imagesDir, boolean flip) {
        this(new TextureAtlasData(packFile, imagesDir, flip));
    }

    public TextureAtlas(TextureAtlasData data) {
        if (data != null) {
            this.load(data);
        }
    }

    public void setDrawableScale(float scale) {
        this.drawableScale = scale;
    }

    private void load(TextureAtlasData data) {
        ObjectMap<TextureAtlasData.AtlasPage, Texture> pageToTexture = new ObjectMap<TextureAtlasData.AtlasPage, Texture>();
        for (TextureAtlasData.AtlasPage page : data.pages) {
            Texture texture;
            if (page.texture == null) {
                texture = new Texture(page.textureFile, page.useMipMaps);
                texture.setFilter(page.minFilter, page.magFilter);
                texture.setWrap(page.uWrap, page.vWrap);
            } else {
                texture = page.texture;
                texture.setFilter(page.minFilter, page.magFilter);
                texture.setWrap(page.uWrap, page.vWrap);
            }
            this.textures.add(texture);
            pageToTexture.put(page, texture);
        }
        for (TextureAtlasData.Region region : data.regions) {
            int width = region.width;
            int height = region.height;
            AtlasRegion atlasRegion = new AtlasRegion((Texture)pageToTexture.get(region.page), region.left, region.top, region.rotate ? height : width, region.rotate ? width : height);
            atlasRegion.name = region.name;
            atlasRegion.offsetX = region.offsetX;
            atlasRegion.offsetY = region.offsetY;
            atlasRegion.originalHeight = region.originalHeight;
            atlasRegion.originalWidth = region.originalWidth;
            atlasRegion.rotate = region.rotate;
            atlasRegion.splits = region.splits;
            atlasRegion.pads = region.pads;
            if (region.flip) {
                atlasRegion.flip(false, true);
            }
            this.regions.add(atlasRegion);
            this.regionmap.put(atlasRegion.name, atlasRegion);
        }
        this.error = this.find("error");
    }

    public PixmapRegion getPixmap(String name) {
        return this.getPixmap(this.find(name));
    }

    public PixmapRegion getPixmap(AtlasRegion region) {
        if (region.pixmapRegion == null) {
            Pixmap pix = (Pixmap)((Object)this.pixmaps.get(region.texture, (Pixmap)((Object)((Prov<Pixmap>)() -> region.texture.getTextureData().getPixmap()))));
            region.pixmapRegion = new PixmapRegion(pix, region.getX(), region.getY(), region.width, region.height);
        }
        return region.pixmapRegion;
    }

    public ObjectMap<Texture, Pixmap> getPixmaps() {
        return this.pixmaps;
    }

    public void disposePixmap(Texture texture) {
        if (this.pixmaps.containsKey(texture) && !this.pixmaps.get(texture).isDisposed()) {
            this.pixmaps.get(texture).dispose();
        }
        this.pixmaps.remove(texture);
    }

    public PixmapRegion getPixmap(TextureRegion region) {
        return this.getPixmap((AtlasRegion)region);
    }

    public AtlasRegion addRegion(String name, Texture texture, int x, int y, int width, int height) {
        this.textures.add(texture);
        AtlasRegion region = new AtlasRegion(texture, x, y, width, height);
        region.name = name;
        region.originalWidth = width;
        region.originalHeight = height;
        this.regions.add(region);
        this.regionmap.put(name, region);
        return region;
    }

    public AtlasRegion addRegion(String name, TextureRegion textureRegion) {
        return this.addRegion(name, textureRegion.texture, textureRegion.getX(), textureRegion.getY(), textureRegion.width, textureRegion.height);
    }

    public Seq<AtlasRegion> getRegions() {
        return this.regions;
    }

    public ObjectMap<String, AtlasRegion> getRegionMap() {
        return this.regionmap;
    }

    public AtlasRegion white() {
        if (this.white == null) {
            this.white = this.find("white");
        }
        return this.white;
    }

    public boolean setErrorRegion(String name) {
        if (this.error != null || !this.has(name)) {
            return false;
        }
        this.error = this.find(name);
        return true;
    }

    public boolean isFound(TextureRegion region) {
        return region != this.error;
    }

    public AtlasRegion find(String name) {
        AtlasRegion r = this.regionmap.get(name, this.error);
        if (r == null && !name.equals("error")) {
            throw new IllegalArgumentException("The region \"" + name + "\" does not exist!");
        }
        return r;
    }

    public TextureRegion find(String name, String def) {
        return this.find(name, this.find(def));
    }

    public TextureRegion find(String name, TextureRegion def) {
        TextureRegion region = this.regionmap.get(name);
        return region == null || region == this.error ? def : region;
    }

    public boolean has(String s) {
        return this.regionmap.containsKey(s);
    }

    public <T extends Drawable> T getDrawable(String name) {
        return (T)this.drawable(name);
    }

    public Drawable drawable(String name) {
        if (this.drawables.containsKey(name)) {
            return this.drawables.get(name);
        }
        BaseDrawable out = null;
        if (this.has(name)) {
            AtlasRegion region = this.find(name);
            if (region.splits != null) {
                int[] splits = region.splits;
                NinePatch patch = new NinePatch((TextureRegion)region, splits[0], splits[1], splits[2], splits[3]);
                int[] pads = region.pads;
                if (pads != null) {
                    patch.setPadding(pads[0], pads[1], pads[2], pads[3]);
                }
                out = new ScaledNinePatchDrawable(patch, this.drawableScale);
            } else {
                out = new TextureRegionDrawable(region, this.drawableScale);
            }
        }
        if (this.error == null && out == null) {
            throw new IllegalArgumentException("No drawable '" + name + "' found.");
        }
        if (out == null) {
            out = new TextureRegionDrawable(this.error);
        }
        this.drawables.put(name, out);
        return out;
    }

    public NinePatch createPatch(String name) {
        int n = this.regions.size;
        for (int i = 0; i < n; ++i) {
            AtlasRegion region = this.regions.get(i);
            if (!region.name.equals(name)) continue;
            int[] splits = region.splits;
            if (splits == null) {
                throw new IllegalArgumentException("Region does not have ninepatch splits: " + name);
            }
            NinePatch patch = new NinePatch((TextureRegion)region, splits[0], splits[1], splits[2], splits[3]);
            if (region.pads != null) {
                patch.setPadding(region.pads[0], region.pads[1], region.pads[2], region.pads[3]);
            }
            return patch;
        }
        return null;
    }

    public ObjectSet<Texture> getTextures() {
        return this.textures;
    }

    public Texture texture() {
        return this.textures.first();
    }

    @Override
    public void dispose() {
        for (Texture texture : this.textures) {
            texture.dispose();
        }
        for (Pixmap pixmap : this.pixmaps.values()) {
            if (pixmap.isDisposed()) continue;
            pixmap.dispose();
        }
        this.textures.clear();
        this.pixmaps.clear();
    }

    public static class AtlasRegion
    extends TextureRegion {
        public PixmapRegion pixmapRegion;
        public String name;
        public float offsetX;
        public float offsetY;
        public int packedWidth;
        public int packedHeight;
        public int originalWidth;
        public int originalHeight;
        public boolean rotate;
        public int[] splits;
        public int[] pads;

        public AtlasRegion(Texture texture, int x, int y, int width, int height) {
            super(texture, x, y, width, height);
            this.originalWidth = width;
            this.originalHeight = height;
            this.packedWidth = width;
            this.packedHeight = height;
        }

        public AtlasRegion() {
        }

        public AtlasRegion(AtlasRegion region) {
            this.set(region);
            this.name = region.name;
            this.offsetX = region.offsetX;
            this.offsetY = region.offsetY;
            this.packedWidth = region.packedWidth;
            this.packedHeight = region.packedHeight;
            this.originalWidth = region.originalWidth;
            this.originalHeight = region.originalHeight;
            this.rotate = region.rotate;
            this.splits = region.splits;
        }

        public AtlasRegion(TextureRegion region) {
            this.set(region);
            this.name = "unknown";
        }

        @Override
        public void flip(boolean x, boolean y) {
            super.flip(x, y);
            if (x) {
                this.offsetX = (float)this.originalWidth - this.offsetX - this.getRotatedPackedWidth();
            }
            if (y) {
                this.offsetY = (float)this.originalHeight - this.offsetY - this.getRotatedPackedHeight();
            }
        }

        public float getRotatedPackedWidth() {
            return this.rotate ? (float)this.packedHeight : (float)this.packedWidth;
        }

        public float getRotatedPackedHeight() {
            return this.rotate ? (float)this.packedWidth : (float)this.packedHeight;
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    public static class TextureAtlasData {
        public static final byte formatVersion = 0;
        public static final byte[] formatHeader = new byte[]{65, 65, 84, 76, 83};
        final Seq<AtlasPage> pages = new Seq();
        final Seq<Region> regions = new Seq();

        public TextureAtlasData(Fi packFile, Fi imagesDir, boolean flip) {
            try (Reads read = packFile.reads();){
                for (byte b : formatHeader) {
                    if (read.b() == b) continue;
                    throw new IOException("Invalid binary header. Have you re-packed sprites?");
                }
                read.b();
                while (read.checkEOF() != -1) {
                    String image = read.str();
                    Fi file = imagesDir.child(image);
                    short pageWidth = read.s();
                    short pageHeight = read.s();
                    Texture.TextureFilter min = Texture.TextureFilter.all[read.b()];
                    Texture.TextureFilter mag = Texture.TextureFilter.all[read.b()];
                    Texture.TextureWrap wrapX = Texture.TextureWrap.all[read.b()];
                    Texture.TextureWrap wrapY = Texture.TextureWrap.all[read.b()];
                    int rects = read.i();
                    AtlasPage page = new AtlasPage(file, pageWidth, pageHeight, min.isMipMap(), min, mag, wrapX, wrapY);
                    this.pages.add(page);
                    for (int j = 0; j < rects; ++j) {
                        Region region = new Region();
                        region.flip = flip;
                        region.page = page;
                        region.name = read.str();
                        region.left = read.s();
                        region.top = read.s();
                        region.width = read.s();
                        region.height = read.s();
                        if (read.bool()) {
                            region.offsetX = read.s();
                            region.offsetY = read.s();
                            region.originalWidth = read.s();
                            region.originalHeight = read.s();
                        }
                        if (read.bool()) {
                            region.splits = new int[]{read.s(), read.s(), read.s(), read.s()};
                        }
                        if (read.bool()) {
                            region.pads = new int[]{read.s(), read.s(), read.s(), read.s()};
                        }
                        this.regions.add(region);
                    }
                }
            }
            catch (Exception e) {
                throw new ArcRuntimeException("Error reading pack file: " + packFile, e);
            }
        }

        public Seq<AtlasPage> getPages() {
            return this.pages;
        }

        public Seq<Region> getRegions() {
            return this.regions;
        }

        public static class AtlasPage {
            public final Fi textureFile;
            public final int width;
            public final int height;
            public final boolean useMipMaps;
            public final Texture.TextureFilter minFilter;
            public final Texture.TextureFilter magFilter;
            public final Texture.TextureWrap uWrap;
            public final Texture.TextureWrap vWrap;
            public Texture texture;

            public AtlasPage(Fi handle, int width, int height, boolean useMipMaps, Texture.TextureFilter minFilter, Texture.TextureFilter magFilter, Texture.TextureWrap uWrap, Texture.TextureWrap vWrap) {
                this.width = width;
                this.height = height;
                this.textureFile = handle;
                this.useMipMaps = useMipMaps;
                this.minFilter = minFilter;
                this.magFilter = magFilter;
                this.uWrap = uWrap;
                this.vWrap = vWrap;
            }
        }

        public static class Region {
            public AtlasPage page;
            public String name;
            public float offsetX;
            public float offsetY;
            public int originalWidth;
            public int originalHeight;
            public boolean rotate;
            public int left;
            public int top;
            public int width;
            public int height;
            public boolean flip;
            public int[] splits;
            public int[] pads;
        }
    }
}

