/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.g2d;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Circle;
import arc.math.geom.Polygon;
import arc.math.geom.Rect;
import arc.struct.FloatSeq;

public class Fill {
    private static float[] vertices = new float[24];
    private static TextureRegion circleRegion;
    private static FloatSeq polyFloats;

    public static void quad(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        float color = Core.batch.getPackedColor();
        Fill.quad(x1, y1, color, x2, y2, color, x3, y3, color, x4, y4, color);
    }

    public static void quad(float x1, float y1, float c1, float x2, float y2, float c2, float x3, float y3, float c3, float x4, float y4, float c4) {
        TextureAtlas.AtlasRegion region = Core.atlas.white();
        float mcolor = Core.batch.getPackedMixColor();
        float u = region.u;
        float v = region.v;
        Fill.vertices[0] = x1;
        Fill.vertices[1] = y1;
        Fill.vertices[2] = c1;
        Fill.vertices[3] = u;
        Fill.vertices[4] = v;
        Fill.vertices[5] = mcolor;
        Fill.vertices[6] = x2;
        Fill.vertices[7] = y2;
        Fill.vertices[8] = c2;
        Fill.vertices[9] = u;
        Fill.vertices[10] = v;
        Fill.vertices[11] = mcolor;
        Fill.vertices[12] = x3;
        Fill.vertices[13] = y3;
        Fill.vertices[14] = c3;
        Fill.vertices[15] = u;
        Fill.vertices[16] = v;
        Fill.vertices[17] = mcolor;
        Fill.vertices[18] = x4;
        Fill.vertices[19] = y4;
        Fill.vertices[20] = c4;
        Fill.vertices[21] = u;
        Fill.vertices[22] = v;
        Fill.vertices[23] = mcolor;
        Draw.vert(region.texture, vertices, 0, vertices.length);
    }

    public static void quad(TextureRegion region, float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        float color = Core.batch.getPackedColor();
        Fill.quad(region, x1, y1, color, x2, y2, color, x3, y3, color, x4, y4, color);
    }

    public static void quad(TextureRegion region, float x1, float y1, float c1, float x2, float y2, float c2, float x3, float y3, float c3, float x4, float y4, float c4) {
        Fill.quad(region.texture, x1, y1, c1, region.u, region.v, x2, y2, c2, region.u, region.v2, x3, y3, c3, region.u2, region.v2, x4, y4, c4, region.u2, region.v);
    }

    public static void quad(Texture texture, float x1, float y1, float c1, float u1, float v1, float x2, float y2, float c2, float u2, float v2, float x3, float y3, float c3, float u3, float v3, float x4, float y4, float c4, float u4, float v4) {
        float mcolor = Core.batch.getPackedMixColor();
        Fill.vertices[0] = x1;
        Fill.vertices[1] = y1;
        Fill.vertices[2] = c1;
        Fill.vertices[3] = u1;
        Fill.vertices[4] = v1;
        Fill.vertices[5] = mcolor;
        Fill.vertices[6] = x2;
        Fill.vertices[7] = y2;
        Fill.vertices[8] = c2;
        Fill.vertices[9] = u2;
        Fill.vertices[10] = v2;
        Fill.vertices[11] = mcolor;
        Fill.vertices[12] = x3;
        Fill.vertices[13] = y3;
        Fill.vertices[14] = c3;
        Fill.vertices[15] = u3;
        Fill.vertices[16] = v3;
        Fill.vertices[17] = mcolor;
        Fill.vertices[18] = x4;
        Fill.vertices[19] = y4;
        Fill.vertices[20] = c4;
        Fill.vertices[21] = u4;
        Fill.vertices[22] = v4;
        Fill.vertices[23] = mcolor;
        Draw.vert(texture, vertices, 0, vertices.length);
    }

    public static void tri(float x1, float y1, float x2, float y2, float x3, float y3) {
        Fill.quad(x1, y1, x2, y2, x3, y3, x3, y3);
    }

    public static void dropShadowRect(float x, float y, float width, float height, float blur, float opacity) {
        Fill.dropShadow(x + width / 2.0f, y + height / 2.0f, width, height, blur, opacity);
    }

    public static void dropShadow(float x, float y, float width, float height, float blur, float opacity) {
        float edge = Color.clearFloatBits;
        float center = Color.toFloatBits(0.0f, 0.0f, 0.0f, opacity);
        float inside = blur / 2.0f;
        float outside = blur;
        float x1 = x - Math.max(width / 2.0f - inside, 0.0f);
        float y1 = y - Math.max(height / 2.0f - inside, 0.0f);
        float x2 = x + Math.max(width / 2.0f - inside, 0.0f);
        float y2 = y + Math.max(height / 2.0f - inside, 0.0f);
        float bx1 = x1 - outside;
        float by1 = y1 - outside;
        float bx2 = x2 + outside;
        float by2 = y2 + outside;
        Fill.quad(x1, y1, center, x2, y1, center, x2, y2, center, x1, y2, center);
        Fill.quad(x1, y1, center, bx1, by1, edge, bx2, by1, edge, x2, y1, center);
        Fill.quad(x2, y1, center, bx2, by1, edge, bx2, by2, edge, x2, y2, center);
        Fill.quad(x1, y2, center, bx1, by2, edge, bx2, by2, edge, x2, y2, center);
        Fill.quad(x1, y1, center, bx1, by1, edge, bx1, by2, edge, x1, y2, center);
    }

    public static void light(float x, float y, int sides, float radius, Color center, Color edge) {
        Fill.light(x, y, sides, radius, 0.0f, center, edge);
    }

    public static void light(float x, float y, int sides, float radius, float rotation, Color center, Color edge) {
        float centerf = center.toFloatBits();
        float edgef = edge.toFloatBits();
        sides = Mathf.ceil((float)sides / 2.0f) * 2;
        float space = 360.0f / (float)sides;
        for (int i = 0; i < sides; i += 2) {
            float px = Angles.trnsx(space * (float)i + rotation, radius);
            float py = Angles.trnsy(space * (float)i + rotation, radius);
            float px2 = Angles.trnsx(space * (float)(i + 1) + rotation, radius);
            float py2 = Angles.trnsy(space * (float)(i + 1) + rotation, radius);
            float px3 = Angles.trnsx(space * (float)(i + 2) + rotation, radius);
            float py3 = Angles.trnsy(space * (float)(i + 2) + rotation, radius);
            Fill.quad(x, y, centerf, x + px, y + py, edgef, x + px2, y + py2, edgef, x + px3, y + py3, edgef);
        }
    }

    public static void lightInner(float x, float y, int sides, float innerRadius, float radius, float rotation, Color center, Color edge) {
        float centerf = center.toFloatBits();
        float edgef = edge.toFloatBits();
        float space = 360.0f / (float)sides;
        for (int i = 0; i < sides; ++i) {
            float px = Angles.trnsx(space * (float)i + rotation, radius);
            float py = Angles.trnsy(space * (float)i + rotation, radius);
            float px2 = Angles.trnsx(space * (float)(i + 1) + rotation, radius);
            float py2 = Angles.trnsy(space * (float)(i + 1) + rotation, radius);
            Fill.quad(x + Angles.trnsx(space * (float)i + rotation, innerRadius), y + Angles.trnsy(space * (float)i + rotation, innerRadius), centerf, x + px, y + py, edgef, x + px2, y + py2, edgef, x + Angles.trnsx(space * (float)(i + 1) + rotation, innerRadius), y + Angles.trnsy(space * (float)(i + 1) + rotation, innerRadius), centerf);
        }
    }

    public static void polyBegin() {
        polyFloats.clear();
    }

    public static void polyPoint(float x, float y) {
        polyFloats.add(x, y);
    }

    public static void polyEnd() {
        Fill.poly(Fill.polyFloats.items, Fill.polyFloats.size);
    }

    public static void poly(Polygon p) {
        Fill.poly(p.getTransformedVertices(), p.getTransformedVertices().length);
    }

    public static void poly(FloatSeq vertices) {
        Fill.poly(vertices.items, vertices.size);
    }

    public static void poly(float[] vertices, int length) {
        if (length < 6) {
            return;
        }
        for (int i = 2; i < length - 4; i += 4) {
            Fill.quad(vertices[0], vertices[1], vertices[i], vertices[i + 1], vertices[i + 2], vertices[i + 3], vertices[i + 4], vertices[i + 5]);
        }
    }

    public static void poly(float x, float y, int sides, float radius) {
        Fill.poly(x, y, sides, radius, 0.0f);
    }

    public static void poly(float x, float y, int sides, float radius, float rotation) {
        if (sides == 3) {
            Fill.tri(x + Angles.trnsx(rotation, radius), y + Angles.trnsy(rotation, radius), x + Angles.trnsx(120.0f + rotation, radius), y + Angles.trnsy(120.0f + rotation, radius), x + Angles.trnsx(240.0f + rotation, radius), y + Angles.trnsy(240.0f + rotation, radius));
        } else if (sides == 4) {
            Fill.quad(x + Angles.trnsx(rotation, radius), y + Angles.trnsy(rotation, radius), x + Angles.trnsx(90.0f + rotation, radius), y + Angles.trnsy(90.0f + rotation, radius), x + Angles.trnsx(180.0f + rotation, radius), y + Angles.trnsy(180.0f + rotation, radius), x + Angles.trnsx(270.0f + rotation, radius), y + Angles.trnsy(270.0f + rotation, radius));
        } else {
            float space = 360.0f / (float)sides;
            for (int i = 0; i < sides - 1; i += 2) {
                float px = Angles.trnsx(space * (float)i + rotation, radius);
                float py = Angles.trnsy(space * (float)i + rotation, radius);
                float px2 = Angles.trnsx(space * (float)(i + 1) + rotation, radius);
                float py2 = Angles.trnsy(space * (float)(i + 1) + rotation, radius);
                float px3 = Angles.trnsx(space * (float)(i + 2) + rotation, radius);
                float py3 = Angles.trnsy(space * (float)(i + 2) + rotation, radius);
                Fill.quad(x, y, x + px, y + py, x + px2, y + py2, x + px3, y + py3);
            }
            int mod = sides % 2;
            if (mod == 0) {
                return;
            }
            int i = sides - 1;
            float px = Angles.trnsx(space * (float)i + rotation, radius);
            float py = Angles.trnsy(space * (float)i + rotation, radius);
            float px2 = Angles.trnsx(space * (float)(i + 1) + rotation, radius);
            float py2 = Angles.trnsy(space * (float)(i + 1) + rotation, radius);
            Fill.tri(x, y, x + px, y + py, x + px2, y + py2);
        }
    }

    public static void arc(float x, float y, float radius, float fraction) {
        Fill.arc(x, y, radius, fraction, 0.0f);
    }

    public static void arc(float x, float y, float radius, float fraction, float rotation) {
        Fill.arc(x, y, radius, fraction, rotation, 50);
    }

    public static void arc(float x, float y, float radius, float fraction, float rotation, int sides) {
        int max = Mathf.ceil((float)sides * fraction);
        Fill.polyBegin();
        Fill.polyPoint(x, y);
        for (int i = 0; i <= max; ++i) {
            float a = (float)i / (float)max * fraction * 360.0f + rotation;
            float x1 = Angles.trnsx(a, radius);
            float y1 = Angles.trnsy(a, radius);
            Fill.polyPoint(x + x1, y + y1);
        }
        Fill.polyPoint(x, y);
        Fill.polyEnd();
    }

    public static void circle(Circle c) {
        Fill.circle(c.x, c.y, c.radius);
    }

    public static void circle(float x, float y, float radius) {
        if (circleRegion == null || Fill.circleRegion.texture.isDisposed()) {
            circleRegion = Core.atlas.find("circle");
        }
        Draw.rect(circleRegion, x, y, radius * 2.0f, radius * 2.0f);
    }

    public static void rect(Rect r) {
        Fill.crect(r.x, r.y, r.width, r.height);
    }

    public static void rect(float x, float y, float w, float h) {
        Draw.rect((TextureRegion)Core.atlas.white(), x, y, w, h);
    }

    public static void rect(float x, float y, float w, float h, float rot) {
        Draw.rect(Core.atlas.white(), x, y, w, h, rot);
    }

    public static void crect(float x, float y, float w, float h) {
        Draw.rect((TextureRegion)Core.atlas.white(), x + w / 2.0f, y + h / 2.0f, w, h);
    }

    public static void rects(float x, float y, float w, float h, float skew) {
        Fill.quad(x, y, x + w, y, x + w + skew, y + h, x + skew, y + h);
    }

    public static void square(float x, float y, float radius) {
        Fill.rect(x, y, radius * 2.0f, radius * 2.0f);
    }

    public static void square(float x, float y, float radius, float rotation) {
        Draw.rect(Core.atlas.white(), x, y, radius * 2.0f, radius * 2.0f, rotation);
    }

    static {
        polyFloats = new FloatSeq();
    }
}

