/*
 * Decompiled with CFR 0.152.
 */
package arc.fx.util;

import arc.Core;
import arc.graphics.Gl;
import arc.graphics.gl.FrameBuffer;
import arc.graphics.gl.Shader;
import arc.util.Disposable;

public class FxBufferRenderer
implements Disposable {
    private final Shader shader = new Shader("attribute vec4 a_position;\nattribute vec2 a_texCoord0;\nvarying vec2 v_texCoords;\nvoid main(){\n    v_texCoords = a_texCoord0;\n    gl_Position = a_position;\n}", "varying vec2 v_texCoords;\nuniform sampler2D u_texture0;\nvoid main(){\n    gl_FragColor = texture2D(u_texture0, v_texCoords);\n}");

    public FxBufferRenderer() {
        this.rebind();
    }

    @Override
    public void dispose() {
        this.shader.dispose();
    }

    public void rebind() {
        this.shader.bind();
        this.shader.setUniformi("u_texture0", 0);
    }

    public void renderToScreen(FrameBuffer input) {
        this.renderToScreen(input, 0, 0, Core.graphics.getBackBufferWidth(), Core.graphics.getBackBufferHeight());
    }

    public void renderToScreen(FrameBuffer input, int x, int y, int width, int height) {
        Gl.viewport(x, y, width, height);
        input.blit(this.shader);
    }

    public void renderToFbo(FrameBuffer input, FrameBuffer output) {
        output.begin();
        input.blit(this.shader);
        output.end();
    }
}

