/*
 * Decompiled with CFR 0.152.
 */
package arc.assets.loaders;

import arc.Core;
import arc.assets.AssetDescriptor;
import arc.assets.AssetLoaderParameters;
import arc.assets.AssetManager;
import arc.assets.loaders.AsynchronousAssetLoader;
import arc.assets.loaders.FileHandleResolver;
import arc.audio.Music;
import arc.files.Fi;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Nullable;

public class MusicLoader
extends AsynchronousAssetLoader<Music, MusicParameter> {
    private Music music;

    public MusicLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    protected Music getLoadedMusic() {
        return this.music;
    }

    @Override
    public void loadAsync(AssetManager manager, String fileName, Fi file, MusicParameter parameter) {
        if (parameter != null && parameter.music != null) {
            try {
                this.music = parameter.music;
                this.music.load(file);
            }
            catch (Exception e) {
                Log.err(e);
            }
        } else {
            this.music = Core.audio.newMusic(file);
        }
    }

    @Override
    public Music loadSync(AssetManager manager, String fileName, Fi file, MusicParameter parameter) {
        Music music = this.music;
        this.music = null;
        return music;
    }

    @Override
    public Seq<AssetDescriptor> getDependencies(String fileName, Fi file, MusicParameter parameter) {
        return null;
    }

    public static class MusicParameter
    extends AssetLoaderParameters<Music> {
        @Nullable
        public Music music;

        public MusicParameter() {
        }

        public MusicParameter(@Nullable Music music) {
            this.music = music;
        }

        public MusicParameter(AssetLoaderParameters.LoadedCallback loadedCallback) {
            super(loadedCallback);
        }
    }
}

