/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.environment;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.scene.ui.layout.Table;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Tmp;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Unit;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.ColoredFloor;
import mindustry.world.blocks.environment.StaticWall;

public class ColoredWall
extends StaticWall {
    public static final int flagIgnoreDifferentColor = 1;
    public static final int flagApplyDarkness = 2;
    public Color defaultColor = Color.white;
    protected int defaultColorRgba;

    public ColoredWall(String name) {
        super(name);
        this.saveData = true;
        this.editorConfigurable = true;
        this.saveConfig = true;
    }

    @Override
    public void init() {
        super.init();
        this.defaultColorRgba = this.defaultColor.rgba();
        this.lastConfig = this.defaultColorRgba;
    }

    @Override
    public Object getConfig(Tile tile) {
        return tile.extraData;
    }

    @Override
    public void buildEditorConfig(Table table) {
        ColoredFloor.showColorEdit(table, this);
    }

    @Override
    public void drawBase(Tile tile) {
        Draw.color(tile.extraData | 0xFF);
        super.drawBase(tile);
        Draw.color();
    }

    @Override
    public void blockChanged(Tile tile) {
        if (tile.extraData == 0) {
            tile.extraData = this.defaultColorRgba;
        }
    }

    @Override
    public void placeEnded(Tile tile, @Nullable Unit builder, int rotation, @Nullable Object config) {
        if (config instanceof Integer) {
            Integer i = (Integer)config;
            tile.extraData = i;
        }
    }

    @Override
    public void editorPicked(Tile tile) {
        this.lastConfig = tile.extraData;
    }

    @Override
    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        Object object = plan.config;
        if (object instanceof Integer) {
            Integer i = (Integer)object;
            Draw.tint(Tmp.c1.set((int)(i | 0xFF)));
        }
        this.drawDefaultPlanRegion(plan, list);
    }

    @Override
    public boolean checkAutotileSame(Tile tile, @Nullable Tile other) {
        return other != null && other.block() == this && (tile.extraData == 1 || tile.extraData == other.extraData);
    }

    @Override
    public boolean isDarkened(Tile tile) {
        return tile.extraData == 2;
    }

    @Override
    public int minimapColor(Tile tile) {
        return tile.extraData | 0xFF;
    }
}

