/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.distribution;

import arc.audio.Sound;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Point2;
import arc.struct.OrderedSet;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import arc.util.pooling.Pool;
import arc.util.pooling.Pools;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.bullet.MassDriverBolt;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Sounds;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.logic.LAccess;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.blocks.RotBlock;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class MassDriver
extends Block {
    public float range;
    public float rotateSpeed = 5.0f;
    public float translation = 7.0f;
    public int minDistribute = 10;
    public float knockback = 4.0f;
    public float reload = 100.0f;
    public MassDriverBolt bullet = new MassDriverBolt();
    public float bulletSpeed = 5.5f;
    public float bulletLifetime = 200.0f;
    public Effect shootEffect = Fx.shootBig2;
    public Effect smokeEffect = Fx.shootBigSmoke2;
    public Effect receiveEffect = Fx.mineBig;
    public Sound shootSound = Sounds.shootBig;
    public float shake = 3.0f;
    public TextureRegion baseRegion;

    public MassDriver(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.configurable = true;
        this.hasItems = true;
        this.hasPower = true;
        this.outlineIcon = true;
        this.sync = true;
        this.envEnabled |= 2;
        this.config(Point2.class, (tile, point) -> {
            tile.link = Point2.pack(point.x + tile.tileX(), point.y + tile.tileY());
        });
        this.config(Integer.class, (tile, point) -> {
            tile.link = point;
        });
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.shootRange, this.range / 8.0f, StatUnit.blocks);
        this.stats.add(Stat.reload, 60.0f / this.reload, StatUnit.perSecond);
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.baseRegion, this.region};
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Drawf.dashCircle(x * 8, y * 8, this.range, Pal.accent);
        if (!Vars.control.input.config.isShown()) {
            return;
        }
        Building selected = Vars.control.input.config.getSelected();
        if (selected == null || selected.block != this || !selected.within(x * 8, y * 8, this.range)) {
            return;
        }
        float sin = Mathf.absin(Time.time, 6.0f, 1.0f);
        Tmp.v1.set((float)(x * 8) + this.offset, (float)(y * 8) + this.offset).sub(selected.x, selected.y).limit(((float)this.size / 2.0f + 1.0f) * 8.0f + sin + 0.5f);
        float x2 = (float)(x * 8) - Tmp.v1.x;
        float y2 = (float)(y * 8) - Tmp.v1.y;
        float x1 = selected.x + Tmp.v1.x;
        float y1 = selected.y + Tmp.v1.y;
        int segs = (int)(selected.dst(x * 8, y * 8) / 8.0f);
        Lines.stroke(4.0f, Pal.gray);
        Lines.dashLine(x1, y1, x2, y2, segs);
        Lines.stroke(2.0f, Pal.placing);
        Lines.dashLine(x1, y1, x2, y2, segs);
        Draw.reset();
    }

    public class MassDriverBuild
    extends Building
    implements RotBlock {
        public int link = -1;
        public float rotation = 90.0f;
        public float reloadCounter = 0.0f;
        public DriverState state = DriverState.idle;
        public OrderedSet<Building> waitingShooters = new OrderedSet();

        @Override
        public float buildRotation() {
            return this.rotation;
        }

        public Building currentShooter() {
            return this.waitingShooters.isEmpty() ? null : this.waitingShooters.first();
        }

        @Override
        public void updateTile() {
            Building current;
            Building link = Vars.world.build(this.link);
            boolean hasLink = this.linkValid();
            if (hasLink) {
                this.link = link.pos();
            }
            if (this.reloadCounter > 0.0f) {
                this.reloadCounter = Mathf.clamp(this.reloadCounter - this.edelta() / MassDriver.this.reload);
            }
            if ((current = this.currentShooter()) != null && !this.shooterValid(current)) {
                this.waitingShooters.remove(current);
            }
            if (this.state == DriverState.idle) {
                if (!this.waitingShooters.isEmpty() && MassDriver.this.itemCapacity - this.items.total() >= MassDriver.this.minDistribute) {
                    this.state = DriverState.accepting;
                } else if (hasLink) {
                    this.state = DriverState.shooting;
                }
            }
            if (this.state == DriverState.idle || this.state == DriverState.accepting) {
                this.dumpAccumulate();
            }
            if (this.efficiency <= 0.0f) {
                return;
            }
            if (this.state == DriverState.accepting) {
                if (this.currentShooter() == null || MassDriver.this.itemCapacity - this.items.total() < MassDriver.this.minDistribute) {
                    this.state = DriverState.idle;
                    return;
                }
                this.rotation = Angles.moveToward(this.rotation, this.angleTo(this.currentShooter()), MassDriver.this.rotateSpeed * this.efficiency);
            } else if (this.state == DriverState.shooting) {
                if (!hasLink || !this.waitingShooters.isEmpty() && MassDriver.this.itemCapacity - this.items.total() >= MassDriver.this.minDistribute) {
                    this.state = DriverState.idle;
                    return;
                }
                float targetRotation = this.angleTo(link);
                if (this.items.total() >= MassDriver.this.minDistribute && link.block.itemCapacity - link.items.total() >= MassDriver.this.minDistribute) {
                    MassDriverBuild other = (MassDriverBuild)link;
                    other.waitingShooters.add(this);
                    if (this.reloadCounter <= 1.0E-4f) {
                        this.rotation = Angles.moveToward(this.rotation, targetRotation, MassDriver.this.rotateSpeed * this.efficiency);
                        if (other.currentShooter() == this && other.state == DriverState.accepting && Angles.near(this.rotation, targetRotation, 2.0f) && Angles.near(other.rotation, targetRotation + 180.0f, 2.0f)) {
                            this.fire(other);
                            float timeToArrive = Math.min(MassDriver.this.bulletLifetime, this.dst(other) / MassDriver.this.bulletSpeed);
                            Time.run(timeToArrive, () -> {
                                other.waitingShooters.remove(this);
                                other.state = DriverState.idle;
                            });
                            this.state = DriverState.idle;
                        }
                    }
                }
            }
        }

        @Override
        public double sense(LAccess sensor) {
            if (sensor == LAccess.progress) {
                return Mathf.clamp(1.0f - this.reloadCounter);
            }
            return super.sense(sensor);
        }

        @Override
        public void draw() {
            Draw.rect(MassDriver.this.baseRegion, this.x, this.y);
            Draw.z(50.0f);
            Drawf.shadow(MassDriver.this.region, this.x + Angles.trnsx(this.rotation + 180.0f, this.reloadCounter * MassDriver.this.knockback) - (float)(MassDriver.this.size / 2), this.y + Angles.trnsy(this.rotation + 180.0f, this.reloadCounter * MassDriver.this.knockback) - (float)(MassDriver.this.size / 2), this.rotation - 90.0f);
            Draw.rect(MassDriver.this.region, this.x + Angles.trnsx(this.rotation + 180.0f, this.reloadCounter * MassDriver.this.knockback), this.y + Angles.trnsy(this.rotation + 180.0f, this.reloadCounter * MassDriver.this.knockback), this.rotation - 90.0f);
        }

        @Override
        public void drawConfigure() {
            float sin = Mathf.absin(Time.time, 6.0f, 1.0f);
            Draw.color(Pal.accent);
            Lines.stroke(1.0f);
            Drawf.circles(this.x, this.y, ((float)this.tile.block().size / 2.0f + 1.0f) * 8.0f + sin - 2.0f, Pal.accent);
            for (Building shooter : this.waitingShooters) {
                Drawf.circles(shooter.x, shooter.y, ((float)this.tile.block().size / 2.0f + 1.0f) * 8.0f + sin - 2.0f, Pal.place);
                Drawf.arrow(shooter.x, shooter.y, this.x, this.y, (float)(MassDriver.this.size * 8) + sin, 4.0f + sin, Pal.place);
            }
            if (this.linkValid()) {
                Building target = Vars.world.build(this.link);
                Drawf.circles(target.x, target.y, ((float)target.block.size / 2.0f + 1.0f) * 8.0f + sin - 2.0f, Pal.place);
                Drawf.arrow(this.x, this.y, target.x, target.y, (float)(MassDriver.this.size * 8) + sin, 4.0f + sin);
            }
            Drawf.dashCircle(this.x, this.y, MassDriver.this.range, Pal.accent);
        }

        @Override
        public boolean onConfigureBuildTapped(Building other) {
            if (this == other) {
                if (this.link == -1) {
                    this.deselect();
                }
                this.configure(-1);
                return false;
            }
            if (this.link == other.pos()) {
                this.configure(-1);
                return false;
            }
            if (other.block == this.block && other.dst(this.tile) <= MassDriver.this.range && other.team == this.team) {
                this.configure(other.pos());
                return false;
            }
            return true;
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            return this.items.total() < MassDriver.this.itemCapacity && this.linkValid();
        }

        protected void fire(MassDriverBuild target) {
            this.reloadCounter = 1.0f;
            DriverBulletData data = Pools.obtain(DriverBulletData.class, DriverBulletData::new);
            data.from = this;
            data.to = target;
            int totalUsed = 0;
            for (int i = 0; i < Vars.content.items().size; ++i) {
                int maxTransfer;
                data.items[i] = maxTransfer = Math.min(this.items.get(Vars.content.item(i)), this.tile.block().itemCapacity - totalUsed);
                totalUsed += maxTransfer;
                this.items.remove(Vars.content.item(i), maxTransfer);
            }
            float angle = this.tile.angleTo(target);
            MassDriver.this.bullet.create(this, this.team, this.x + Angles.trnsx(angle, MassDriver.this.translation), this.y + Angles.trnsy(angle, MassDriver.this.translation), angle, (float)totalUsed / 2.0f, MassDriver.this.bulletSpeed, MassDriver.this.bulletLifetime, data);
            MassDriver.this.shootEffect.at(this.x + Angles.trnsx(angle, MassDriver.this.translation), this.y + Angles.trnsy(angle, MassDriver.this.translation), angle);
            MassDriver.this.smokeEffect.at(this.x + Angles.trnsx(angle, MassDriver.this.translation), this.y + Angles.trnsy(angle, MassDriver.this.translation), angle);
            Effect.shake(MassDriver.this.shake, MassDriver.this.shake, this);
            MassDriver.this.shootSound.at(this.tile, Mathf.random(0.9f, 1.1f));
        }

        public void handlePayload(Bullet bullet, DriverBulletData data) {
            int totalItems = this.items.total();
            int i = 0;
            while (i < data.items.length) {
                int maxAdd = Math.min(data.items[i], MassDriver.this.itemCapacity * 2 - totalItems);
                this.items.add(Vars.content.item(i), maxAdd);
                int n = i++;
                data.items[n] = data.items[n] - maxAdd;
                if ((totalItems += maxAdd) >= MassDriver.this.itemCapacity * 2) break;
            }
            Effect.shake(MassDriver.this.shake, MassDriver.this.shake, this);
            MassDriver.this.receiveEffect.at(bullet);
            this.reloadCounter = 1.0f;
            bullet.remove();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected boolean shooterValid(Building other) {
            if (!(other instanceof MassDriverBuild)) return false;
            MassDriverBuild entity = (MassDriverBuild)other;
            if (!other.isValid()) return false;
            if (!(other.efficiency > 0.0f)) return false;
            if (entity.block != this.block) return false;
            if (entity.link != this.pos()) return false;
            if (!this.within(other, MassDriver.this.range)) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected boolean linkValid() {
            if (this.link == -1) {
                return false;
            }
            Building building = Vars.world.build(this.link);
            if (!(building instanceof MassDriverBuild)) return false;
            MassDriverBuild other = (MassDriverBuild)building;
            if (other.block != this.block) return false;
            if (other.team != this.team) return false;
            if (!this.within(other, MassDriver.this.range)) return false;
            return true;
        }

        @Override
        public Point2 config() {
            if (this.tile == null) {
                return null;
            }
            return Point2.unpack(this.link).sub(this.tile.x, this.tile.y);
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.i(this.link);
            write.f(this.rotation);
            write.b((byte)this.state.ordinal());
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.link = read.i();
            this.rotation = read.f();
            this.state = DriverState.all[read.b()];
        }
    }

    public static enum DriverState {
        idle,
        accepting,
        shooting;

        public static final DriverState[] all;

        static {
            all = DriverState.values();
        }
    }

    public static class DriverBulletData
    implements Pool.Poolable {
        public MassDriverBuild from;
        public MassDriverBuild to;
        public int[] items;

        public DriverBulletData() {
            this.items = new int[Vars.content.items().size];
        }

        @Override
        public void reset() {
            this.from = null;
            this.to = null;
        }
    }
}

