/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense.turrets;

import arc.audio.Sound;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.StatusEffects;
import mindustry.entities.Units;
import mindustry.gen.Sounds;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.type.Liquid;
import mindustry.type.StatusEffect;
import mindustry.world.blocks.defense.turrets.BaseTurret;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class TractorBeamTurret
extends BaseTurret {
    public final int timerTarget;
    public float retargetTime;
    public float shootCone;
    public float shootLength;
    public float laserWidth;
    public float force;
    public float scaledForce;
    public float damage;
    public boolean targetAir;
    public boolean targetGround;
    public Color laserColor;
    public StatusEffect status;
    public float statusDuration;
    public Sound shootSound;
    public float shootSoundVolume;
    public TextureRegion baseRegion;
    public TextureRegion laser;
    public TextureRegion laserStart;
    public TextureRegion laserEnd;

    public TractorBeamTurret(String name) {
        super(name);
        this.timerTarget = this.timers++;
        this.retargetTime = 5.0f;
        this.shootCone = 6.0f;
        this.shootLength = 5.0f;
        this.laserWidth = 0.6f;
        this.force = 0.3f;
        this.scaledForce = 0.0f;
        this.damage = 0.0f;
        this.targetAir = true;
        this.targetGround = false;
        this.laserColor = Color.white;
        this.status = StatusEffects.none;
        this.statusDuration = 300.0f;
        this.shootSound = Sounds.tractorbeam;
        this.shootSoundVolume = 0.9f;
        this.rotateSpeed = 10.0f;
        this.coolantMultiplier = 1.0f;
        this.envEnabled |= 2;
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.baseRegion, this.region};
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.targetsAir, this.targetAir);
        this.stats.add(Stat.targetsGround, this.targetGround);
        if (this.damage > 0.0f) {
            this.stats.add(Stat.damage, this.damage * 60.0f, StatUnit.perSecond);
        }
    }

    @Override
    public void init() {
        super.init();
        this.updateClipRadius(this.range + 8.0f);
    }

    public class TractorBeamBuild
    extends BaseTurret.BaseTurretBuild {
        @Nullable
        public Unit target;
        public float lastX;
        public float lastY;
        public float strength;
        public boolean any;
        public float coolantMultiplier = 1.0f;

        @Override
        public void updateTile() {
            float eff = this.efficiency * this.coolantMultiplier;
            float edelta = eff * this.delta();
            if (this.timer(TractorBeamTurret.this.timerTarget, TractorBeamTurret.this.retargetTime)) {
                this.target = Units.closestEnemy(this.team, this.x, this.y, TractorBeamTurret.this.range, u -> u.checkTarget(TractorBeamTurret.this.targetAir, TractorBeamTurret.this.targetGround));
            }
            if (this.target != null && TractorBeamTurret.this.coolant != null) {
                float maxUsed = TractorBeamTurret.this.coolant.amount;
                Liquid liquid = this.liquids.current();
                float used = Math.min(Math.min(this.liquids.get(liquid), maxUsed * Time.delta), Math.max(0.0f, 1.0f / this.coolantMultiplier / liquid.heatCapacity));
                this.liquids.remove(liquid, used);
                if (Mathf.chance(0.06 * (double)used)) {
                    TractorBeamTurret.this.coolEffect.at(this.x + Mathf.range((float)(TractorBeamTurret.this.size * 8) / 2.0f), this.y + Mathf.range((float)(TractorBeamTurret.this.size * 8) / 2.0f));
                }
                this.coolantMultiplier = 1.0f + used * liquid.heatCapacity * this.coolantMultiplier;
            }
            this.any = false;
            if (this.target != null && this.target.within(this, TractorBeamTurret.this.range + this.target.hitSize / 2.0f) && this.target.team() != this.team && this.target.checkTarget(TractorBeamTurret.this.targetAir, TractorBeamTurret.this.targetGround) && this.efficiency > 0.02f) {
                if (!Vars.headless) {
                    Vars.control.sound.loop(TractorBeamTurret.this.shootSound, this, TractorBeamTurret.this.shootSoundVolume);
                }
                float dest = this.angleTo(this.target);
                this.rotation = Angles.moveToward(this.rotation, dest, TractorBeamTurret.this.rotateSpeed * edelta);
                this.lastX = this.target.x;
                this.lastY = this.target.y;
                this.strength = Mathf.lerpDelta(this.strength, 1.0f, 0.1f);
                if (Angles.within(this.rotation, dest, TractorBeamTurret.this.shootCone)) {
                    if (TractorBeamTurret.this.damage > 0.0f) {
                        this.target.damageContinuous(TractorBeamTurret.this.damage * eff * this.timeScale * Vars.state.rules.blockDamage(this.team));
                    }
                    if (TractorBeamTurret.this.status != StatusEffects.none) {
                        this.target.apply(TractorBeamTurret.this.status, TractorBeamTurret.this.statusDuration);
                    }
                    this.any = true;
                    this.target.impulseNet(Tmp.v1.set(this).sub(this.target).limit((TractorBeamTurret.this.force + (1.0f - this.target.dst(this) / TractorBeamTurret.this.range) * TractorBeamTurret.this.scaledForce) * edelta));
                }
            } else {
                this.strength = Mathf.lerpDelta(this.strength, 0.0f, 0.1f);
            }
        }

        @Override
        public boolean shouldConsume() {
            return super.shouldConsume() && this.target != null;
        }

        @Override
        public float estimateDps() {
            if (!this.any || TractorBeamTurret.this.damage <= 0.0f) {
                return 0.0f;
            }
            return TractorBeamTurret.this.damage * 60.0f * this.efficiency * this.coolantMultiplier;
        }

        @Override
        public void draw() {
            Draw.rect(TractorBeamTurret.this.baseRegion, this.x, this.y);
            Drawf.shadow(TractorBeamTurret.this.region, this.x - (float)TractorBeamTurret.this.size / 2.0f, this.y - (float)TractorBeamTurret.this.size / 2.0f, this.rotation - 90.0f);
            Draw.rect(TractorBeamTurret.this.region, this.x, this.y, this.rotation - 90.0f);
            if (this.any && !this.isPayload()) {
                Draw.z(100.0f);
                float ang = this.angleTo(this.lastX, this.lastY);
                Draw.mixcol(TractorBeamTurret.this.laserColor, Mathf.absin(4.0f, 0.6f));
                Drawf.laser(TractorBeamTurret.this.laser, TractorBeamTurret.this.laserStart, TractorBeamTurret.this.laserEnd, this.x + Angles.trnsx(ang, TractorBeamTurret.this.shootLength), this.y + Angles.trnsy(ang, TractorBeamTurret.this.shootLength), this.lastX, this.lastY, this.strength * this.efficiency * TractorBeamTurret.this.laserWidth);
                Draw.mixcol();
            }
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.rotation);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.rotation = read.f();
        }
    }
}

