/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.func.Intc;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Dialog;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.util.Log;
import mindustry.Vars;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.gen.Icon;
import mindustry.gen.Iconc;
import mindustry.graphics.Pal;
import mindustry.ui.Styles;

public class IconSelectDialog
extends Dialog {
    private Intc consumer = i -> Log.info("you have mere seconds");

    public IconSelectDialog() {
        this(true);
    }

    public IconSelectDialog(boolean allowLocked) {
        this.closeOnBack();
        this.setFillParent(true);
        this.cont.pane((Table t) -> this.resized(true, () -> {
            t.clearChildren();
            t.marginRight(19.0f);
            t.defaults().size(48.0f);
            t.button((Drawable)Icon.none, Styles.flati, () -> {
                this.hide();
                this.consumer.get(0);
            });
            int cols = (int)Math.min(20.0f, (float)Core.graphics.getWidth() / Scl.scl(52.0f));
            int i = 1;
            for (String string : Vars.accessibleIcons) {
                TextureRegionDrawable value = Icon.icons.get(string);
                t.button((Drawable)value, Styles.flati, () -> {
                    this.hide();
                    this.consumer.get(Iconc.codes.get(key));
                });
                if (++i % cols != 0) continue;
                t.row();
            }
            for (ContentType contentType : Vars.defaultContentIcons) {
                t.row();
                t.image().colspan(cols).growX().width(Float.NEGATIVE_INFINITY).height(3.0f).color(Pal.accent);
                t.row();
                i = 0;
                for (UnlockableContent u : Vars.content.getBy(contentType).as()) {
                    if (u.isHidden() || !allowLocked && !u.unlocked()) continue;
                    t.button(new TextureRegionDrawable(u.uiIcon), Styles.flati, 32.0f, () -> {
                        this.hide();
                        this.consumer.get(u.emojiChar());
                    });
                    if (++i % cols != 0) continue;
                    t.row();
                }
            }
        }));
        this.buttons.button("@back", Icon.left, this::hide).size(210.0f, 64.0f);
    }

    public void show(Intc listener) {
        this.consumer = listener;
        super.show();
    }
}

