/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui;

import arc.Core;
import arc.func.Floatp;
import arc.func.Prov;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Font;
import arc.graphics.g2d.GlyphLayout;
import arc.graphics.g2d.ScissorStack;
import arc.math.Mathf;
import arc.math.geom.Rect;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.ui.layout.Scl;
import arc.util.pooling.Pools;
import mindustry.gen.Tex;
import mindustry.ui.Fonts;

public class Bar
extends Element {
    private static Rect scissor = new Rect();
    private Floatp fraction;
    private CharSequence name = "";
    private float value;
    private float lastValue;
    private float blink;
    private float outlineRadius;
    private Color blinkColor = new Color();
    private Color outlineColor = new Color();

    public Bar(String name, Color color, Floatp fraction) {
        this.fraction = fraction;
        this.name = Core.bundle.get(name, name);
        this.blinkColor.set(color);
        this.lastValue = this.value = fraction.get();
        this.setColor(color);
    }

    public Bar(Prov<CharSequence> name, Prov<Color> color, Floatp fraction) {
        this.fraction = fraction;
        this.lastValue = this.value = Mathf.clamp(fraction.get());
        this.update(() -> {
            this.name = (CharSequence)name.get();
            this.blinkColor.set((Color)color.get());
            this.setColor((Color)color.get());
        });
    }

    public Bar() {
    }

    public void reset(float value) {
        this.lastValue = this.blink = value;
        this.value = this.blink;
    }

    public void set(Prov<String> name, Floatp fraction, Color color) {
        this.fraction = fraction;
        this.lastValue = fraction.get();
        this.blinkColor.set(color);
        this.setColor(color);
        this.update(() -> {
            this.name = (CharSequence)name.get();
        });
    }

    public void snap() {
        this.lastValue = this.value = this.fraction.get();
    }

    public Bar outline(Color color, float stroke) {
        this.outlineColor.set(color);
        this.outlineRadius = Scl.scl(stroke);
        return this;
    }

    public void flash() {
        this.blink = 1.0f;
    }

    public Bar blink(Color color) {
        this.blinkColor.set(color);
        return this;
    }

    @Override
    public void draw() {
        if (this.fraction == null) {
            return;
        }
        float computed = Mathf.clamp(this.fraction.get());
        if (this.lastValue > computed) {
            this.blink = 1.0f;
            this.lastValue = computed;
        }
        if (Float.isNaN(this.lastValue)) {
            this.lastValue = 0.0f;
        }
        if (Float.isInfinite(this.lastValue)) {
            this.lastValue = 1.0f;
        }
        if (Float.isNaN(this.value)) {
            this.value = 0.0f;
        }
        if (Float.isInfinite(this.value)) {
            this.value = 1.0f;
        }
        if (Float.isNaN(computed)) {
            computed = 0.0f;
        }
        if (Float.isInfinite(computed)) {
            computed = 1.0f;
        }
        this.blink = Mathf.lerpDelta(this.blink, 0.0f, 0.2f);
        this.value = Mathf.lerpDelta(this.value, computed, 0.15f);
        Drawable bar = Tex.bar;
        if (this.outlineRadius > 0.0f) {
            Draw.color(this.outlineColor);
            bar.draw(this.x - this.outlineRadius, this.y - this.outlineRadius, this.width + this.outlineRadius * 2.0f, this.height + this.outlineRadius * 2.0f);
        }
        Draw.colorl(0.1f);
        Draw.alpha(this.parentAlpha);
        bar.draw(this.x, this.y, this.width, this.height);
        Draw.color(this.color, this.blinkColor, this.blink);
        Draw.alpha(this.parentAlpha);
        Drawable top = Tex.barTop;
        float topWidth = this.width * this.value;
        if (topWidth > (float)Core.atlas.find((String)"bar-top").width) {
            top.draw(this.x, this.y, topWidth, this.height);
        } else if (ScissorStack.push(scissor.set(this.x, this.y, topWidth, this.height))) {
            top.draw(this.x, this.y, Core.atlas.find((String)"bar-top").width, this.height);
            ScissorStack.pop();
        }
        Draw.color();
        Font font = Fonts.outline;
        GlyphLayout lay = Pools.obtain(GlyphLayout.class, GlyphLayout::new);
        lay.setText(font, this.name);
        font.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        font.getCache().clear();
        font.getCache().addText(this.name, this.x + this.width / 2.0f - lay.width / 2.0f, this.y + this.height / 2.0f + lay.height / 2.0f + 1.0f);
        font.getCache().draw(this.parentAlpha);
        Pools.free(lay);
    }
}

