/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps.filters;

import arc.math.Mathf;
import arc.struct.IntSeq;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.maps.filters.FilterOption;
import mindustry.maps.filters.GenerateFilter;
import mindustry.world.Tile;

public class OreMedianFilter
extends GenerateFilter {
    private static IntSeq blocks = new IntSeq();
    public float radius = 2.0f;
    public float percentile = 0.5f;

    @Override
    public FilterOption[] options() {
        return new FilterOption.SliderOption[]{new FilterOption.SliderOption("radius", () -> this.radius, f -> {
            this.radius = f;
        }, 1.0f, 12.0f), new FilterOption.SliderOption("percentile", () -> this.percentile, f -> {
            this.percentile = f;
        }, 0.0f, 1.0f)};
    }

    @Override
    public boolean isBuffered() {
        return true;
    }

    @Override
    public char icon() {
        return '\uf8c3';
    }

    @Override
    public void apply(GenerateFilter.GenerateInput in) {
        if (in.overlay == Blocks.spawn) {
            return;
        }
        int cx = in.x / 2 * 2;
        int cy = in.y / 2 * 2;
        if (in.overlay != Blocks.air && (in.tile(cx + 1, cy).overlay() != in.overlay || in.tile(cx, cy).overlay() != in.overlay || in.tile(cx + 1, cy + 1).overlay() != in.overlay || in.tile(cx, cy + 1).overlay() != in.overlay || in.tile(cx + 1, cy).block().isStatic() || in.tile(cx, cy).block().isStatic() || in.tile(cx + 1, cy + 1).block().isStatic() || in.tile(cx, cy + 1).block().isStatic())) {
            in.overlay = Blocks.air;
        }
        int rad = (int)this.radius;
        blocks.clear();
        for (int x = -rad; x <= rad; ++x) {
            for (int y = -rad; y <= rad; ++y) {
                Tile tile;
                if (Mathf.dst2(x, y) > (float)(rad * rad) || (tile = in.tile(in.x + x, in.y + y)).overlay() == Blocks.spawn) continue;
                blocks.add(tile.overlay().id);
            }
        }
        blocks.sort();
        int index = Math.min((int)((float)OreMedianFilter.blocks.size * this.percentile), OreMedianFilter.blocks.size - 1);
        int overlay = blocks.get(index);
        in.overlay = Vars.content.block(overlay);
    }
}

