/*
 * Decompiled with CFR 0.152.
 */
package mindustry.logic;

import arc.Core;
import arc.func.Cons;
import arc.func.Prov;
import arc.graphics.Color;
import arc.input.KeyCode;
import arc.scene.actions.Actions;
import arc.scene.style.Drawable;
import arc.scene.ui.Image;
import arc.scene.ui.Label;
import arc.scene.ui.TextButton;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Table;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Time;
import java.util.Locale;
import mindustry.Vars;
import mindustry.core.GameState;
import mindustry.ctype.Content;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Icon;
import mindustry.gen.LogicIO;
import mindustry.gen.Tex;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.logic.GlobalVarsDialog;
import mindustry.logic.LCanvas;
import mindustry.logic.LCategory;
import mindustry.logic.LExecutor;
import mindustry.logic.LStatement;
import mindustry.logic.LStatements;
import mindustry.logic.LVar;
import mindustry.ui.Fonts;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;

public class LogicDialog
extends BaseDialog {
    public LCanvas canvas;
    Cons<String> consumer = s -> {};
    boolean privileged;
    @Nullable
    LExecutor executor;
    GlobalVarsDialog globalsDialog = new GlobalVarsDialog();
    boolean wasRows;
    boolean wasPortrait;
    boolean forceRestart;

    public LogicDialog() {
        super("logic");
        this.clearChildren();
        this.canvas = new LCanvas();
        this.shouldPause = true;
        this.addCloseListener();
        this.shown(this::setup);
        this.shown(() -> {
            this.wasRows = LCanvas.useRows();
            this.wasPortrait = Core.graphics.isPortrait();
        });
        this.hidden(() -> this.consumer.get(this.canvas.save()));
        this.onResize(() -> {
            if (this.wasRows != LCanvas.useRows() || this.wasPortrait != Core.graphics.isPortrait()) {
                this.setup();
                this.canvas.rebuild();
                this.wasPortrait = Core.graphics.isPortrait();
                this.wasRows = LCanvas.useRows();
            }
        });
        this.keyDown(KeyCode.enter, () -> {
            if (Core.input.shift()) {
                this.showAddDialog();
            }
        });
        this.add(this.canvas).grow().name("canvas");
        this.row();
        this.add(this.buttons).growX().name("canvas");
    }

    public static Color typeColor(LVar s, Color color) {
        return color.set(!s.isobj ? Pal.place : (s.objval == null ? Color.darkGray : (s.objval instanceof String ? Pal.ammo : (s.objval instanceof Content ? Pal.logicOperations : (s.objval instanceof Building ? Pal.logicBlocks : (s.objval instanceof Unit ? Pal.logicUnits : (s.objval instanceof Team ? Pal.logicUnits : (s.objval instanceof Enum ? Pal.logicIo : Color.white))))))));
    }

    public static String typeName(LVar s) {
        return !s.isobj ? "number" : (s.objval == null ? "null" : (s.objval instanceof String ? "string" : (s.objval instanceof Content ? "content" : (s.objval instanceof Building ? "building" : (s.objval instanceof Team ? "team" : (s.objval instanceof Unit ? "unit" : (s.objval instanceof Enum ? "enum" : "unknown")))))));
    }

    private void setup() {
        this.buttons.clearChildren();
        this.buttons.defaults().size(160.0f, 64.0f);
        this.buttons.button("@back", Icon.left, this::hide).name("back");
        this.buttons.button("@edit", Icon.edit, () -> {
            BaseDialog dialog = new BaseDialog("@editor.export");
            dialog.cont.pane((Table p) -> {
                p.margin(10.0f);
                p.table(Tex.button, t -> {
                    TextButton.TextButtonStyle style = Styles.flatt;
                    t.defaults().size(280.0f, 60.0f).left();
                    if (this.privileged && this.executor != null && this.executor.build != null && !Vars.ui.editor.isShown()) {
                        t.button("@editor.worldprocessors.editname", (Drawable)Icon.edit, style, () -> {
                            Vars.ui.showTextInput("", "@editor.name", 32, this.executor.build.tag == null ? "" : this.executor.build.tag, tag -> {
                                if (this.privileged && this.executor != null && this.executor.build != null) {
                                    this.executor.build.configure(tag);
                                    this.executor.build.tag = tag;
                                }
                            });
                            dialog.hide();
                        }).marginLeft(12.0f).row();
                    }
                    t.button("@clear", (Drawable)Icon.cancel, style, () -> {
                        Vars.ui.showConfirm("@logic.clear.confirm", () -> this.canvas.clearStatements());
                        dialog.hide();
                    }).marginLeft(12.0f).row();
                    t.button("@schematic.copy", (Drawable)Icon.copy, style, () -> {
                        dialog.hide();
                        Core.app.setClipboardText(this.canvas.save());
                    }).marginLeft(12.0f).row();
                    t.button("@schematic.copy.import", (Drawable)Icon.download, style, () -> {
                        dialog.hide();
                        try {
                            this.canvas.load(Core.app.getClipboardText().replace("\r\n", "\n"));
                        }
                        catch (Throwable e) {
                            Vars.ui.showException(e);
                        }
                    }).marginLeft(12.0f).disabled(b -> Core.app.getClipboardText() == null).row();
                    t.button("@logic.restart", (Drawable)Icon.refresh, style, () -> {
                        this.forceRestart = true;
                        dialog.hide();
                        this.hide();
                    }).marginLeft(12.0f);
                });
            });
            dialog.addCloseButton();
            dialog.show();
        }).name("edit");
        if (Core.graphics.isPortrait()) {
            this.buttons.row();
        }
        this.buttons.button("@variables", Icon.menu, () -> {
            if (!this.shouldShowVariables()) {
                this.globalsDialog.show();
                return;
            }
            BaseDialog dialog = new BaseDialog("@variables");
            dialog.hidden(() -> {
                if (!(this.wasPaused || Vars.net.active() || Vars.state.isMenu())) {
                    Vars.state.set(GameState.State.paused);
                }
            });
            dialog.shown(() -> {
                if (!(this.wasPaused || Vars.net.active() || Vars.state.isMenu())) {
                    Vars.state.set(GameState.State.playing);
                }
            });
            dialog.cont.pane((Table p) -> {
                p.margin(10.0f).marginRight(16.0f);
                p.table(Tex.button, t -> {
                    t.defaults().fillX().height(45.0f);
                    for (final LVar s : this.executor.vars) {
                        if (s.constant) continue;
                        Color varColor = Pal.gray;
                        float stub = 8.0f;
                        float mul = 0.5f;
                        float pad = 4.0f;
                        t.add(new Image(Tex.whiteui, varColor.cpy().mul(mul))).width(stub);
                        t.stack(new Image(Tex.whiteui, varColor), new Label(" " + s.name + " ", Styles.outlineLabel){
                            {
                                this.setColor(Pal.accent);
                            }
                        }).padRight(pad);
                        t.add(new Image(Tex.whiteui, Pal.gray.cpy().mul(mul))).width(stub);
                        t.table(Tex.pane, out -> {
                            float period = 15.0f;
                            float[] counter = new float[]{-1.0f};
                            Label label = out.add("").style(Styles.outlineLabel).padLeft(4.0f).padRight(4.0f).width(140.0f).wrap().get();
                            label.update(() -> {
                                block6: {
                                    String text;
                                    block5: {
                                        float f;
                                        if (counter[0] < 0.0f) break block5;
                                        counter[0] = counter[0] + Time.delta;
                                        if (!(f >= period)) break block6;
                                    }
                                    String string = s.isobj ? LExecutor.PrintI.toString(s.objval) : (text = Math.abs(s.numval - (double)Math.round(s.numval)) < 1.0E-5 ? Math.round(s.numval) + "" : s.numval + "");
                                    if (!label.textEquals(text)) {
                                        label.setText(text);
                                        if (counter[0] >= 0.0f) {
                                            label.actions(Actions.color(Pal.accent), Actions.color(Color.white, 0.2f));
                                        }
                                    }
                                    counter[0] = 0.0f;
                                }
                            });
                            label.act(1.0f);
                        }).padRight(pad);
                        t.add(new Image(Tex.whiteui, LogicDialog.typeColor(s, new Color()).mul(mul))).update((T i) -> i.setColor(LogicDialog.typeColor(s, i.color).mul(mul))).width(stub);
                        t.stack(new Image(Tex.whiteui, LogicDialog.typeColor(s, new Color())){
                            {
                                super(arg0, arg1);
                                this.update(() -> this.setColor(LogicDialog.typeColor(s, this.color)));
                            }
                        }, new Label(() -> " " + LogicDialog.typeName(s) + " "){
                            {
                                this.setStyle(Styles.outlineLabel);
                            }
                        }).minWidth(120.0f);
                        t.row();
                        t.add().growX().colspan(6).height(4.0f).row();
                    }
                });
            });
            dialog.addCloseButton();
            dialog.buttons.button("@logic.globals", Icon.list, () -> this.globalsDialog.show()).size(210.0f, 64.0f);
            dialog.show();
        }).name("variables").update((T b) -> {
            if (this.shouldShowVariables()) {
                b.setText("@variables");
            } else {
                b.setText("@logic.globals");
            }
        });
        this.buttons.button("@add", Icon.add, () -> this.showAddDialog()).disabled(t -> this.canvas.statements.getChildren().size >= LExecutor.maxInstructions);
        Core.app.post(this.canvas::rebuild);
    }

    public boolean shouldShowVariables() {
        return this.executor != null && this.executor.vars.length > 0 && !Vars.state.isMenu();
    }

    public void showAddDialog() {
        BaseDialog dialog = new BaseDialog("@add");
        dialog.cont.table((Table table) -> {
            String[] searchText = new String[]{""};
            Prov[] matched = new Prov[]{null};
            Runnable[] rebuild = new Runnable[]{() -> {}};
            table.background(Tex.button);
            table.table((Table s) -> {
                s.image(Icon.zoom).padRight(8.0f);
                TextField search = s.field(null, text -> {
                    searchText[0] = text;
                    rebuild[0].run();
                }).growX().get();
                search.setMessageText("@players.search");
                if (!Vars.mobile) {
                    Core.app.post(search::requestKeyboard);
                    search.keyDown(KeyCode.enter, () -> {
                        if (!searchText[0].isEmpty() && matched[0] != null) {
                            this.canvas.add((LStatement)matched[0].get());
                            dialog.hide();
                        }
                    });
                }
            }).growX().padBottom(4.0f).row();
            table.pane((Table t) -> {
                rebuild[0] = () -> {
                    t.clear();
                    String text = searchText[0].toLowerCase();
                    matched[0] = null;
                    for (Prov<LStatement> prov : LogicIO.allStatements) {
                        LStatement example = prov.get();
                        if (example instanceof LStatements.InvalidStatement || example.hidden() || example.privileged() && !this.privileged || example.nonPrivileged() && this.privileged || !text.isEmpty() && !example.name().toLowerCase(Locale.ROOT).contains(text) && !example.typeName().toLowerCase(Locale.ROOT).contains(text)) continue;
                        if (matched[0] == null) {
                            matched[0] = prov;
                        }
                        LCategory category = example.category();
                        Table cat = (Table)t.find(category.name);
                        if (cat == null) {
                            t.table((Table s) -> {
                                if (category.icon != null) {
                                    s.image(category.icon, Pal.darkishGray).left().size(15.0f).padRight(10.0f);
                                }
                                s.add(category.localized()).color(Pal.darkishGray).left().tooltip(category.description());
                                s.image(Tex.whiteui, Pal.darkishGray).left().height(5.0f).growX().padLeft(10.0f);
                            }).growX().pad(5.0f).padTop(10.0f);
                            t.row();
                            cat = t.table((Table c) -> c.top().left()).name(category.name).top().left().growX().fillY().get();
                            t.row();
                        }
                        TextButton.TextButtonStyle style = new TextButton.TextButtonStyle(Styles.flatt);
                        style.fontColor = category.color;
                        style.font = Fonts.outline;
                        cat.button(example.name(), style, () -> {
                            this.canvas.add((LStatement)prov.get());
                            dialog.hide();
                        }).size(130.0f, 50.0f).self(c -> LCanvas.tooltip(c, "lst." + example.name())).top().left();
                        if (cat.getChildren().size % 3 != 0) continue;
                        cat.row();
                    }
                };
                rebuild[0].run();
            }).grow();
        }).fill().maxHeight((float)Core.graphics.getHeight() * 0.8f);
        dialog.addCloseButton();
        dialog.show();
    }

    public void show(String code, LExecutor executor, boolean privileged, Cons<String> modified) {
        this.executor = executor;
        this.privileged = privileged;
        this.forceRestart = false;
        this.canvas.statements.clearChildren();
        this.canvas.rebuild();
        this.canvas.privileged = privileged;
        try {
            this.canvas.load(code);
        }
        catch (Throwable t) {
            Log.err(t);
            this.canvas.load("");
        }
        this.consumer = result -> {
            if (this.forceRestart || !result.equals(code)) {
                modified.get((String)result);
            }
        };
        this.show();
    }
}

