/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics;

import arc.math.geom.Vec2;
import arc.struct.Seq;
import java.util.Arrays;

public class Voronoi {
    private static final int LE = 0;
    private static final int RE = 1;
    int siteidx;
    Site[] sites;
    int nsites;
    float borderMinX;
    float borderMaxX;
    float borderMinY;
    float borderMaxY;
    float ymin;
    float deltay;
    int nvertices = 0;
    int nedges;
    Site bottomsite;
    int PQcount;
    int PQmin;
    int PQhashsize;
    Halfedge[] PQhash;
    int ELhashsize;
    Halfedge[] ELhash;
    Seq<GraphEdge> allEdges;
    float minDistanceBetweenSites = 1.0f;

    public static Seq<GraphEdge> generate(Vec2[] values, float minX, float maxX, float minY, float maxY) {
        return new Voronoi().generateVoronoi(values, minX, maxX, minY, maxY);
    }

    Seq<GraphEdge> generateVoronoi(Vec2[] values, float minX, float maxX, float minY, float maxY) {
        Edge e;
        Halfedge lbnd;
        float temp;
        this.allEdges = new Seq();
        this.nsites = values.length;
        float sn = (float)this.nsites + 4.0f;
        int rtsites = (int)Math.sqrt(sn);
        this.sites = new Site[this.nsites];
        Vec2 first = values[0];
        float xmin = first.x;
        this.ymin = first.y;
        float xmax = first.x;
        float ymax = first.y;
        for (int i = 0; i < this.nsites; ++i) {
            this.sites[i] = new Site();
            this.sites[i].coord.set(values[i]);
            this.sites[i].sitenbr = i;
            if (values[i].x < xmin) {
                xmin = values[i].x;
            } else if (values[i].x > xmax) {
                xmax = values[i].x;
            }
            if (values[i].y < this.ymin) {
                this.ymin = values[i].y;
                continue;
            }
            if (!(values[i].y > ymax)) continue;
            ymax = values[i].y;
        }
        Arrays.sort(this.sites, (p1, p2) -> {
            Vec2 s1 = p1.coord;
            Vec2 s2 = p2.coord;
            if (s1.y < s2.y) {
                return -1;
            }
            if (s1.y > s2.y) {
                return 1;
            }
            return Float.compare(s1.x, s2.x);
        });
        this.deltay = ymax - this.ymin;
        float deltax = xmax - xmin;
        if (minX > maxX) {
            temp = minX;
            minX = maxX;
            maxX = temp;
        }
        if (minY > maxY) {
            temp = minY;
            minY = maxY;
            maxY = temp;
        }
        this.borderMinX = minX;
        this.borderMinY = minY;
        this.borderMaxX = maxX;
        this.borderMaxY = maxY;
        this.siteidx = 0;
        this.PQcount = 0;
        this.PQmin = 0;
        this.PQhashsize = 4 * rtsites;
        this.PQhash = new Halfedge[this.PQhashsize];
        for (int i2 = 0; i2 < this.PQhashsize; ++i2) {
            this.PQhash[i2] = new Halfedge();
        }
        this.ELhashsize = 2 * rtsites;
        this.ELhash = new Halfedge[this.ELhashsize];
        for (int i1 = 0; i1 < this.ELhashsize; ++i1) {
            this.ELhash[i1] = null;
        }
        Halfedge ELleftend = this.newHe(null, 0);
        Halfedge ELrightend = this.newHe(null, 0);
        ELleftend.ELleft = null;
        ELleftend.ELright = ELrightend;
        ELrightend.ELleft = ELleftend;
        ELrightend.ELright = null;
        this.ELhash[0] = ELleftend;
        this.ELhash[this.ELhashsize - 1] = ELrightend;
        this.bottomsite = this.next();
        Site newsite = this.next();
        Vec2 newintstar = null;
        while (true) {
            Site p;
            Halfedge bisector;
            Site bot;
            Halfedge rbnd;
            if (this.PQcount != 0) {
                Vec2 answer = new Vec2();
                while (this.PQhash[this.PQmin].PQnext == null) {
                    ++this.PQmin;
                }
                answer.x = this.PQhash[this.PQmin].PQnext.vertex.coord.x;
                answer.y = this.PQhash[this.PQmin].PQnext.ystar;
                newintstar = answer;
            }
            if (newsite != null && (this.PQcount == 0 || newsite.coord.y < newintstar.y || newsite.coord.y == newintstar.y && newsite.coord.x < newintstar.x)) {
                Halfedge he;
                int bucket = (int)((newsite.coord.x - xmin) / deltax * (float)this.ELhashsize);
                if (bucket < 0) {
                    bucket = 0;
                }
                if (bucket >= this.ELhashsize) {
                    bucket = this.ELhashsize - 1;
                }
                if ((he = this.getHash(bucket)) == null) {
                    for (int i = 1; i < this.ELhashsize && (he = this.getHash(bucket - i)) == null && (he = this.getHash(bucket + i)) == null; ++i) {
                    }
                }
                if (he == ELleftend || he != ELrightend && this.right(he, newsite.coord)) {
                    while ((he = he.ELright) != ELrightend && this.right(he, newsite.coord)) {
                    }
                    he = he.ELleft;
                } else {
                    while ((he = he.ELleft) != ELleftend && !this.right(he, newsite.coord)) {
                    }
                }
                if (bucket > 0 && bucket < this.ELhashsize - 1) {
                    this.ELhash[bucket] = he;
                }
                lbnd = he;
                rbnd = lbnd.ELright;
                bot = this.rightreg(lbnd);
                e = this.bisect(bot, newsite);
                bisector = this.newHe(e, 0);
                this.insert(lbnd, bisector);
                p = this.intersect(lbnd, bisector);
                if (p != null) {
                    this.pqdelete(lbnd);
                    this.pqinsert(lbnd, p, p.coord.dst(newsite.coord));
                }
                lbnd = bisector;
                bisector = this.newHe(e, 1);
                this.insert(lbnd, bisector);
                p = this.intersect(bisector, rbnd);
                if (p != null) {
                    this.pqinsert(bisector, p, p.coord.dst(newsite.coord));
                }
                newsite = this.next();
                continue;
            }
            if (this.PQcount == 0) break;
            Halfedge curr = this.PQhash[this.PQmin].PQnext;
            this.PQhash[this.PQmin].PQnext = curr.PQnext;
            --this.PQcount;
            lbnd = curr;
            Halfedge llbnd = lbnd.ELleft;
            rbnd = lbnd.ELright;
            Halfedge rrbnd = rbnd.ELright;
            bot = this.leftReg(lbnd);
            Site top = this.rightreg(rbnd);
            Site v = lbnd.vertex;
            v.sitenbr = this.nvertices++;
            this.endpoint(lbnd.ELedge, lbnd.ELpm, v);
            this.endpoint(rbnd.ELedge, rbnd.ELpm, v);
            this.delete(lbnd);
            this.pqdelete(rbnd);
            this.delete(rbnd);
            int pm = 0;
            if (bot.coord.y > top.coord.y) {
                Site temp1 = bot;
                bot = top;
                top = temp1;
                pm = 1;
            }
            e = this.bisect(bot, top);
            bisector = this.newHe(e, pm);
            this.insert(llbnd, bisector);
            this.endpoint(e, 1 - pm, v);
            p = this.intersect(llbnd, bisector);
            if (p != null) {
                this.pqdelete(llbnd);
                this.pqinsert(llbnd, p, p.coord.dst(bot.coord));
            }
            if ((p = this.intersect(bisector, rrbnd)) == null) continue;
            this.pqinsert(bisector, p, p.coord.dst(bot.coord));
        }
        lbnd = ELleftend.ELright;
        while (lbnd != ELrightend) {
            e = lbnd.ELedge;
            this.clipLine(e);
            lbnd = lbnd.ELright;
        }
        return this.allEdges;
    }

    private Site next() {
        return this.siteidx < this.nsites ? this.sites[this.siteidx++] : null;
    }

    private Edge bisect(Site s1, Site s2) {
        Edge newedge = new Edge();
        newedge.reg[0] = s1;
        newedge.reg[1] = s2;
        newedge.ep[0] = null;
        newedge.ep[1] = null;
        float dx = s2.coord.x - s1.coord.x;
        float dy = s2.coord.y - s1.coord.y;
        float adx = dx > 0.0f ? dx : -dx;
        float ady = dy > 0.0f ? dy : -dy;
        newedge.c = s1.coord.x * dx + s1.coord.y * dy + (dx * dx + dy * dy) * 0.5f;
        if (adx > ady) {
            newedge.a = 1.0f;
            newedge.b = dy / dx;
            newedge.c /= dx;
        } else {
            newedge.b = 1.0f;
            newedge.a = dx / dy;
            newedge.c /= dy;
        }
        newedge.edgenbr = this.nedges++;
        return newedge;
    }

    private int pqbucket(Halfedge he) {
        int bucket = (int)((he.ystar - this.ymin) / this.deltay * (float)this.PQhashsize);
        if (bucket < 0) {
            bucket = 0;
        }
        if (bucket >= this.PQhashsize) {
            bucket = this.PQhashsize - 1;
        }
        if (bucket < this.PQmin) {
            this.PQmin = bucket;
        }
        return bucket;
    }

    private void pqinsert(Halfedge he, Site v, float offset) {
        Halfedge next;
        he.vertex = v;
        he.ystar = v.coord.y + offset;
        Halfedge last = this.PQhash[this.pqbucket(he)];
        while ((next = last.PQnext) != null && (he.ystar > next.ystar || he.ystar == next.ystar && v.coord.x > next.vertex.coord.x)) {
            last = next;
        }
        he.PQnext = last.PQnext;
        last.PQnext = he;
        ++this.PQcount;
    }

    private void pqdelete(Halfedge he) {
        if (he.vertex != null) {
            Halfedge last = this.PQhash[this.pqbucket(he)];
            while (last.PQnext != he) {
                last = last.PQnext;
            }
            last.PQnext = he.PQnext;
            --this.PQcount;
            he.vertex = null;
        }
    }

    private Halfedge newHe(Edge e, int pm) {
        Halfedge answer = new Halfedge();
        answer.ELedge = e;
        answer.ELpm = pm;
        answer.PQnext = null;
        answer.vertex = null;
        return answer;
    }

    private Site leftReg(Halfedge he) {
        if (he.ELedge == null) {
            return this.bottomsite;
        }
        return he.ELpm == 0 ? he.ELedge.reg[0] : he.ELedge.reg[1];
    }

    private void insert(Halfedge lb, Halfedge newHe) {
        newHe.ELleft = lb;
        newHe.ELright = lb.ELright;
        lb.ELright.ELleft = newHe;
        lb.ELright = newHe;
    }

    private void delete(Halfedge he) {
        he.ELleft.ELright = he.ELright;
        he.ELright.ELleft = he.ELleft;
        he.deleted = true;
    }

    private Halfedge getHash(int b) {
        if (b < 0 || b >= this.ELhashsize) {
            return null;
        }
        Halfedge he = this.ELhash[b];
        if (he == null || !he.deleted) {
            return he;
        }
        this.ELhash[b] = null;
        return null;
    }

    private void clipLine(Edge e) {
        Site s2;
        Site s1;
        float x2 = e.reg[1].coord.x;
        float x1 = e.reg[0].coord.x;
        float y2 = e.reg[1].coord.y;
        float y1 = e.reg[0].coord.y;
        if (Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1)) < (double)this.minDistanceBetweenSites) {
            return;
        }
        float pxmin = this.borderMinX;
        float pxmax = this.borderMaxX;
        float pymin = this.borderMinY;
        float pymax = this.borderMaxY;
        if ((double)e.a == 1.0 && (double)e.b >= 0.0) {
            s1 = e.ep[1];
            s2 = e.ep[0];
        } else {
            s1 = e.ep[0];
            s2 = e.ep[1];
        }
        if ((double)e.a == 1.0) {
            y1 = pymin;
            if (s1 != null && s1.coord.y > pymin) {
                y1 = s1.coord.y;
            }
            if (y1 > pymax) {
                y1 = pymax;
            }
            x1 = e.c - e.b * y1;
            y2 = pymax;
            if (s2 != null && s2.coord.y < pymax) {
                y2 = s2.coord.y;
            }
            if (y2 < pymin) {
                y2 = pymin;
            }
            if (x1 > pxmax & (x2 = e.c - e.b * y2) > pxmax | x1 < pxmin & x2 < pxmin) {
                return;
            }
            if (x1 > pxmax) {
                x1 = pxmax;
                y1 = (e.c - x1) / e.b;
            }
            if (x1 < pxmin) {
                x1 = pxmin;
                y1 = (e.c - x1) / e.b;
            }
            if (x2 > pxmax) {
                x2 = pxmax;
                y2 = (e.c - x2) / e.b;
            }
            if (x2 < pxmin) {
                x2 = pxmin;
                y2 = (e.c - x2) / e.b;
            }
        } else {
            x1 = pxmin;
            if (s1 != null && s1.coord.x > pxmin) {
                x1 = s1.coord.x;
            }
            if (x1 > pxmax) {
                x1 = pxmax;
            }
            y1 = e.c - e.a * x1;
            x2 = pxmax;
            if (s2 != null && s2.coord.x < pxmax) {
                x2 = s2.coord.x;
            }
            if (x2 < pxmin) {
                x2 = pxmin;
            }
            if (y1 > pymax & (y2 = e.c - e.a * x2) > pymax | y1 < pymin & y2 < pymin) {
                return;
            }
            if (y1 > pymax) {
                y1 = pymax;
                x1 = (e.c - y1) / e.a;
            }
            if (y1 < pymin) {
                y1 = pymin;
                x1 = (e.c - y1) / e.a;
            }
            if (y2 > pymax) {
                y2 = pymax;
                x2 = (e.c - y2) / e.a;
            }
            if (y2 < pymin) {
                y2 = pymin;
                x2 = (e.c - y2) / e.a;
            }
        }
        GraphEdge newEdge = new GraphEdge();
        this.allEdges.add(newEdge);
        newEdge.x1 = x1;
        newEdge.y1 = y1;
        newEdge.x2 = x2;
        newEdge.y2 = y2;
        newEdge.site1 = e.reg[0].sitenbr;
        newEdge.site2 = e.reg[1].sitenbr;
    }

    private void endpoint(Edge e, int lr, Site s) {
        e.ep[lr] = s;
        if (e.ep[1 - lr] == null) {
            return;
        }
        this.clipLine(e);
    }

    private boolean right(Halfedge el, Vec2 p) {
        boolean above;
        boolean rightOf;
        Edge e = el.ELedge;
        Site topsite = e.reg[1];
        boolean bl = rightOf = p.x > topsite.coord.x;
        if (rightOf && el.ELpm == 0) {
            return true;
        }
        if (!rightOf && el.ELpm == 1) {
            return false;
        }
        if ((double)e.a == 1.0) {
            float dyp = p.y - topsite.coord.y;
            float dxp = p.x - topsite.coord.x;
            boolean fast = false;
            if (!rightOf & (double)e.b < 0.0 | rightOf & (double)e.b >= 0.0) {
                fast = above = dyp >= e.b * dxp;
            } else {
                boolean bl2 = above = p.x + p.y * e.b > e.c;
                if ((double)e.b < 0.0) {
                    boolean bl3 = above = !above;
                }
                if (!above) {
                    fast = true;
                }
            }
            if (!fast) {
                float dxs = topsite.coord.x - e.reg[0].coord.x;
                boolean bl4 = above = (double)(e.b * (dxp * dxp - dyp * dyp)) < (double)(dxs * dyp) * (1.0 + 2.0 * (double)dxp / (double)dxs + (double)(e.b * e.b));
                if ((double)e.b < 0.0) {
                    above = !above;
                }
            }
        } else {
            float yl = e.c - e.a * p.x;
            float t1 = p.y - yl;
            float t2 = p.x - topsite.coord.x;
            float t3 = yl - topsite.coord.y;
            above = t1 * t1 > t2 * t2 + t3 * t3;
        }
        return el.ELpm == 0 == above;
    }

    private Site rightreg(Halfedge he) {
        if (he.ELedge == null) {
            return this.bottomsite;
        }
        return he.ELpm == 0 ? he.ELedge.reg[1] : he.ELedge.reg[0];
    }

    private Site intersect(Halfedge el1, Halfedge el2) {
        boolean right_of_site;
        Edge e;
        Halfedge el;
        Edge e1 = el1.ELedge;
        Edge e2 = el2.ELedge;
        if (e1 == null || e2 == null) {
            return null;
        }
        if (e1.reg[1] == e2.reg[1]) {
            return null;
        }
        float d = e1.a * e2.b - e1.b * e2.a;
        if (-1.0E-10 < (double)d && (double)d < 1.0E-10) {
            return null;
        }
        float xint = (e1.c * e2.b - e2.c * e1.b) / d;
        float yint = (e2.c * e1.a - e1.c * e2.a) / d;
        if (e1.reg[1].coord.y < e2.reg[1].coord.y || e1.reg[1].coord.y == e2.reg[1].coord.y && e1.reg[1].coord.x < e2.reg[1].coord.x) {
            el = el1;
            e = e1;
        } else {
            el = el2;
            e = e2;
        }
        boolean bl = right_of_site = xint >= e.reg[1].coord.x;
        if (right_of_site && el.ELpm == 0 || !right_of_site && el.ELpm == 1) {
            return null;
        }
        Site v = new Site();
        v.coord.x = xint;
        v.coord.y = yint;
        return v;
    }

    static class Site {
        Vec2 coord = new Vec2();
        int sitenbr;

        Site() {
        }
    }

    static class Halfedge {
        Halfedge ELleft;
        Halfedge ELright;
        Edge ELedge;
        boolean deleted;
        int ELpm;
        Site vertex;
        float ystar;
        Halfedge PQnext;

        Halfedge() {
        }
    }

    static class Edge {
        float a = 0.0f;
        float b = 0.0f;
        float c = 0.0f;
        Site[] ep = new Site[2];
        Site[] reg = new Site[2];
        int edgenbr;

        Edge() {
        }
    }

    public static class GraphEdge {
        public float x1;
        public float y1;
        public float x2;
        public float y2;
        public int site1;
        public int site2;
    }
}

