/*
 * Decompiled with CFR 0.152.
 */
package mindustry.game;

import arc.Core;
import arc.Events;
import arc.assets.AssetDescriptor;
import arc.files.Fi;
import arc.graphics.Texture;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Strings;
import arc.util.Time;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.Future;
import mindustry.Vars;
import mindustry.core.GameState;
import mindustry.game.EventType;
import mindustry.game.Gamemode;
import mindustry.game.SectorInfo;
import mindustry.io.SaveIO;
import mindustry.io.SaveMeta;
import mindustry.io.SavePreviewLoader;
import mindustry.maps.Map;
import mindustry.type.Sector;
import mindustry.type.SectorPreset;
import mindustry.world.WorldContext;

public class Saves {
    private static final DateFormat dateFormat = SimpleDateFormat.getDateTimeInstance();
    Seq<SaveSlot> saves = new Seq();
    @Nullable
    SaveSlot current;
    @Nullable
    private SaveSlot lastSectorSave;
    private boolean saving;
    private float time;
    long totalPlaytime;
    private long lastTimestamp;

    public Saves() {
        Core.assets.setLoader(Texture.class, ".spreview", new SavePreviewLoader());
        Events.on(EventType.StateChangeEvent.class, event -> {
            if (event.to == GameState.State.menu) {
                this.totalPlaytime = 0L;
                this.lastTimestamp = 0L;
                this.current = null;
            }
        });
    }

    public void load() {
        this.saves.clear();
        Seq futures = new Seq();
        Vars.saveDirectory.walk(file -> {
            if (!file.name().contains("backup") && SaveIO.isSaveValid(file)) {
                futures.add(Vars.mainExecutor.submit(() -> {
                    SaveSlot slot = new SaveSlot((Fi)file);
                    slot.meta = SaveIO.getMeta(file);
                    return slot;
                }));
            }
        });
        for (Future future : futures) {
            try {
                this.saves.add((SaveSlot)future.get());
            }
            catch (Exception e) {
                Log.err(e);
            }
        }
        this.lastSectorSave = this.saves.find(s -> s.isSector() && s.getName().equals(Core.settings.getString("last-sector-save", "<none>")));
        class Remap {
            Fi sourceFile;
            SaveSlot slot;
            Sector sourceSector;
            SectorInfo sourceInfo;
            Fi destFile;
            Sector destSector;

            Remap(SaveSlot slot, Fi sourceFile, Sector sourceSector, SectorInfo sourceInfo, Fi destFile, Sector destSector) {
                this.slot = slot;
                this.sourceFile = sourceFile;
                this.sourceSector = sourceSector;
                this.sourceInfo = sourceInfo;
                this.destFile = destFile;
                this.destSector = destSector;
            }
        }
        Seq<Remap> remaps = new Seq<Remap>();
        ObjectSet<Sector> remapped = new ObjectSet<Sector>();
        for (SaveSlot slot : this.saves) {
            if (slot.getSector() == null) continue;
            Sector sector = slot.getSector();
            String name = (String)slot.meta.tags.get("sectorPreset");
            Sector remapTarget = null;
            if (name != null) {
                SectorPreset preset;
                if (!name.isEmpty() && (preset = Vars.content.sector(name)) != null && preset.sector != sector && preset.requireUnlock) {
                    remapTarget = preset.sector;
                }
            } else {
                SectorPreset target = Vars.content.sectors().find(s -> s.planet == sector.planet && s.originalPosition == sector.id);
                if (target != null && target.sector != sector && target.requireUnlock) {
                    remapTarget = target.sector;
                }
            }
            if (remapTarget != null) {
                if (!slot.file.equals(this.getSectorFile(remapTarget))) {
                    Log.info("Remapping sector: @ -> @ (@)", sector.id, remapTarget.id, remapTarget.preset);
                    try {
                        SectorInfo info = Core.settings.getJson(sector.planet.name + "-s-" + sector.id + "-info", SectorInfo.class, SectorInfo::new);
                        Fi tmpRemapFile = Vars.saveDirectory.child("remap_" + sector.planet.name + "_" + sector.id + "." + "msav");
                        slot.file.moveTo(tmpRemapFile);
                        remaps.add(new Remap(slot, tmpRemapFile, sector, info, this.getSectorFile(remapTarget), remapTarget));
                        remapped.add(remapTarget);
                    }
                    catch (Exception e) {
                        Log.err("Failed to move sector files when remapping: " + sector.id + " -> " + remapTarget.id, e);
                    }
                }
                remapTarget.save = slot;
                slot.meta.rules.sector = remapTarget;
                continue;
            }
            if (sector.save != null) {
                Log.warn("Sector @ has two corresponding saves: @ and @", sector, sector.save.file, slot.file);
            }
            sector.save = slot;
        }
        for (Remap remap : remaps) {
            Sector remapTarget = remap.destSector;
            Core.settings.putJson(remapTarget.planet.name + "-s-" + remapTarget.id + "-info", remap.sourceInfo);
            remapTarget.loadInfo();
            remapTarget.save = remap.slot;
            try {
                remap.sourceFile.moveTo(remap.destFile);
                remap.slot.file = remap.destFile;
            }
            catch (Exception e) {
                Log.err("Failed to move back sector files when remapping: " + remap.sourceSector.id + " -> " + remapTarget.id, e);
            }
            if (remapped.contains(remap.sourceSector)) continue;
            remap.sourceSector.clearInfo();
        }
    }

    @Nullable
    public SaveSlot getLastSector() {
        return this.lastSectorSave;
    }

    @Nullable
    public SaveSlot getCurrent() {
        return this.current;
    }

    public void update() {
        if (!(this.current == null || !Vars.state.isGame() || Vars.state.isPaused() && Core.scene.hasDialog())) {
            if (this.lastTimestamp != 0L) {
                this.totalPlaytime += Time.timeSinceMillis(this.lastTimestamp);
            }
            this.lastTimestamp = Time.millis();
        }
        if (Vars.state.isGame() && !Vars.state.gameOver && this.current != null && this.current.isAutosave()) {
            this.time += Time.delta;
            if (this.time > (float)(Core.settings.getInt("saveinterval") * 60) && !Vars.disableSave) {
                this.saving = true;
                try {
                    this.current.save();
                }
                catch (Throwable t) {
                    Log.err(t);
                }
                Time.runTask(3.0f, () -> {
                    this.saving = false;
                });
                this.time = 0.0f;
            }
        } else {
            this.time = 0.0f;
        }
    }

    public long getTotalPlaytime() {
        return this.totalPlaytime;
    }

    public void resetSave() {
        this.current = null;
    }

    public boolean isSaving() {
        return this.saving;
    }

    public Fi getSectorFile(Sector sector) {
        return Vars.saveDirectory.child("sector-" + sector.planet.name + "-" + sector.id + "." + "msav");
    }

    public void saveSector(Sector sector) {
        if (sector.save == null) {
            sector.save = new SaveSlot(this.getSectorFile(sector));
            sector.save.setName(sector.save.file.nameWithoutExtension());
            this.saves.add(sector.save);
        }
        sector.save.setAutosave(true);
        sector.save.save();
        this.lastSectorSave = sector.save;
        Core.settings.put("last-sector-save", sector.save.getName());
    }

    public SaveSlot addSave(String name) {
        SaveSlot slot = new SaveSlot(this.getNextSlotFile());
        slot.setName(name);
        this.saves.add(slot);
        slot.save();
        return slot;
    }

    public SaveSlot importSave(Fi file) throws IOException {
        SaveSlot slot = new SaveSlot(this.getNextSlotFile());
        slot.importFile(file);
        slot.setName(file.nameWithoutExtension());
        this.saves.add(slot);
        slot.meta = SaveIO.getMeta(slot.file);
        this.current = slot;
        return slot;
    }

    public Fi getNextSlotFile() {
        Fi file;
        int i = 0;
        while ((file = Vars.saveDirectory.child(i + "." + "msav")).exists()) {
            ++i;
        }
        return file;
    }

    public Seq<SaveSlot> getSaveSlots() {
        return this.saves;
    }

    public void deleteAll() {
        for (SaveSlot slot : this.saves.copy()) {
            if (slot.isSector()) continue;
            slot.delete();
        }
    }

    public class SaveSlot {
        public Fi file;
        boolean requestedPreview;
        public SaveMeta meta;

        public SaveSlot(Fi file) {
            this.file = file;
        }

        public void load() throws SaveIO.SaveException {
            this.load(Vars.world.context);
        }

        public void load(WorldContext context) throws SaveIO.SaveException {
            try {
                SaveIO.load(this.file, context);
                this.meta = SaveIO.getMeta(this.file);
                Saves.this.current = this;
                Saves.this.totalPlaytime = this.meta.timePlayed;
                this.savePreview();
            }
            catch (Throwable e) {
                throw new SaveIO.SaveException(e);
            }
        }

        public void save() {
            long prev = Saves.this.totalPlaytime;
            SaveIO.save(this.file);
            this.meta = SaveIO.getMeta(this.file);
            if (Vars.state.isGame()) {
                Saves.this.current = this;
            }
            Saves.this.totalPlaytime = prev;
            this.savePreview();
        }

        private void savePreview() {
            if (Core.assets.isLoaded(this.loadPreviewFile().path())) {
                Core.assets.unload(this.loadPreviewFile().path());
            }
            Vars.mainExecutor.submit(() -> {
                try {
                    this.previewFile().writePng(Vars.renderer.minimap.getPixmap());
                    this.requestedPreview = false;
                }
                catch (Throwable t) {
                    Log.err(t);
                }
            });
        }

        public Texture previewTexture() {
            if (!this.previewFile().exists()) {
                return null;
            }
            if (Core.assets.isLoaded(this.loadPreviewFile().path())) {
                return (Texture)Core.assets.get(this.loadPreviewFile().path());
            }
            if (!this.requestedPreview) {
                Core.assets.load(new AssetDescriptor<Texture>(this.loadPreviewFile(), Texture.class));
                this.requestedPreview = true;
            }
            return null;
        }

        private String index() {
            return this.file.nameWithoutExtension();
        }

        private Fi previewFile() {
            return Vars.mapPreviewDirectory.child("save_slot_" + this.index() + ".png");
        }

        private Fi loadPreviewFile() {
            return this.previewFile().sibling(this.previewFile().name() + ".spreview");
        }

        public boolean isHidden() {
            return this.isSector();
        }

        public String getPlayTime() {
            return Strings.formatMillis(Saves.this.current == this ? Saves.this.totalPlaytime : this.meta.timePlayed);
        }

        public long getTimestamp() {
            return this.meta.timestamp;
        }

        public String getDate() {
            return dateFormat.format(new Date(this.meta.timestamp));
        }

        public Map getMap() {
            return this.meta.map;
        }

        public void cautiousLoad(Runnable run) {
            Seq<String> mods = Seq.with(this.getMods());
            mods.removeAll(Vars.mods.getModStrings());
            if (!mods.isEmpty()) {
                Vars.ui.showConfirm("@warning", Core.bundle.format("mod.missing", mods.toString("\n")), run);
            } else {
                run.run();
            }
        }

        public String getName() {
            return Core.settings.getString("save-" + this.index() + "-name", "untitled");
        }

        public void setName(String name) {
            Core.settings.put("save-" + this.index() + "-name", name);
        }

        public String[] getMods() {
            return this.meta.mods;
        }

        @Nullable
        public Sector getSector() {
            return this.meta == null || this.meta.rules == null ? null : this.meta.rules.sector;
        }

        public boolean isSector() {
            return this.getSector() != null;
        }

        public Gamemode mode() {
            return this.meta.rules.mode();
        }

        public int getBuild() {
            return this.meta.build;
        }

        public int getWave() {
            return this.meta.wave;
        }

        public boolean isAutosave() {
            return Core.settings.getBool("save-" + this.index() + "-autosave", true);
        }

        public void setAutosave(boolean save) {
            Core.settings.put("save-" + this.index() + "-autosave", save);
        }

        public void importFile(Fi from) throws IOException {
            try {
                from.copyTo(this.file);
                if (this.previewFile().exists()) {
                    this.requestedPreview = false;
                    this.previewFile().delete();
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        public void exportFile(Fi to) throws IOException {
            try {
                this.file.copyTo(to);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        public void delete() {
            if (SaveIO.backupFileFor(this.file).exists()) {
                SaveIO.backupFileFor(this.file).delete();
            }
            this.file.delete();
            Saves.this.saves.remove(this, true);
            if (this == Saves.this.current) {
                Saves.this.current = null;
            }
            if (Core.assets.isLoaded(this.loadPreviewFile().path())) {
                Core.assets.unload(this.loadPreviewFile().path());
            }
        }
    }
}

