/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.effect;

import arc.graphics.Color;
import arc.math.Angles;
import mindustry.content.Fx;
import mindustry.entities.Effect;

public class RadialEffect
extends Effect {
    public Effect effect = Fx.none;
    public float rotationSpacing = 90.0f;
    public float rotationOffset = 0.0f;
    public float effectRotationOffset = 0.0f;
    public float lengthOffset = 0.0f;
    public int amount = 4;

    public RadialEffect() {
        this.clip = 100.0f;
    }

    public RadialEffect(Effect effect, int amount, float spacing, float lengthOffset, float effectRotationOffset) {
        this();
        this.amount = amount;
        this.effect = effect;
        this.effectRotationOffset = effectRotationOffset;
        this.rotationSpacing = spacing;
        this.lengthOffset = lengthOffset;
    }

    public RadialEffect(Effect effect, int amount, float spacing, float lengthOffset) {
        this(effect, amount, spacing, lengthOffset, 0.0f);
    }

    @Override
    public void create(float x, float y, float rotation, Color color, Object data) {
        if (!this.shouldCreate()) {
            return;
        }
        rotation += this.rotationOffset;
        for (int i = 0; i < this.amount; ++i) {
            this.effect.create(x + Angles.trnsx(rotation, this.lengthOffset), y + Angles.trnsy(rotation, this.lengthOffset), rotation + this.effectRotationOffset, color, data);
            rotation += this.rotationSpacing;
        }
    }
}

