/*
 * Decompiled with CFR 0.152.
 */
package arc.util.pooling;

import arc.func.Prov;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.pooling.Pool;

public class Pools {
    private static final ObjectMap<Class, Pool> typePools = new ObjectMap();

    private Pools() {
    }

    public static <T> Pool<T> get(Class<T> type, final Prov<T> supplier, int max) {
        Pool pool = typePools.get(type);
        if (pool == null) {
            pool = new Pool<T>(4, max){

                @Override
                protected T newObject() {
                    return supplier.get();
                }
            };
            typePools.put(type, pool);
        }
        return pool;
    }

    public static <T> Pool<T> get(Class<T> type, Prov<T> supplier) {
        return Pools.get(type, supplier, 5000);
    }

    public static <T> void set(Class<T> type, Pool<T> pool) {
        typePools.put(type, pool);
    }

    public static synchronized <T> T obtain(Class<T> type, Prov<T> supplier) {
        return Pools.get(type, supplier).obtain();
    }

    public static synchronized void free(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Object cannot be null.");
        }
        Pool pool = typePools.get(object.getClass());
        if (pool == null) {
            return;
        }
        pool.free(object);
    }

    public static void freeAll(Seq objects) {
        Pools.freeAll(objects, false);
    }

    public static void freeAll(Seq objects, boolean samePool) {
        if (objects == null) {
            throw new IllegalArgumentException("Objects cannot be null.");
        }
        Pool pool = null;
        int n = objects.size;
        for (int i = 0; i < n; ++i) {
            Object object = objects.get(i);
            if (object == null || pool == null && (pool = typePools.get(object.getClass())) == null) continue;
            pool.free(object);
            if (samePool) continue;
            pool = null;
        }
    }
}

