/*
 * Decompiled with CFR 0.152.
 */
package arc.math.geom;

import arc.math.geom.Vec3;
import arc.struct.Seq;

public class BoundingBox {
    public final Vec3 min = new Vec3();
    public final Vec3 max = new Vec3();
    private final Vec3 cnt = new Vec3();
    private final Vec3 dim = new Vec3();

    public BoundingBox() {
        this.clr();
    }

    public BoundingBox(BoundingBox bounds) {
        this.set(bounds);
    }

    public BoundingBox(Vec3 minimum, Vec3 maximum) {
        this.set(minimum, maximum);
    }

    static float min(float a, float b) {
        return a > b ? b : a;
    }

    static float max(float a, float b) {
        return a > b ? a : b;
    }

    public Vec3 getCenter(Vec3 out) {
        return out.set(this.cnt);
    }

    public float getCenterX() {
        return this.cnt.x;
    }

    public float getCenterY() {
        return this.cnt.y;
    }

    public float getCenterZ() {
        return this.cnt.z;
    }

    public Vec3 getCorner000(Vec3 out) {
        return out.set(this.min.x, this.min.y, this.min.z);
    }

    public Vec3 getCorner001(Vec3 out) {
        return out.set(this.min.x, this.min.y, this.max.z);
    }

    public Vec3 getCorner010(Vec3 out) {
        return out.set(this.min.x, this.max.y, this.min.z);
    }

    public Vec3 getCorner011(Vec3 out) {
        return out.set(this.min.x, this.max.y, this.max.z);
    }

    public Vec3 getCorner100(Vec3 out) {
        return out.set(this.max.x, this.min.y, this.min.z);
    }

    public Vec3 getCorner101(Vec3 out) {
        return out.set(this.max.x, this.min.y, this.max.z);
    }

    public Vec3 getCorner110(Vec3 out) {
        return out.set(this.max.x, this.max.y, this.min.z);
    }

    public Vec3 getCorner111(Vec3 out) {
        return out.set(this.max.x, this.max.y, this.max.z);
    }

    public Vec3 getDimensions(Vec3 out) {
        return out.set(this.dim);
    }

    public float getWidth() {
        return this.dim.x;
    }

    public float getHeight() {
        return this.dim.y;
    }

    public float getDepth() {
        return this.dim.z;
    }

    public Vec3 getMin(Vec3 out) {
        return out.set(this.min);
    }

    public Vec3 getMax(Vec3 out) {
        return out.set(this.max);
    }

    public BoundingBox set(BoundingBox bounds) {
        return this.set(bounds.min, bounds.max);
    }

    public BoundingBox set(Vec3 minimum, Vec3 maximum) {
        this.min.set(minimum.x < maximum.x ? minimum.x : maximum.x, minimum.y < maximum.y ? minimum.y : maximum.y, minimum.z < maximum.z ? minimum.z : maximum.z);
        this.max.set(minimum.x > maximum.x ? minimum.x : maximum.x, minimum.y > maximum.y ? minimum.y : maximum.y, minimum.z > maximum.z ? minimum.z : maximum.z);
        this.cnt.set(this.min).add(this.max).scl(0.5f);
        this.dim.set(this.max).sub(this.min);
        return this;
    }

    public BoundingBox set(Vec3[] points) {
        this.inf();
        for (Vec3 l_point : points) {
            this.ext(l_point);
        }
        return this;
    }

    public BoundingBox set(Seq<Vec3> points) {
        this.inf();
        for (Vec3 l_point : points) {
            this.ext(l_point);
        }
        return this;
    }

    public BoundingBox inf() {
        this.min.set(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
        this.max.set(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        this.cnt.set(0.0f, 0.0f, 0.0f);
        this.dim.set(0.0f, 0.0f, 0.0f);
        return this;
    }

    public BoundingBox ext(Vec3 point) {
        return this.set(this.min.set(BoundingBox.min(this.min.x, point.x), BoundingBox.min(this.min.y, point.y), BoundingBox.min(this.min.z, point.z)), this.max.set(Math.max(this.max.x, point.x), Math.max(this.max.y, point.y), Math.max(this.max.z, point.z)));
    }

    public BoundingBox clr() {
        return this.set(this.min.set(0.0f, 0.0f, 0.0f), this.max.set(0.0f, 0.0f, 0.0f));
    }

    public boolean isValid() {
        return this.min.x <= this.max.x && this.min.y <= this.max.y && this.min.z <= this.max.z;
    }

    public BoundingBox ext(BoundingBox a_bounds) {
        return this.set(this.min.set(BoundingBox.min(this.min.x, a_bounds.min.x), BoundingBox.min(this.min.y, a_bounds.min.y), BoundingBox.min(this.min.z, a_bounds.min.z)), this.max.set(BoundingBox.max(this.max.x, a_bounds.max.x), BoundingBox.max(this.max.y, a_bounds.max.y), BoundingBox.max(this.max.z, a_bounds.max.z)));
    }

    public BoundingBox ext(Vec3 center, float radius) {
        return this.set(this.min.set(BoundingBox.min(this.min.x, center.x - radius), BoundingBox.min(this.min.y, center.y - radius), BoundingBox.min(this.min.z, center.z - radius)), this.max.set(BoundingBox.max(this.max.x, center.x + radius), BoundingBox.max(this.max.y, center.y + radius), BoundingBox.max(this.max.z, center.z + radius)));
    }

    public boolean contains(BoundingBox b) {
        return !this.isValid() || this.min.x <= b.min.x && this.min.y <= b.min.y && this.min.z <= b.min.z && this.max.x >= b.max.x && this.max.y >= b.max.y && this.max.z >= b.max.z;
    }

    public boolean intersects(BoundingBox b) {
        if (!this.isValid()) {
            return false;
        }
        float lx = Math.abs(this.cnt.x - b.cnt.x);
        float sumx = this.dim.x / 2.0f + b.dim.x / 2.0f;
        float ly = Math.abs(this.cnt.y - b.cnt.y);
        float sumy = this.dim.y / 2.0f + b.dim.y / 2.0f;
        float lz = Math.abs(this.cnt.z - b.cnt.z);
        float sumz = this.dim.z / 2.0f + b.dim.z / 2.0f;
        return lx <= sumx && ly <= sumy && lz <= sumz;
    }

    public boolean contains(Vec3 v) {
        return this.min.x <= v.x && this.max.x >= v.x && this.min.y <= v.y && this.max.y >= v.y && this.min.z <= v.z && this.max.z >= v.z;
    }

    public String toString() {
        return "[" + this.min + "|" + this.max + "]";
    }

    public BoundingBox ext(float x, float y, float z) {
        return this.set(this.min.set(BoundingBox.min(this.min.x, x), BoundingBox.min(this.min.y, y), BoundingBox.min(this.min.z, z)), this.max.set(BoundingBox.max(this.max.x, x), BoundingBox.max(this.max.y, y), BoundingBox.max(this.max.z, z)));
    }
}

