/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics;

import arc.Core;
import arc.math.Mat;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;

public class Camera {
    private static final Vec2 tmpVector = new Vec2();
    public final Vec2 position = new Vec2();
    public final Mat mat = new Mat();
    public final Mat inv = new Mat();
    public float width;
    public float height;

    public void update() {
        this.mat.setOrtho(this.position.x - this.width / 2.0f, this.position.y - this.height / 2.0f, this.width, this.height);
        this.inv.set(this.mat).inv();
    }

    public void resize(float viewportWidth, float viewportHeight) {
        this.width = viewportWidth;
        this.height = viewportHeight;
        this.update();
    }

    public Vec2 unproject(Vec2 screenCoords, float viewportX, float viewportY, float viewportWidth, float viewportHeight) {
        float x = screenCoords.x - viewportX;
        float y = screenCoords.y - viewportY;
        screenCoords.x = 2.0f * x / viewportWidth - 1.0f;
        screenCoords.y = 2.0f * y / viewportHeight - 1.0f;
        screenCoords.mul(this.inv);
        return screenCoords;
    }

    public Vec2 unproject(Vec2 screenCoords) {
        this.unproject(screenCoords, 0.0f, 0.0f, Core.graphics.getWidth(), Core.graphics.getHeight());
        return screenCoords;
    }

    public Vec2 unproject(float screenX, float screenY) {
        this.unproject(tmpVector.set(screenX, screenY), 0.0f, 0.0f, Core.graphics.getWidth(), Core.graphics.getHeight());
        return tmpVector;
    }

    public Vec2 project(Vec2 worldCoords) {
        this.project(worldCoords, 0.0f, 0.0f, Core.graphics.getWidth(), Core.graphics.getHeight());
        return worldCoords;
    }

    public Vec2 project(float screenX, float screenY) {
        this.project(tmpVector.set(screenX, screenY), 0.0f, 0.0f, Core.graphics.getWidth(), Core.graphics.getHeight());
        return tmpVector;
    }

    public Vec2 project(Vec2 worldCoords, float viewportX, float viewportY, float viewportWidth, float viewportHeight) {
        worldCoords.mul(this.mat);
        worldCoords.x = viewportWidth * (worldCoords.x + 1.0f) / 2.0f + viewportX;
        worldCoords.y = viewportHeight * (worldCoords.y + 1.0f) / 2.0f + viewportY;
        return worldCoords;
    }

    public Rect bounds(Rect out) {
        return out.setSize(this.width, this.height).setCenter(this.position);
    }
}

