/*
 * Decompiled with CFR 0.152.
 */
package arc.flabel.effects;

import arc.flabel.FEffect;
import arc.flabel.FGlyph;
import arc.flabel.FLabel;
import arc.math.Interp;
import arc.math.Mathf;
import arc.struct.FloatSeq;

public class ShakeEffect
extends FEffect {
    private static final float defaultDistance = 0.12f;
    private static final float defaultIntensity = 0.5f;
    private final FloatSeq lastOffsets = new FloatSeq();
    public float distance = 1.0f;
    public float intensity = 1.0f;

    @Override
    protected void onApply(FLabel label, FGlyph glyph, int localIndex, float delta) {
        if (localIndex >= this.lastOffsets.size / 2) {
            this.lastOffsets.setSize(this.lastOffsets.size + 16);
        }
        float lastX = this.lastOffsets.get(localIndex * 2);
        float lastY = this.lastOffsets.get(localIndex * 2 + 1);
        float x = this.getLineHeight(label) * this.distance * (float)Mathf.random(-1, 1) * 0.12f;
        float y = this.getLineHeight(label) * this.distance * (float)Mathf.random(-1, 1) * 0.12f;
        float normalIntensity = Mathf.clamp(this.intensity * 0.5f, 0.0f, 1.0f);
        x = Interp.linear.apply(lastX, x, normalIntensity);
        y = Interp.linear.apply(lastY, y, normalIntensity);
        float fadeout = this.calculateFadeout();
        x *= fadeout;
        y *= fadeout;
        x = Math.round(x);
        y = Math.round(y);
        this.lastOffsets.set(localIndex * 2, x);
        this.lastOffsets.set(localIndex * 2 + 1, y);
        glyph.xoffset = (int)((float)glyph.xoffset + x);
        glyph.yoffset = (int)((float)glyph.yoffset + y);
    }
}

