/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nio.zipfs;

import com.sun.nio.zipfs.ZipConstants;
import com.sun.nio.zipfs.ZipFileSystem;
import com.sun.nio.zipfs.ZipFileSystemProvider;
import com.sun.nio.zipfs.ZipUtils;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;

public class ZipInfo {
    public static void main(String[] args) throws Throwable {
        if (args.length < 1) {
            ZipInfo.print("Usage: java ZipInfo zfname", new Object[0]);
        } else {
            Map env = Collections.emptyMap();
            ZipFileSystem zfs = (ZipFileSystem)new ZipFileSystemProvider().newFileSystem(Paths.get(args[0], new String[0]), env);
            byte[] cen = zfs.cen;
            if (cen == null) {
                ZipInfo.print("zip file is empty%n", new Object[0]);
                return;
            }
            int pos = 0;
            byte[] buf = new byte[1024];
            int no = 1;
            while (pos + 46 < cen.length) {
                ZipInfo.print("----------------#%d--------------------%n", no++);
                ZipInfo.printCEN(cen, pos);
                long len = 30 + ZipConstants.CENNAM(cen, pos) + ZipConstants.CENEXT(cen, pos) + 46;
                if (zfs.readFullyAt(buf, 0, len, ZipInfo.locoff(cen, pos)) != len) {
                    ZipFileSystem.zerror("read loc header failed");
                }
                if (ZipConstants.LOCEXT(buf) > ZipConstants.CENEXT(cen, pos) + 46 && zfs.readFullyAt(buf, 0, len = (long)(30 + ZipConstants.LOCNAM(buf) + ZipConstants.LOCEXT(buf)), ZipInfo.locoff(cen, pos)) != len) {
                    ZipFileSystem.zerror("read loc header failed");
                }
                ZipInfo.printLOC(buf);
                pos += 46 + ZipConstants.CENNAM(cen, pos) + ZipConstants.CENEXT(cen, pos) + ZipConstants.CENCOM(cen, pos);
            }
            zfs.close();
        }
    }

    static void print(String fmt, Object ... objs) {
        System.out.printf(fmt, objs);
    }

    static void printLOC(byte[] loc) {
        ZipInfo.print("%n", new Object[0]);
        ZipInfo.print("[Local File Header]%n", new Object[0]);
        ZipInfo.print("    Signature   :   %#010x%n", ZipConstants.LOCSIG(loc));
        if (ZipConstants.LOCSIG(loc) != ZipConstants.LOCSIG) {
            ZipInfo.print("    Wrong signature!", new Object[0]);
            return;
        }
        ZipInfo.print("    Version     :       %#6x    [%d.%d]%n", ZipConstants.LOCVER(loc), ZipConstants.LOCVER(loc) / 10, ZipConstants.LOCVER(loc) % 10);
        ZipInfo.print("    Flag        :       %#6x%n", ZipConstants.LOCFLG(loc));
        ZipInfo.print("    Method      :       %#6x%n", ZipConstants.LOCHOW(loc));
        ZipInfo.print("    LastMTime   :   %#10x    [%tc]%n", ZipConstants.LOCTIM(loc), ZipUtils.dosToJavaTime(ZipConstants.LOCTIM(loc)));
        ZipInfo.print("    CRC         :   %#10x%n", ZipConstants.LOCCRC(loc));
        ZipInfo.print("    CSize       :   %#10x%n", ZipConstants.LOCSIZ(loc));
        ZipInfo.print("    Size        :   %#10x%n", ZipConstants.LOCLEN(loc));
        ZipInfo.print("    NameLength  :       %#6x    [%s]%n", ZipConstants.LOCNAM(loc), new String(loc, 30, ZipConstants.LOCNAM(loc)));
        ZipInfo.print("    ExtraLength :       %#6x%n", ZipConstants.LOCEXT(loc));
        if (ZipConstants.LOCEXT(loc) != 0) {
            ZipInfo.printExtra(loc, 30 + ZipConstants.LOCNAM(loc), ZipConstants.LOCEXT(loc));
        }
    }

    static void printCEN(byte[] cen, int off) {
        ZipInfo.print("[Central Directory Header]%n", new Object[0]);
        ZipInfo.print("    Signature   :   %#010x%n", ZipConstants.CENSIG(cen, off));
        if (ZipConstants.CENSIG(cen, off) != ZipConstants.CENSIG) {
            ZipInfo.print("    Wrong signature!", new Object[0]);
            return;
        }
        ZipInfo.print("    VerMadeby   :       %#6x    [%d, %d.%d]%n", ZipConstants.CENVEM(cen, off), ZipConstants.CENVEM(cen, off) >> 8, (ZipConstants.CENVEM(cen, off) & 0xFF) / 10, (ZipConstants.CENVEM(cen, off) & 0xFF) % 10);
        ZipInfo.print("    VerExtract  :       %#6x    [%d.%d]%n", ZipConstants.CENVER(cen, off), ZipConstants.CENVER(cen, off) / 10, ZipConstants.CENVER(cen, off) % 10);
        ZipInfo.print("    Flag        :       %#6x%n", ZipConstants.CENFLG(cen, off));
        ZipInfo.print("    Method      :       %#6x%n", ZipConstants.CENHOW(cen, off));
        ZipInfo.print("    LastMTime   :   %#10x    [%tc]%n", ZipConstants.CENTIM(cen, off), ZipUtils.dosToJavaTime(ZipConstants.CENTIM(cen, off)));
        ZipInfo.print("    CRC         :   %#10x%n", ZipConstants.CENCRC(cen, off));
        ZipInfo.print("    CSize       :   %#10x%n", ZipConstants.CENSIZ(cen, off));
        ZipInfo.print("    Size        :   %#10x%n", ZipConstants.CENLEN(cen, off));
        ZipInfo.print("    NameLen     :       %#6x    [%s]%n", ZipConstants.CENNAM(cen, off), new String(cen, off + 46, ZipConstants.CENNAM(cen, off)));
        ZipInfo.print("    ExtraLen    :       %#6x%n", ZipConstants.CENEXT(cen, off));
        if (ZipConstants.CENEXT(cen, off) != 0) {
            ZipInfo.printExtra(cen, off + 46 + ZipConstants.CENNAM(cen, off), ZipConstants.CENEXT(cen, off));
        }
        ZipInfo.print("    CommentLen  :       %#6x%n", ZipConstants.CENCOM(cen, off));
        ZipInfo.print("    DiskStart   :       %#6x%n", ZipConstants.CENDSK(cen, off));
        ZipInfo.print("    Attrs       :       %#6x%n", ZipConstants.CENATT(cen, off));
        ZipInfo.print("    AttrsEx     :   %#10x%n", ZipConstants.CENATX(cen, off));
        ZipInfo.print("    LocOff      :   %#10x%n", ZipConstants.CENOFF(cen, off));
    }

    static long locoff(byte[] cen, int pos) {
        long locoff = ZipConstants.CENOFF(cen, pos);
        if (locoff == 0xFFFFFFFFL) {
            int off = pos + 46 + ZipConstants.CENNAM(cen, pos);
            int end = off + ZipConstants.CENEXT(cen, pos);
            while (off + 4 < end) {
                int tag = ZipConstants.SH(cen, off);
                int sz = ZipConstants.SH(cen, off + 2);
                if (tag != 1) {
                    off += 4 + sz;
                    continue;
                }
                off += 4;
                if (ZipConstants.CENLEN(cen, pos) == 0xFFFFFFFFL) {
                    off += 8;
                }
                if (ZipConstants.CENSIZ(cen, pos) == 0xFFFFFFFFL) {
                    off += 8;
                }
                return ZipConstants.LL(cen, off);
            }
        }
        return locoff;
    }

    static void printExtra(byte[] extra, int off, int len) {
        int end = off + len;
        while (off + 4 <= end) {
            int tag = ZipConstants.SH(extra, off);
            int sz = ZipConstants.SH(extra, off + 2);
            ZipInfo.print("        [tag=0x%04x, sz=%d, data= ", tag, sz);
            if (off + sz > end) {
                ZipInfo.print("    Error: Invalid extra data, beyond extra length", new Object[0]);
                break;
            }
            off += 4;
            for (int i = 0; i < sz; ++i) {
                ZipInfo.print("%02x ", extra[off + i]);
            }
            ZipInfo.print("]%n", new Object[0]);
            switch (tag) {
                case 1: {
                    ZipInfo.print("         ->ZIP64: ", new Object[0]);
                    int pos = off;
                    while (pos + 8 <= off + sz) {
                        ZipInfo.print(" *0x%x ", ZipConstants.LL(extra, pos));
                        pos += 8;
                    }
                    ZipInfo.print("%n", new Object[0]);
                    break;
                }
                case 10: {
                    ZipInfo.print("         ->PKWare NTFS%n", new Object[0]);
                    if (ZipConstants.SH(extra, off + 4) != 1 || ZipConstants.SH(extra, off + 6) != 24) {
                        ZipInfo.print("    Error: Invalid NTFS sub-tag or subsz", new Object[0]);
                    }
                    ZipInfo.print("            mtime:%tc%n", ZipUtils.winToJavaTime(ZipConstants.LL(extra, off + 8)));
                    ZipInfo.print("            atime:%tc%n", ZipUtils.winToJavaTime(ZipConstants.LL(extra, off + 16)));
                    ZipInfo.print("            ctime:%tc%n", ZipUtils.winToJavaTime(ZipConstants.LL(extra, off + 24)));
                    break;
                }
                case 21589: {
                    ZipInfo.print("         ->Info-ZIP Extended Timestamp: flag=%x%n", extra[off]);
                    int pos = off + 1;
                    while (pos + 4 <= off + sz) {
                        ZipInfo.print("            *%tc%n", ZipUtils.unixToJavaTime(ZipConstants.LG(extra, pos)));
                        pos += 4;
                    }
                    break;
                }
                default: {
                    ZipInfo.print("         ->[tag=%x, size=%d]%n", tag, sz);
                }
            }
            off += sz;
        }
    }
}

