/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale.provider;

import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.spi.CalendarNameProvider;
import sun.util.locale.provider.AvailableLanguageTags;
import sun.util.locale.provider.LocaleProviderAdapter;
import sun.util.locale.provider.LocaleResources;

public class CalendarNameProviderImpl
extends CalendarNameProvider
implements AvailableLanguageTags {
    private final LocaleProviderAdapter.Type type;
    private final Set<String> langtags;
    private static int[] REST_OF_STYLES = new int[]{32769, 2, 32770, 4, 32772};

    public CalendarNameProviderImpl(LocaleProviderAdapter.Type type, Set<String> langtags) {
        this.type = type;
        this.langtags = langtags;
    }

    @Override
    public String getDisplayName(String calendarType, int field, int value, int style, Locale locale) {
        return this.getDisplayNameImpl(calendarType, field, value, style, locale, false);
    }

    public String getJavaTimeDisplayName(String calendarType, int field, int value, int style, Locale locale) {
        return this.getDisplayNameImpl(calendarType, field, value, style, locale, true);
    }

    public String getDisplayNameImpl(String calendarType, int field, int value, int style, Locale locale, boolean javatime) {
        String name = null;
        String key = this.getResourceKey(calendarType, field, style, javatime);
        if (key != null) {
            String[] strings;
            LocaleResources lr = LocaleProviderAdapter.forType(this.type).getLocaleResources(locale);
            String[] stringArray = strings = javatime ? lr.getJavaTimeNames(key) : lr.getCalendarNames(key);
            if (strings != null && strings.length > 0) {
                if (field == 7 || field == 1) {
                    --value;
                }
                if (value < 0 || value >= strings.length) {
                    return null;
                }
                name = strings[value];
                if (name.length() == 0 && (style == 32769 || style == 32770 || style == 32772)) {
                    name = this.getDisplayName(calendarType, field, value, this.getBaseStyle(style), locale);
                }
            }
        }
        return name;
    }

    @Override
    public Map<String, Integer> getDisplayNames(String calendarType, int field, int style, Locale locale) {
        Map<String, Integer> names;
        if (style == 0) {
            names = this.getDisplayNamesImpl(calendarType, field, 1, locale, false);
            for (int st : REST_OF_STYLES) {
                names.putAll(this.getDisplayNamesImpl(calendarType, field, st, locale, false));
            }
        } else {
            names = this.getDisplayNamesImpl(calendarType, field, style, locale, false);
        }
        return names.isEmpty() ? null : names;
    }

    public Map<String, Integer> getJavaTimeDisplayNames(String calendarType, int field, int style, Locale locale) {
        Map<String, Integer> names = this.getDisplayNamesImpl(calendarType, field, style, locale, true);
        return names.isEmpty() ? null : names;
    }

    private Map<String, Integer> getDisplayNamesImpl(String calendarType, int field, int style, Locale locale, boolean javatime) {
        String key = this.getResourceKey(calendarType, field, style, javatime);
        TreeMap<String, Integer> map = new TreeMap<String, Integer>(LengthBasedComparator.INSTANCE);
        if (key != null) {
            String[] strings;
            LocaleResources lr = LocaleProviderAdapter.forType(this.type).getLocaleResources(locale);
            String[] stringArray = strings = javatime ? lr.getJavaTimeNames(key) : lr.getCalendarNames(key);
            if (strings != null && !this.hasDuplicates(strings)) {
                if (field == 1) {
                    if (strings.length > 0) {
                        map.put(strings[0], 1);
                    }
                } else {
                    int base = field == 7 ? 1 : 0;
                    for (int i = 0; i < strings.length; ++i) {
                        String name = strings[i];
                        if (name.length() == 0) continue;
                        map.put(name, base + i);
                    }
                }
            }
        }
        return map;
    }

    private int getBaseStyle(int style) {
        return style & 0xFFFF7FFF;
    }

    @Override
    public Locale[] getAvailableLocales() {
        return LocaleProviderAdapter.toLocaleArray(this.langtags);
    }

    @Override
    public boolean isSupportedLocale(Locale locale) {
        if (Locale.ROOT.equals(locale)) {
            return true;
        }
        String calendarType = null;
        if (locale.hasExtensions()) {
            calendarType = locale.getUnicodeLocaleType("ca");
            locale = locale.stripExtensions();
        }
        if (calendarType != null) {
            switch (calendarType) {
                case "buddhist": 
                case "japanese": 
                case "gregory": 
                case "islamic": 
                case "roc": {
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        if (this.langtags.contains(locale.toLanguageTag())) {
            return true;
        }
        if (this.type == LocaleProviderAdapter.Type.JRE) {
            String oldname = locale.toString().replace('_', '-');
            return this.langtags.contains(oldname);
        }
        return false;
    }

    @Override
    public Set<String> getAvailableLanguageTags() {
        return this.langtags;
    }

    private boolean hasDuplicates(String[] strings) {
        int len = strings.length;
        for (int i = 0; i < len - 1; ++i) {
            String a = strings[i];
            if (a == null) continue;
            for (int j = i + 1; j < len; ++j) {
                if (!a.equals(strings[j])) continue;
                return true;
            }
        }
        return false;
    }

    private String getResourceKey(String type, int field, int style, boolean javatime) {
        boolean isStandalone;
        int baseStyle = this.getBaseStyle(style);
        boolean bl = isStandalone = style != baseStyle;
        if ("gregory".equals(type)) {
            type = null;
        }
        boolean isNarrow = baseStyle == 4;
        StringBuilder key = new StringBuilder();
        if (javatime) {
            key.append("java.time.");
        }
        switch (field) {
            case 0: {
                if (type != null) {
                    key.append(type).append('.');
                }
                if (isNarrow) {
                    key.append("narrow.");
                } else if (this.type == LocaleProviderAdapter.Type.JRE) {
                    if (javatime && baseStyle == 2) {
                        key.append("long.");
                    }
                    if (baseStyle == 1) {
                        key.append("short.");
                    }
                } else if (baseStyle == 2) {
                    key.append("long.");
                }
                key.append("Eras");
                break;
            }
            case 1: {
                if (isNarrow) break;
                key.append(type).append(".FirstYear");
                break;
            }
            case 2: {
                if ("islamic".equals(type)) {
                    key.append(type).append('.');
                }
                if (isStandalone) {
                    key.append("standalone.");
                }
                key.append("Month").append(this.toStyleName(baseStyle));
                break;
            }
            case 7: {
                if (isStandalone && isNarrow) {
                    key.append("standalone.");
                }
                key.append("Day").append(this.toStyleName(baseStyle));
                break;
            }
            case 9: {
                if (isNarrow) {
                    key.append("narrow.");
                }
                key.append("AmPmMarkers");
            }
        }
        return key.length() > 0 ? key.toString() : null;
    }

    private String toStyleName(int baseStyle) {
        switch (baseStyle) {
            case 1: {
                return "Abbreviations";
            }
            case 4: {
                return "Narrows";
            }
        }
        return "Names";
    }

    private static class LengthBasedComparator
    implements Comparator<String> {
        private static final LengthBasedComparator INSTANCE = new LengthBasedComparator();

        private LengthBasedComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            int n = o2.length() - o1.length();
            return n == 0 ? o1.compareTo(o2) : n;
        }
    }
}

