/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools.policytool;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.text.MessageFormat;
import javax.swing.JTextField;
import sun.security.tools.policytool.PolicyTool;
import sun.security.tools.policytool.ToolDialog;
import sun.security.tools.policytool.ToolWindow;

class FileMenuListener
implements ActionListener {
    private PolicyTool tool;
    private ToolWindow tw;

    FileMenuListener(PolicyTool tool, ToolWindow tw) {
        this.tool = tool;
        this.tw = tw;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block17: {
            if (PolicyTool.collator.compare(e.getActionCommand(), "Exit") == 0) {
                ToolDialog td = new ToolDialog(PolicyTool.getMessage("Save.Changes"), this.tool, this.tw, true);
                td.displayUserSave(1);
            } else if (PolicyTool.collator.compare(e.getActionCommand(), "New") == 0) {
                ToolDialog td = new ToolDialog(PolicyTool.getMessage("Save.Changes"), this.tool, this.tw, true);
                td.displayUserSave(2);
            } else if (PolicyTool.collator.compare(e.getActionCommand(), "Open") == 0) {
                ToolDialog td = new ToolDialog(PolicyTool.getMessage("Save.Changes"), this.tool, this.tw, true);
                td.displayUserSave(3);
            } else if (PolicyTool.collator.compare(e.getActionCommand(), "Save") == 0) {
                String filename = ((JTextField)this.tw.getComponent(1)).getText();
                if (filename == null || filename.length() == 0) {
                    ToolDialog td = new ToolDialog(PolicyTool.getMessage("Save.As"), this.tool, this.tw, true);
                    td.displaySaveAsDialog(0);
                } else {
                    try {
                        this.tool.savePolicy(filename);
                        MessageFormat form = new MessageFormat(PolicyTool.getMessage("Policy.successfully.written.to.filename"));
                        Object[] source = new Object[]{filename};
                        this.tw.displayStatusDialog(null, form.format(source));
                    }
                    catch (FileNotFoundException fnfe) {
                        if (filename == null || filename.equals("")) {
                            this.tw.displayErrorDialog(null, new FileNotFoundException(PolicyTool.getMessage("null.filename")));
                            break block17;
                        }
                        this.tw.displayErrorDialog(null, fnfe);
                    }
                    catch (Exception ee) {
                        this.tw.displayErrorDialog(null, ee);
                    }
                }
            } else if (PolicyTool.collator.compare(e.getActionCommand(), "Save.As") == 0) {
                ToolDialog td = new ToolDialog(PolicyTool.getMessage("Save.As"), this.tool, this.tw, true);
                td.displaySaveAsDialog(0);
            } else if (PolicyTool.collator.compare(e.getActionCommand(), "View.Warning.Log") == 0) {
                this.tw.displayWarningLog(null);
            }
        }
    }
}

