/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.Security;
import java.security.UnresolvedPermission;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.security.auth.AuthPermission;
import javax.security.auth.Policy;
import javax.security.auth.PrivateCredentialPermission;
import javax.security.auth.Subject;
import sun.security.provider.PolicyParser;
import sun.security.provider.PolicyPermissions;
import sun.security.provider.SubjectCodeSource;
import sun.security.util.Debug;
import sun.security.util.PolicyUtil;
import sun.security.util.PropertyExpander;

@Deprecated
public class AuthPolicyFile
extends Policy {
    static final ResourceBundle rb = AccessController.doPrivileged(new PrivilegedAction<ResourceBundle>(){

        @Override
        public ResourceBundle run() {
            return ResourceBundle.getBundle("sun.security.util.AuthResources");
        }
    });
    private static final Debug debug = Debug.getInstance("policy", "\t[Auth Policy]");
    private static final String AUTH_POLICY = "java.security.auth.policy";
    private static final String SECURITY_MANAGER = "java.security.manager";
    private static final String AUTH_POLICY_URL = "auth.policy.url.";
    private Vector<PolicyEntry> policyEntries;
    private Hashtable<Object, Object> aliasMapping;
    private boolean initialized = false;
    private boolean expandProperties = true;
    private boolean ignoreIdentityScope = true;
    private static final Class<?>[] PARAMS = new Class[]{String.class, String.class};

    public AuthPolicyFile() {
        String prop = System.getProperty(AUTH_POLICY);
        if (prop == null) {
            prop = System.getProperty(SECURITY_MANAGER);
        }
        if (prop != null) {
            this.init();
        }
    }

    private synchronized void init() {
        if (this.initialized) {
            return;
        }
        this.policyEntries = new Vector();
        this.aliasMapping = new Hashtable(11);
        this.initPolicyFile();
        this.initialized = true;
    }

    @Override
    public synchronized void refresh() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthPermission("refreshPolicy"));
        }
        this.initialized = false;
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                AuthPolicyFile.this.init();
                return null;
            }
        });
    }

    private KeyStore initKeyStore(URL policyUrl, String keyStoreName, String keyStoreType) {
        if (keyStoreName != null) {
            try {
                URL keyStoreUrl = null;
                try {
                    keyStoreUrl = new URL(keyStoreName);
                }
                catch (MalformedURLException e) {
                    keyStoreUrl = new URL(policyUrl, keyStoreName);
                }
                if (debug != null) {
                    debug.println("reading keystore" + keyStoreUrl);
                }
                BufferedInputStream inStream = new BufferedInputStream(PolicyUtil.getInputStream(keyStoreUrl));
                KeyStore ks = keyStoreType != null ? KeyStore.getInstance(keyStoreType) : KeyStore.getInstance(KeyStore.getDefaultType());
                ks.load(inStream, null);
                ((InputStream)inStream).close();
                return ks;
            }
            catch (Exception e) {
                if (debug != null) {
                    e.printStackTrace();
                }
                return null;
            }
        }
        return null;
    }

    private void initPolicyFile() {
        String policy_url;
        String extra_policy;
        String allowSys;
        String iscp;
        String prop = Security.getProperty("policy.expandProperties");
        if (prop != null) {
            this.expandProperties = prop.equalsIgnoreCase("true");
        }
        if ((iscp = Security.getProperty("policy.ignoreIdentityScope")) != null) {
            this.ignoreIdentityScope = iscp.equalsIgnoreCase("true");
        }
        if ((allowSys = Security.getProperty("policy.allowSystemProperty")) != null && allowSys.equalsIgnoreCase("true") && (extra_policy = System.getProperty(AUTH_POLICY)) != null) {
            boolean overrideAll;
            block14: {
                overrideAll = false;
                if (extra_policy.startsWith("=")) {
                    overrideAll = true;
                    extra_policy = extra_policy.substring(1);
                }
                try {
                    extra_policy = PropertyExpander.expand(extra_policy);
                    File policyFile = new File(extra_policy);
                    URL policyURL = policyFile.exists() ? new URL("file:" + policyFile.getCanonicalPath()) : new URL(extra_policy);
                    if (debug != null) {
                        debug.println("reading " + policyURL);
                    }
                    this.init(policyURL);
                }
                catch (Exception e) {
                    if (debug == null) break block14;
                    debug.println("caught exception: " + e);
                }
            }
            if (overrideAll) {
                if (debug != null) {
                    debug.println("overriding other policies!");
                }
                return;
            }
        }
        int n = 1;
        boolean loaded_one = false;
        while ((policy_url = Security.getProperty(AUTH_POLICY_URL + n)) != null) {
            block15: {
                try {
                    policy_url = PropertyExpander.expand(policy_url).replace(File.separatorChar, '/');
                    if (debug != null) {
                        debug.println("reading " + policy_url);
                    }
                    this.init(new URL(policy_url));
                    loaded_one = true;
                }
                catch (Exception e) {
                    if (debug == null) break block15;
                    debug.println("error reading policy " + e);
                    e.printStackTrace();
                }
            }
            ++n;
        }
        if (!loaded_one) {
            // empty if block
        }
    }

    private boolean checkForTrustedIdentity(Certificate cert) {
        return false;
    }

    private void init(URL policy) {
        block17: {
            PolicyParser pp = new PolicyParser(this.expandProperties);
            try (InputStreamReader isr = new InputStreamReader(PolicyUtil.getInputStream(policy));){
                pp.read(isr);
                KeyStore keyStore = this.initKeyStore(policy, pp.getKeyStoreUrl(), pp.getKeyStoreType());
                Enumeration<PolicyParser.GrantEntry> enum_ = pp.grantElements();
                while (enum_.hasMoreElements()) {
                    PolicyParser.GrantEntry ge = enum_.nextElement();
                    this.addGrantEntry(ge, keyStore);
                }
            }
            catch (PolicyParser.ParsingException pe) {
                System.err.println(AUTH_POLICY + rb.getString(".error.parsing.") + policy);
                System.err.println(AUTH_POLICY + rb.getString("COLON") + pe.getMessage());
                if (debug != null) {
                    pe.printStackTrace();
                }
            }
            catch (Exception e) {
                if (debug == null) break block17;
                debug.println("error parsing " + policy);
                debug.println(e.toString());
                e.printStackTrace();
            }
        }
    }

    CodeSource getCodeSource(PolicyParser.GrantEntry ge, KeyStore keyStore) throws MalformedURLException {
        Certificate[] certs = null;
        if (ge.signedBy != null && (certs = this.getCertificates(keyStore, ge.signedBy)) == null) {
            if (debug != null) {
                debug.println(" no certs for alias " + ge.signedBy + ", ignoring.");
            }
            return null;
        }
        URL location = ge.codeBase != null ? new URL(ge.codeBase) : null;
        if (ge.principals == null || ge.principals.size() == 0) {
            return this.canonicalizeCodebase(new CodeSource(location, certs), false);
        }
        return this.canonicalizeCodebase(new SubjectCodeSource(null, ge.principals, location, certs), false);
    }

    private void addGrantEntry(PolicyParser.GrantEntry ge, KeyStore keyStore) {
        if (debug != null) {
            debug.println("Adding policy entry: ");
            debug.println("  signedBy " + ge.signedBy);
            debug.println("  codeBase " + ge.codeBase);
            if (ge.principals != null) {
                for (PolicyParser.PrincipalEntry pppe : ge.principals) {
                    debug.println("  " + pppe.getPrincipalClass() + " " + pppe.getPrincipalName());
                }
            }
            debug.println();
        }
        try {
            CodeSource codesource = this.getCodeSource(ge, keyStore);
            if (codesource == null) {
                return;
            }
            PolicyEntry entry = new PolicyEntry(codesource);
            Enumeration<PolicyParser.PermissionEntry> enum_ = ge.permissionElements();
            while (enum_.hasMoreElements()) {
                PolicyParser.PermissionEntry pe = enum_.nextElement();
                try {
                    Permission perm = pe.permission.equals("javax.security.auth.PrivateCredentialPermission") && pe.name.endsWith(" self") ? AuthPolicyFile.getInstance(pe.permission, pe.name + " \"self\"", pe.action) : AuthPolicyFile.getInstance(pe.permission, pe.name, pe.action);
                    entry.add(perm);
                    if (debug == null) continue;
                    debug.println("  " + perm);
                }
                catch (ClassNotFoundException cnfe) {
                    Certificate[] certs = pe.signedBy != null ? this.getCertificates(keyStore, pe.signedBy) : null;
                    if (certs == null && pe.signedBy != null) continue;
                    UnresolvedPermission perm = new UnresolvedPermission(pe.permission, pe.name, pe.action, certs);
                    entry.add(perm);
                    if (debug == null) continue;
                    debug.println("  " + perm);
                }
                catch (InvocationTargetException ite) {
                    System.err.println(AUTH_POLICY + rb.getString(".error.adding.Permission.") + pe.permission + rb.getString("SPACE") + ite.getTargetException());
                }
                catch (Exception e) {
                    System.err.println(AUTH_POLICY + rb.getString(".error.adding.Permission.") + pe.permission + rb.getString("SPACE") + e);
                }
            }
            this.policyEntries.addElement(entry);
        }
        catch (Exception e) {
            System.err.println(AUTH_POLICY + rb.getString(".error.adding.Entry.") + ge + rb.getString("SPACE") + e);
        }
        if (debug != null) {
            debug.println();
        }
    }

    private static final Permission getInstance(String type, String name, String actions) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class<?> pc = Class.forName(type);
        Constructor<?> c = pc.getConstructor(PARAMS);
        return (Permission)c.newInstance(name, actions);
    }

    Certificate[] getCertificates(KeyStore keyStore, String aliases) {
        Vector<Certificate> vcerts = null;
        StringTokenizer st = new StringTokenizer(aliases, ",");
        int n = 0;
        while (st.hasMoreTokens()) {
            String alias = st.nextToken().trim();
            ++n;
            Certificate cert = null;
            cert = (Certificate)this.aliasMapping.get(alias);
            if (cert == null && keyStore != null) {
                try {
                    cert = keyStore.getCertificate(alias);
                }
                catch (KeyStoreException keyStoreException) {
                    // empty catch block
                }
                if (cert != null) {
                    this.aliasMapping.put(alias, cert);
                    this.aliasMapping.put(cert, alias);
                }
            }
            if (cert == null) continue;
            if (vcerts == null) {
                vcerts = new Vector<Certificate>();
            }
            vcerts.addElement(cert);
        }
        if (vcerts != null && n == vcerts.size()) {
            Object[] certs = new Certificate[vcerts.size()];
            vcerts.copyInto(certs);
            return certs;
        }
        return null;
    }

    private final synchronized Enumeration<PolicyEntry> elements() {
        return this.policyEntries.elements();
    }

    @Override
    public PermissionCollection getPermissions(final Subject subject, final CodeSource codesource) {
        return AccessController.doPrivileged(new PrivilegedAction<PermissionCollection>(){

            @Override
            public PermissionCollection run() {
                SubjectCodeSource scs = new SubjectCodeSource(subject, null, codesource == null ? null : codesource.getLocation(), codesource == null ? null : codesource.getCertificates());
                if (AuthPolicyFile.this.initialized) {
                    return AuthPolicyFile.this.getPermissions(new Permissions(), (CodeSource)scs);
                }
                return new PolicyPermissions(AuthPolicyFile.this, scs);
            }
        });
    }

    PermissionCollection getPermissions(CodeSource codesource) {
        if (this.initialized) {
            return this.getPermissions(new Permissions(), codesource);
        }
        return new PolicyPermissions(this, codesource);
    }

    Permissions getPermissions(Permissions perms, CodeSource cs) {
        Certificate[] certs;
        if (!this.initialized) {
            this.init();
        }
        CodeSource[] codesource = new CodeSource[]{null};
        codesource[0] = this.canonicalizeCodebase(cs, true);
        if (debug != null) {
            debug.println("evaluate(" + codesource[0] + ")\n");
        }
        for (int i = 0; i < this.policyEntries.size(); ++i) {
            PolicyEntry entry = this.policyEntries.elementAt(i);
            if (debug != null) {
                debug.println("PolicyFile CodeSource implies: " + entry.codesource.toString() + "\n\n\t" + codesource[0].toString() + "\n\n");
            }
            if (!entry.codesource.implies(codesource[0])) continue;
            for (int j = 0; j < entry.permissions.size(); ++j) {
                Permission p = entry.permissions.elementAt(j);
                if (debug != null) {
                    debug.println("  granting " + p);
                }
                if (this.addSelfPermissions(p, entry.codesource, codesource[0], perms)) continue;
                perms.add(p);
            }
        }
        if (!this.ignoreIdentityScope && (certs = codesource[0].getCertificates()) != null) {
            for (int k = 0; k < certs.length; ++k) {
                if (this.aliasMapping.get(certs[k]) != null || !this.checkForTrustedIdentity(certs[k])) continue;
                perms.add(new AllPermission());
            }
        }
        return perms;
    }

    private boolean addSelfPermissions(Permission p, CodeSource entryCs, CodeSource accCs, Permissions perms) {
        if (!(p instanceof PrivateCredentialPermission)) {
            return false;
        }
        if (!(entryCs instanceof SubjectCodeSource)) {
            return false;
        }
        PrivateCredentialPermission pcp = (PrivateCredentialPermission)p;
        SubjectCodeSource scs = (SubjectCodeSource)entryCs;
        String[][] pPrincipals = pcp.getPrincipals();
        if (pPrincipals.length <= 0 || !pPrincipals[0][0].equalsIgnoreCase("self") || !pPrincipals[0][1].equalsIgnoreCase("self")) {
            return false;
        }
        if (scs.getPrincipals() == null) {
            return true;
        }
        for (PolicyParser.PrincipalEntry principal : scs.getPrincipals()) {
            String[][] principalInfo = this.getPrincipalInfo(principal, accCs);
            for (int i = 0; i < principalInfo.length; ++i) {
                PrivateCredentialPermission newPcp = new PrivateCredentialPermission(pcp.getCredentialClass() + " " + principalInfo[i][0] + " \"" + principalInfo[i][1] + "\"", "read");
                if (debug != null) {
                    debug.println("adding SELF permission: " + newPcp.toString());
                }
                perms.add(newPcp);
            }
        }
        return true;
    }

    private String[][] getPrincipalInfo(PolicyParser.PrincipalEntry principal, CodeSource accCs) {
        if (!principal.getPrincipalClass().equals("WILDCARD_PRINCIPAL_CLASS") && !principal.getPrincipalName().equals("WILDCARD_PRINCIPAL_NAME")) {
            String[][] info = new String[1][2];
            info[0][0] = principal.getPrincipalClass();
            info[0][1] = principal.getPrincipalName();
            return info;
        }
        if (!principal.getPrincipalClass().equals("WILDCARD_PRINCIPAL_CLASS") && principal.getPrincipalName().equals("WILDCARD_PRINCIPAL_NAME")) {
            Set<?> principalSet;
            block7: {
                SubjectCodeSource scs = (SubjectCodeSource)accCs;
                principalSet = null;
                try {
                    Class<?> pClass = Class.forName(principal.getPrincipalClass(), false, ClassLoader.getSystemClassLoader());
                    principalSet = scs.getSubject().getPrincipals(pClass);
                }
                catch (Exception e) {
                    if (debug == null) break block7;
                    debug.println("problem finding Principal Class when expanding SELF permission: " + e.toString());
                }
            }
            if (principalSet == null) {
                return new String[0][0];
            }
            String[][] info = new String[principalSet.size()][2];
            int i = 0;
            for (Principal p : principalSet) {
                info[i][0] = p.getClass().getName();
                info[i][1] = p.getName();
                ++i;
            }
            return info;
        }
        SubjectCodeSource scs = (SubjectCodeSource)accCs;
        Set<Principal> principalSet = scs.getSubject().getPrincipals();
        String[][] info = new String[principalSet.size()][2];
        int i = 0;
        for (Principal p : principalSet) {
            info[i][0] = p.getClass().getName();
            info[i][1] = p.getName();
            ++i;
        }
        return info;
    }

    Certificate[] getSignerCertificates(CodeSource cs) {
        int i;
        Certificate[] certs = null;
        certs = cs.getCertificates();
        if (certs == null) {
            return null;
        }
        for (i = 0; i < certs.length; ++i) {
            if (certs[i] instanceof X509Certificate) continue;
            return cs.getCertificates();
        }
        int count = 0;
        for (i = 0; i < certs.length; ++i) {
            ++count;
            while (i + 1 < certs.length && ((X509Certificate)certs[i]).getIssuerDN().equals(((X509Certificate)certs[i + 1]).getSubjectDN())) {
                ++i;
            }
        }
        if (count == certs.length) {
            return certs;
        }
        ArrayList<Certificate> userCertList = new ArrayList<Certificate>();
        for (i = 0; i < certs.length; ++i) {
            userCertList.add(certs[i]);
            while (i + 1 < certs.length && ((X509Certificate)certs[i]).getIssuerDN().equals(((X509Certificate)certs[i + 1]).getSubjectDN())) {
                ++i;
            }
        }
        Certificate[] userCerts = new Certificate[userCertList.size()];
        userCertList.toArray(userCerts);
        return userCerts;
    }

    private CodeSource canonicalizeCodebase(CodeSource cs, boolean extractSignerCerts) {
        CodeSource canonCs;
        block15: {
            canonCs = cs;
            if (cs.getLocation() != null && cs.getLocation().getProtocol().equalsIgnoreCase("file")) {
                try {
                    String path = cs.getLocation().getFile().replace('/', File.separatorChar);
                    URL csUrl = null;
                    if (path.endsWith("*")) {
                        path = path.substring(0, path.length() - 1);
                        boolean appendFileSep = false;
                        if (path.endsWith(File.separator)) {
                            appendFileSep = true;
                        }
                        if (path.equals("")) {
                            path = System.getProperty("user.dir");
                        }
                        File f = new File(path);
                        path = f.getCanonicalPath();
                        StringBuffer sb = new StringBuffer(path);
                        if (!path.endsWith(File.separator) && (appendFileSep || f.isDirectory())) {
                            sb.append(File.separatorChar);
                        }
                        sb.append('*');
                        path = sb.toString();
                    } else {
                        path = new File(path).getCanonicalPath();
                    }
                    csUrl = new File(path).toURL();
                    if (cs instanceof SubjectCodeSource) {
                        SubjectCodeSource scs = (SubjectCodeSource)cs;
                        canonCs = extractSignerCerts ? new SubjectCodeSource(scs.getSubject(), scs.getPrincipals(), csUrl, this.getSignerCertificates(scs)) : new SubjectCodeSource(scs.getSubject(), scs.getPrincipals(), csUrl, scs.getCertificates());
                        break block15;
                    }
                    if (extractSignerCerts) {
                        canonCs = new CodeSource(csUrl, this.getSignerCertificates(cs));
                        break block15;
                    }
                    canonCs = new CodeSource(csUrl, cs.getCertificates());
                }
                catch (IOException ioe) {
                    if (!extractSignerCerts) break block15;
                    if (!(cs instanceof SubjectCodeSource)) {
                        canonCs = new CodeSource(cs.getLocation(), this.getSignerCertificates(cs));
                        break block15;
                    }
                    SubjectCodeSource scs = (SubjectCodeSource)cs;
                    canonCs = new SubjectCodeSource(scs.getSubject(), scs.getPrincipals(), scs.getLocation(), this.getSignerCertificates(scs));
                }
            } else if (extractSignerCerts) {
                if (!(cs instanceof SubjectCodeSource)) {
                    canonCs = new CodeSource(cs.getLocation(), this.getSignerCertificates(cs));
                } else {
                    SubjectCodeSource scs = (SubjectCodeSource)cs;
                    canonCs = new SubjectCodeSource(scs.getSubject(), scs.getPrincipals(), scs.getLocation(), this.getSignerCertificates(scs));
                }
            }
        }
        return canonCs;
    }

    private static class PolicyEntry {
        CodeSource codesource;
        Vector<Permission> permissions;

        PolicyEntry(CodeSource cs) {
            this.codesource = cs;
            this.permissions = new Vector();
        }

        void add(Permission p) {
            this.permissions.addElement(p);
        }

        CodeSource getCodeSource() {
            return this.codesource;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(rb.getString("LPARAM"));
            sb.append(this.getCodeSource());
            sb.append("\n");
            for (int j = 0; j < this.permissions.size(); ++j) {
                Permission p = this.permissions.elementAt(j);
                sb.append(rb.getString("SPACE"));
                sb.append(rb.getString("SPACE"));
                sb.append(p);
                sb.append(rb.getString("NEWLINE"));
            }
            sb.append(rb.getString("RPARAM"));
            sb.append(rb.getString("NEWLINE"));
            return sb.toString();
        }
    }
}

