/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.kerberos.KeyTab;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.jgss.krb5.SubjectComber;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;

public final class ServiceCreds {
    private KerberosPrincipal kp;
    private Set<KerberosPrincipal> allPrincs;
    private List<KeyTab> ktabs;
    private List<KerberosKey> kk;
    private KerberosTicket tgt;
    private boolean destroyed;

    private ServiceCreds() {
    }

    public static ServiceCreds getInstance(Subject subj, String serverPrincipal) {
        ServiceCreds sc = new ServiceCreds();
        sc.allPrincs = subj.getPrincipals(KerberosPrincipal.class);
        for (KerberosKey key : SubjectComber.findMany(subj, serverPrincipal, null, KerberosKey.class)) {
            sc.allPrincs.add(key.getPrincipal());
        }
        if (serverPrincipal != null) {
            sc.kp = new KerberosPrincipal(serverPrincipal);
        } else if (sc.allPrincs.size() == 1) {
            boolean hasUnbound = false;
            for (KeyTab ktab : SubjectComber.findMany(subj, null, null, KeyTab.class)) {
                if (ktab.isBound()) continue;
                hasUnbound = true;
                break;
            }
            if (!hasUnbound) {
                sc.kp = sc.allPrincs.iterator().next();
                serverPrincipal = sc.kp.getName();
            }
        }
        sc.ktabs = SubjectComber.findMany(subj, serverPrincipal, null, KeyTab.class);
        sc.kk = SubjectComber.findMany(subj, serverPrincipal, null, KerberosKey.class);
        sc.tgt = SubjectComber.find(subj, null, serverPrincipal, KerberosTicket.class);
        if (sc.ktabs.isEmpty() && sc.kk.isEmpty() && sc.tgt == null) {
            return null;
        }
        sc.destroyed = false;
        return sc;
    }

    public String getName() {
        if (this.destroyed) {
            throw new IllegalStateException("This object is destroyed");
        }
        return this.kp == null ? null : this.kp.getName();
    }

    public KerberosKey[] getKKeys() {
        if (this.destroyed) {
            throw new IllegalStateException("This object is destroyed");
        }
        KerberosPrincipal one = this.kp;
        if (one == null && !this.allPrincs.isEmpty()) {
            one = this.allPrincs.iterator().next();
        }
        if (one == null) {
            for (KeyTab ktab : this.ktabs) {
                PrincipalName pn = Krb5Util.snapshotFromJavaxKeyTab(ktab).getOneName();
                if (pn == null) continue;
                one = new KerberosPrincipal(pn.getName());
                break;
            }
        }
        if (one != null) {
            return this.getKKeys(one);
        }
        return new KerberosKey[0];
    }

    public KerberosKey[] getKKeys(KerberosPrincipal princ) {
        if (this.destroyed) {
            throw new IllegalStateException("This object is destroyed");
        }
        ArrayList<KerberosKey> keys = new ArrayList<KerberosKey>();
        if (this.kp != null && !princ.equals(this.kp)) {
            return new KerberosKey[0];
        }
        for (KerberosKey k : this.kk) {
            if (!k.getPrincipal().equals(princ)) continue;
            keys.add(k);
        }
        for (KeyTab ktab : this.ktabs) {
            if (ktab.getPrincipal() == null && ktab.isBound() && !this.allPrincs.contains(princ)) continue;
            for (KerberosKey k : ktab.getKeys(princ)) {
                keys.add(k);
            }
        }
        return keys.toArray(new KerberosKey[keys.size()]);
    }

    public EncryptionKey[] getEKeys(PrincipalName princ) {
        if (this.destroyed) {
            throw new IllegalStateException("This object is destroyed");
        }
        KerberosKey[] kkeys = this.getKKeys(new KerberosPrincipal(princ.getName()));
        if (kkeys.length == 0) {
            kkeys = this.getKKeys();
        }
        EncryptionKey[] ekeys = new EncryptionKey[kkeys.length];
        for (int i = 0; i < ekeys.length; ++i) {
            ekeys[i] = new EncryptionKey(kkeys[i].getEncoded(), kkeys[i].getKeyType(), new Integer(kkeys[i].getVersionNumber()));
        }
        return ekeys;
    }

    public Credentials getInitCred() {
        if (this.destroyed) {
            throw new IllegalStateException("This object is destroyed");
        }
        if (this.tgt == null) {
            return null;
        }
        try {
            return Krb5Util.ticketToCreds(this.tgt);
        }
        catch (IOException | KrbException e) {
            return null;
        }
    }

    public void destroy() {
        this.destroyed = true;
        this.kp = null;
        this.ktabs.clear();
        this.kk.clear();
        this.tgt = null;
    }
}

