/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectStreamClass;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.AccessException;
import java.rmi.MarshalException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.rmi.UnmarshalException;
import java.rmi.server.ExportException;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteRef;
import java.rmi.server.RemoteStub;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.ServerRef;
import java.rmi.server.Skeleton;
import java.rmi.server.SkeletonNotFoundException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import sun.misc.ObjectInputFilter;
import sun.rmi.runtime.Log;
import sun.rmi.server.DeserializationChecker;
import sun.rmi.server.Dispatcher;
import sun.rmi.server.MarshalInputStream;
import sun.rmi.server.UnicastRef;
import sun.rmi.server.Util;
import sun.rmi.server.WeakClassHashMap;
import sun.rmi.transport.LiveRef;
import sun.rmi.transport.StreamRemoteCall;
import sun.rmi.transport.Target;
import sun.rmi.transport.tcp.TCPTransport;
import sun.security.action.GetBooleanAction;

public class UnicastServerRef
extends UnicastRef
implements ServerRef,
Dispatcher {
    public static final boolean logCalls = AccessController.doPrivileged(new GetBooleanAction("java.rmi.server.logCalls"));
    public static final Log callLog = Log.getLog("sun.rmi.server.call", "RMI", logCalls);
    private static final long serialVersionUID = -7384275867073752268L;
    private static final boolean wantExceptionLog = AccessController.doPrivileged(new GetBooleanAction("sun.rmi.server.exceptionTrace"));
    private boolean forceStubUse = false;
    private static final boolean suppressStackTraces = AccessController.doPrivileged(new GetBooleanAction("sun.rmi.server.suppressStackTraces"));
    private transient Skeleton skel;
    private final transient ObjectInputFilter filter;
    private transient Map<Long, Method> hashToMethod_Map = null;
    private static final WeakClassHashMap<Map<Long, Method>> hashToMethod_Maps = new HashToMethod_Maps();
    private static final Map<Class<?>, ?> withoutSkeletons = Collections.synchronizedMap(new WeakHashMap());
    private final AtomicInteger methodCallIDCount = new AtomicInteger(0);

    public UnicastServerRef() {
        this.filter = null;
    }

    public UnicastServerRef(LiveRef ref) {
        super(ref);
        this.filter = null;
    }

    public UnicastServerRef(LiveRef ref, ObjectInputFilter filter) {
        super(ref);
        this.filter = filter;
    }

    public UnicastServerRef(int port) {
        super(new LiveRef(port));
        this.filter = null;
    }

    public UnicastServerRef(boolean forceStubUse) {
        this(0);
        this.forceStubUse = forceStubUse;
    }

    @Override
    public RemoteStub exportObject(Remote impl, Object data) throws RemoteException {
        this.forceStubUse = true;
        return (RemoteStub)this.exportObject(impl, data, false);
    }

    public Remote exportObject(Remote impl, Object data, boolean permanent) throws RemoteException {
        Remote stub;
        Class<?> implClass = impl.getClass();
        try {
            stub = Util.createProxy(implClass, this.getClientRef(), this.forceStubUse);
        }
        catch (IllegalArgumentException e) {
            throw new ExportException("remote object implements illegal remote interface", e);
        }
        if (stub instanceof RemoteStub) {
            this.setSkeleton(impl);
        }
        Target target = new Target(impl, this, stub, this.ref.getObjID(), permanent);
        this.ref.exportObject(target);
        this.hashToMethod_Map = hashToMethod_Maps.get(implClass);
        return stub;
    }

    @Override
    public String getClientHost() throws ServerNotActiveException {
        return TCPTransport.getClientHost();
    }

    public void setSkeleton(Remote impl) throws RemoteException {
        if (!withoutSkeletons.containsKey(impl.getClass())) {
            try {
                this.skel = Util.createSkeleton(impl);
            }
            catch (SkeletonNotFoundException e) {
                withoutSkeletons.put(impl.getClass(), null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch(Remote obj, RemoteCall call) throws IOException {
        try {
            Object result;
            long op;
            int num;
            ObjectInput in;
            try {
                in = call.getInputStream();
                num = in.readInt();
            }
            catch (Exception readEx) {
                throw new UnmarshalException("error unmarshalling call header", readEx);
            }
            if (num >= 0) {
                if (this.skel != null) {
                    this.oldDispatch(obj, call, num);
                    return;
                }
                throw new UnmarshalException("skeleton class not found but required for client version");
            }
            try {
                op = in.readLong();
            }
            catch (Exception readEx) {
                throw new UnmarshalException("error unmarshalling call header", readEx);
            }
            MarshalInputStream marshalStream = (MarshalInputStream)in;
            marshalStream.skipDefaultResolveClass();
            Method method = this.hashToMethod_Map.get(op);
            if (method == null) {
                throw new UnmarshalException("unrecognized method hash: method not supported by remote object");
            }
            this.logCall(obj, method);
            Object[] params = null;
            try {
                this.unmarshalCustomCallData(in);
                params = this.unmarshalParameters(obj, method, marshalStream);
            }
            catch (AccessException aex) {
                ((StreamRemoteCall)call).discardPendingRefs();
                throw aex;
            }
            catch (IOException | ClassNotFoundException e) {
                ((StreamRemoteCall)call).discardPendingRefs();
                throw new UnmarshalException("error unmarshalling arguments", e);
            }
            finally {
                call.releaseInputStream();
            }
            try {
                result = method.invoke(obj, params);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
            try {
                ObjectOutput out = call.getResultStream(true);
                Class<?> rtype = method.getReturnType();
                if (rtype != Void.TYPE) {
                    UnicastServerRef.marshalValue(rtype, result, out);
                }
            }
            catch (IOException ex) {
                throw new MarshalException("error marshalling return", ex);
            }
        }
        catch (Throwable e2) {
            RemoteException e2;
            Throwable origEx = e2;
            this.logCallException(e2);
            ObjectOutput out = call.getResultStream(false);
            if (e2 instanceof Error) {
                e2 = new ServerError("Error occurred in server thread", (Error)e2);
            } else if (e2 instanceof RemoteException) {
                e2 = new ServerException("RemoteException occurred in server thread", (Exception)e2);
            }
            if (suppressStackTraces) {
                UnicastServerRef.clearStackTraces(e2);
            }
            out.writeObject(e2);
            if (origEx instanceof AccessException) {
                throw new IOException("Connection is not reusable", origEx);
            }
        }
        finally {
            call.releaseInputStream();
            call.releaseOutputStream();
        }
    }

    protected void unmarshalCustomCallData(ObjectInput in) throws IOException, ClassNotFoundException {
        if (this.filter != null && in instanceof ObjectInputStream) {
            final ObjectInputStream ois = (ObjectInputStream)in;
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    ObjectInputFilter.Config.setObjectInputFilter(ois, UnicastServerRef.this.filter);
                    return null;
                }
            });
        }
    }

    private void oldDispatch(Remote obj, RemoteCall call, int op) throws Exception {
        long hash;
        ObjectInput in = call.getInputStream();
        try {
            Class<?> clazz = Class.forName("sun.rmi.transport.DGCImpl_Skel");
            if (clazz.isAssignableFrom(this.skel.getClass())) {
                ((MarshalInputStream)in).useCodebaseOnly();
            }
        }
        catch (ClassNotFoundException clazz) {
            // empty catch block
        }
        try {
            hash = in.readLong();
        }
        catch (Exception ioe) {
            throw new UnmarshalException("error unmarshalling call header", ioe);
        }
        this.logCall(obj, this.skel.getOperations()[op]);
        this.unmarshalCustomCallData(in);
        this.skel.dispatch(obj, call, op, hash);
    }

    public static void clearStackTraces(Throwable t) {
        StackTraceElement[] empty = new StackTraceElement[]{};
        while (t != null) {
            t.setStackTrace(empty);
            t = t.getCause();
        }
    }

    private void logCall(Remote obj, Object method) {
        if (callLog.isLoggable(Log.VERBOSE)) {
            String clientHost;
            try {
                clientHost = this.getClientHost();
            }
            catch (ServerNotActiveException snae) {
                clientHost = "(local)";
            }
            callLog.log(Log.VERBOSE, "[" + clientHost + ": " + obj.getClass().getName() + this.ref.getObjID().toString() + ": " + method + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logCallException(Throwable e) {
        if (callLog.isLoggable(Log.BRIEF)) {
            String clientHost = "";
            try {
                clientHost = "[" + this.getClientHost() + "] ";
            }
            catch (ServerNotActiveException serverNotActiveException) {
                // empty catch block
            }
            callLog.log(Log.BRIEF, clientHost + "exception: ", e);
        }
        if (wantExceptionLog) {
            PrintStream log;
            PrintStream printStream = log = System.err;
            synchronized (printStream) {
                log.println();
                log.println("Exception dispatching call to " + this.ref.getObjID() + " in thread \"" + Thread.currentThread().getName() + "\" at " + new Date() + ":");
                e.printStackTrace(log);
            }
        }
    }

    @Override
    public String getRefClass(ObjectOutput out) {
        return "UnicastServerRef";
    }

    protected RemoteRef getClientRef() {
        return new UnicastRef(this.ref);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.ref = null;
        this.skel = null;
    }

    private Object[] unmarshalParameters(Object obj, Method method, MarshalInputStream in) throws IOException, ClassNotFoundException {
        return obj instanceof DeserializationChecker ? this.unmarshalParametersChecked((DeserializationChecker)obj, method, in) : this.unmarshalParametersUnchecked(method, in);
    }

    private Object[] unmarshalParametersUnchecked(Method method, ObjectInput in) throws IOException, ClassNotFoundException {
        Class<?>[] types = method.getParameterTypes();
        Object[] params = new Object[types.length];
        for (int i = 0; i < types.length; ++i) {
            params[i] = UnicastServerRef.unmarshalValue(types[i], in);
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] unmarshalParametersChecked(DeserializationChecker checker, Method method, MarshalInputStream in) throws IOException, ClassNotFoundException {
        int callID = this.methodCallIDCount.getAndIncrement();
        MyChecker myChecker = new MyChecker(checker, method, callID);
        in.setStreamChecker(myChecker);
        try {
            Class<?>[] types = method.getParameterTypes();
            Object[] values = new Object[types.length];
            for (int i = 0; i < types.length; ++i) {
                myChecker.setIndex(i);
                values[i] = UnicastServerRef.unmarshalValue(types[i], in);
            }
            myChecker.end(callID);
            Object[] objectArray = values;
            return objectArray;
        }
        finally {
            in.setStreamChecker(null);
        }
    }

    private static class MyChecker
    implements MarshalInputStream.StreamChecker {
        private final DeserializationChecker descriptorCheck;
        private final Method method;
        private final int callID;
        private int parameterIndex;

        MyChecker(DeserializationChecker descriptorCheck, Method method, int callID) {
            this.descriptorCheck = descriptorCheck;
            this.method = method;
            this.callID = callID;
        }

        @Override
        public void validateDescriptor(ObjectStreamClass descriptor) {
            this.descriptorCheck.check(this.method, descriptor, this.parameterIndex, this.callID);
        }

        @Override
        public void checkProxyInterfaceNames(String[] ifaces) {
            this.descriptorCheck.checkProxyClass(this.method, ifaces, this.parameterIndex, this.callID);
        }

        void setIndex(int parameterIndex) {
            this.parameterIndex = parameterIndex;
        }

        void end(int callId) {
            this.descriptorCheck.end(callId);
        }
    }

    private static class HashToMethod_Maps
    extends WeakClassHashMap<Map<Long, Method>> {
        HashToMethod_Maps() {
        }

        @Override
        protected Map<Long, Method> computeValue(Class<?> remoteClass) {
            HashMap<Long, Method> map = new HashMap<Long, Method>();
            for (Class<?> cl = remoteClass; cl != null; cl = cl.getSuperclass()) {
                for (Class<?> intf : cl.getInterfaces()) {
                    if (!Remote.class.isAssignableFrom(intf)) continue;
                    Method[] methodArray = intf.getMethods();
                    int n = methodArray.length;
                    for (int i = 0; i < n; ++i) {
                        Method method;
                        final Method m = method = methodArray[i];
                        AccessController.doPrivileged(new PrivilegedAction<Void>(){

                            @Override
                            public Void run() {
                                m.setAccessible(true);
                                return null;
                            }
                        });
                        map.put(Util.computeMethodHash(m), m);
                    }
                }
            }
            return map;
        }
    }
}

