/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.rmi.server.RMIClassLoader;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.util.HashMap;
import java.util.Map;
import sun.misc.ObjectStreamClassValidator;
import sun.misc.SharedSecrets;
import sun.misc.VM;
import sun.security.action.GetPropertyAction;

public class MarshalInputStream
extends ObjectInputStream {
    private volatile StreamChecker streamChecker = null;
    private static final boolean useCodebaseOnlyProperty = !AccessController.doPrivileged(new GetPropertyAction("java.rmi.server.useCodebaseOnly", "true")).equalsIgnoreCase("false");
    protected static Map<String, Class<?>> permittedSunClasses = new HashMap(3);
    private boolean skipDefaultResolveClass = false;
    private final Map<Object, Runnable> doneCallbacks = new HashMap<Object, Runnable>(3);
    private boolean useCodebaseOnly = useCodebaseOnlyProperty;

    public MarshalInputStream(InputStream in) throws IOException, StreamCorruptedException {
        super(in);
    }

    public Runnable getDoneCallback(Object key) {
        return this.doneCallbacks.get(key);
    }

    public void setDoneCallback(Object key, Runnable callback) {
        this.doneCallbacks.put(key, callback);
    }

    public void done() {
        for (Runnable callback : this.doneCallbacks.values()) {
            callback.run();
        }
        this.doneCallbacks.clear();
    }

    @Override
    public void close() throws IOException {
        this.done();
        super.close();
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
        Object annotation = this.readLocation();
        String className = classDesc.getName();
        ClassLoader defaultLoader = this.skipDefaultResolveClass ? null : MarshalInputStream.latestUserDefinedLoader();
        String codebase = null;
        if (!this.useCodebaseOnly && annotation instanceof String) {
            codebase = (String)annotation;
        }
        try {
            return RMIClassLoader.loadClass(codebase, className, defaultLoader);
        }
        catch (AccessControlException e) {
            return this.checkSunClass(className, e);
        }
        catch (ClassNotFoundException e) {
            try {
                if (Character.isLowerCase(className.charAt(0)) && className.indexOf(46) == -1) {
                    return super.resolveClass(classDesc);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        StreamChecker checker = this.streamChecker;
        if (checker != null) {
            checker.checkProxyInterfaceNames(interfaces);
        }
        Object annotation = this.readLocation();
        ClassLoader defaultLoader = this.skipDefaultResolveClass ? null : MarshalInputStream.latestUserDefinedLoader();
        String codebase = null;
        if (!this.useCodebaseOnly && annotation instanceof String) {
            codebase = (String)annotation;
        }
        return RMIClassLoader.loadProxyClass(codebase, interfaces, defaultLoader);
    }

    private static ClassLoader latestUserDefinedLoader() {
        return VM.latestUserDefinedLoader();
    }

    private Class<?> checkSunClass(String className, AccessControlException e) throws AccessControlException {
        Permission perm = e.getPermission();
        String name = null;
        if (perm != null) {
            name = perm.getName();
        }
        Class<?> resolvedClass = permittedSunClasses.get(className);
        if (name == null || resolvedClass == null || !name.equals("accessClassInPackage.sun.rmi.server") && !name.equals("accessClassInPackage.sun.rmi.registry")) {
            throw e;
        }
        return resolvedClass;
    }

    protected Object readLocation() throws IOException, ClassNotFoundException {
        return this.readObject();
    }

    void skipDefaultResolveClass() {
        this.skipDefaultResolveClass = true;
    }

    void useCodebaseOnly() {
        this.useCodebaseOnly = true;
    }

    synchronized void setStreamChecker(StreamChecker checker) {
        this.streamChecker = checker;
        SharedSecrets.getJavaOISAccess().setValidator(this, checker);
    }

    @Override
    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        ObjectStreamClass descriptor = super.readClassDescriptor();
        this.validateDesc(descriptor);
        return descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateDesc(ObjectStreamClass descriptor) {
        StreamChecker checker;
        MarshalInputStream marshalInputStream = this;
        synchronized (marshalInputStream) {
            checker = this.streamChecker;
        }
        if (checker != null) {
            checker.validateDescriptor(descriptor);
        }
    }

    static {
        try {
            String system = "sun.rmi.server.Activation$ActivationSystemImpl_Stub";
            String registry = "sun.rmi.registry.RegistryImpl_Stub";
            permittedSunClasses.put(system, Class.forName(system));
            permittedSunClasses.put(registry, Class.forName(registry));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError("Missing system class: " + e.getMessage());
        }
    }

    static interface StreamChecker
    extends ObjectStreamClassValidator {
        public void checkProxyInterfaceNames(String[] var1);
    }
}

