/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.AWTEvent;
import java.awt.Font;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.peer.MenuItemPeer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import sun.awt.windows.WMenuBarPeer;
import sun.awt.windows.WMenuPeer;
import sun.awt.windows.WObjectPeer;
import sun.awt.windows.WToolkit;
import sun.util.logging.PlatformLogger;

class WMenuItemPeer
extends WObjectPeer
implements MenuItemPeer {
    private static final PlatformLogger log = PlatformLogger.getLogger("sun.awt.WMenuItemPeer");
    String shortcutLabel;
    protected WMenuPeer parent;
    private final boolean isCheckbox;
    private static Font defaultMenuFont;

    private synchronized native void _dispose();

    @Override
    protected void disposeImpl() {
        WToolkit.targetDisposedPeer(this.target, this);
        this._dispose();
    }

    @Override
    public void setEnabled(boolean b) {
        this.enable(b);
    }

    public void enable() {
        this.enable(true);
    }

    public void disable() {
        this.enable(false);
    }

    private void readShortcutLabel() {
        MenuShortcut sc;
        WMenuPeer ancestor = this.parent;
        while (ancestor != null && !(ancestor instanceof WMenuBarPeer)) {
            ancestor = ancestor.parent;
        }
        this.shortcutLabel = ancestor instanceof WMenuBarPeer ? ((sc = ((MenuItem)this.target).getShortcut()) != null ? sc.toString() : null) : null;
    }

    @Override
    public void setLabel(String label) {
        this.readShortcutLabel();
        this._setLabel(label);
    }

    public native void _setLabel(String var1);

    protected WMenuItemPeer() {
        this.isCheckbox = false;
    }

    WMenuItemPeer(MenuItem target) {
        this(target, false);
    }

    WMenuItemPeer(MenuItem target, boolean isCheckbox) {
        this.target = target;
        this.parent = (WMenuPeer)WToolkit.targetToPeer(target.getParent());
        this.isCheckbox = isCheckbox;
        this.parent.addChildPeer(this);
        this.create(this.parent);
        this.checkMenuCreation();
        this.readShortcutLabel();
    }

    void checkMenuCreation() {
        if (this.pData == 0L) {
            if (this.createError != null) {
                throw this.createError;
            }
            throw new InternalError("couldn't create menu peer");
        }
    }

    void postEvent(AWTEvent event) {
        WToolkit.postEvent(WToolkit.targetToAppContext(this.target), event);
    }

    native void create(WMenuPeer var1);

    native void enable(boolean var1);

    void handleAction(final long when, final int modifiers) {
        WToolkit.executeOnEventHandlerThread(this.target, new Runnable(){

            @Override
            public void run() {
                WMenuItemPeer.this.postEvent(new ActionEvent(WMenuItemPeer.this.target, 1001, ((MenuItem)WMenuItemPeer.this.target).getActionCommand(), when, modifiers));
            }
        });
    }

    static Font getDefaultFont() {
        return defaultMenuFont;
    }

    private static native void initIDs();

    private native void _setFont(Font var1);

    @Override
    public void setFont(Font f) {
        this._setFont(f);
    }

    static {
        WMenuItemPeer.initIDs();
        defaultMenuFont = AccessController.doPrivileged(new PrivilegedAction<Font>(){

            @Override
            public Font run() {
                try {
                    ResourceBundle rb = ResourceBundle.getBundle("sun.awt.windows.awtLocalization");
                    return Font.decode(rb.getString("menuFont"));
                }
                catch (MissingResourceException e) {
                    if (log.isLoggable(PlatformLogger.Level.FINE)) {
                        log.fine("WMenuItemPeer: " + e.getMessage() + ". Using default MenuItem font.", e);
                    }
                    return new Font("SanSerif", 0, 11);
                }
            }
        });
    }
}

