/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.util.xml.impl;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import jdk.internal.util.xml.XMLStreamException;

public class XMLWriter {
    private Writer _writer;
    private CharsetEncoder _encoder = null;

    public XMLWriter(OutputStream os, String encoding, Charset cs) throws XMLStreamException {
        this._encoder = cs.newEncoder();
        try {
            this._writer = this.getWriter(os, encoding, cs);
        }
        catch (UnsupportedEncodingException ex) {
            throw new XMLStreamException(ex);
        }
    }

    public boolean canEncode(char ch) {
        if (this._encoder == null) {
            return false;
        }
        return this._encoder.canEncode(ch);
    }

    public void write(String s) throws XMLStreamException {
        try {
            this._writer.write(s.toCharArray());
        }
        catch (IOException e) {
            throw new XMLStreamException("I/O error", e);
        }
    }

    public void write(String str, int off, int len) throws XMLStreamException {
        try {
            this._writer.write(str, off, len);
        }
        catch (IOException e) {
            throw new XMLStreamException("I/O error", e);
        }
    }

    public void write(char[] cbuf, int off, int len) throws XMLStreamException {
        try {
            this._writer.write(cbuf, off, len);
        }
        catch (IOException e) {
            throw new XMLStreamException("I/O error", e);
        }
    }

    void write(int b) throws XMLStreamException {
        try {
            this._writer.write(b);
        }
        catch (IOException e) {
            throw new XMLStreamException("I/O error", e);
        }
    }

    void flush() throws XMLStreamException {
        try {
            this._writer.flush();
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    void close() throws XMLStreamException {
        try {
            this._writer.close();
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    private void nl() throws XMLStreamException {
        String lineEnd = System.getProperty("line.separator");
        try {
            this._writer.write(lineEnd);
        }
        catch (IOException e) {
            throw new XMLStreamException("I/O error", e);
        }
    }

    private Writer getWriter(OutputStream output, String encoding, Charset cs) throws XMLStreamException, UnsupportedEncodingException {
        if (cs != null) {
            return new OutputStreamWriter((OutputStream)new BufferedOutputStream(output), cs);
        }
        return new OutputStreamWriter((OutputStream)new BufferedOutputStream(output), encoding);
    }
}

