/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.UnresolvedPermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

final class UnresolvedPermissionCollection
extends PermissionCollection
implements Serializable {
    private transient Map<String, List<UnresolvedPermission>> perms = new HashMap<String, List<UnresolvedPermission>>(11);
    private static final long serialVersionUID = -7176153071733132400L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("permissions", Hashtable.class)};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Permission permission) {
        List<UnresolvedPermission> v;
        if (!(permission instanceof UnresolvedPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        UnresolvedPermission up = (UnresolvedPermission)permission;
        Object object = this;
        synchronized (object) {
            v = this.perms.get(up.getName());
            if (v == null) {
                v = new ArrayList<UnresolvedPermission>();
                this.perms.put(up.getName(), v);
            }
        }
        object = v;
        synchronized (object) {
            v.add(up);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<UnresolvedPermission> getUnresolvedPermissions(Permission p) {
        UnresolvedPermissionCollection unresolvedPermissionCollection = this;
        synchronized (unresolvedPermissionCollection) {
            return this.perms.get(p.getClass().getName());
        }
    }

    @Override
    public boolean implies(Permission permission) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<Permission> elements() {
        ArrayList<UnresolvedPermission> results = new ArrayList<UnresolvedPermission>();
        UnresolvedPermissionCollection unresolvedPermissionCollection = this;
        synchronized (unresolvedPermissionCollection) {
            Iterator<List<UnresolvedPermission>> iterator = this.perms.values().iterator();
            while (iterator.hasNext()) {
                List<UnresolvedPermission> l;
                List<UnresolvedPermission> list = l = iterator.next();
                synchronized (list) {
                    results.addAll(l);
                }
            }
        }
        return Collections.enumeration(results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        Hashtable permissions = new Hashtable(this.perms.size() * 2);
        UnresolvedPermissionCollection unresolvedPermissionCollection = this;
        synchronized (unresolvedPermissionCollection) {
            Set<Map.Entry<String, List<UnresolvedPermission>>> set = this.perms.entrySet();
            for (Map.Entry<String, List<UnresolvedPermission>> e : set) {
                List<UnresolvedPermission> list = e.getValue();
                Vector<UnresolvedPermission> vec = new Vector<UnresolvedPermission>(list.size());
                List<UnresolvedPermission> list2 = list;
                synchronized (list2) {
                    vec.addAll(list);
                }
                permissions.put(e.getKey(), vec);
            }
        }
        ObjectOutputStream.PutField pfields = out.putFields();
        pfields.put("permissions", permissions);
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField gfields = in.readFields();
        Hashtable permissions = (Hashtable)gfields.get("permissions", null);
        this.perms = new HashMap<String, List<UnresolvedPermission>>(permissions.size() * 2);
        Set set = permissions.entrySet();
        for (Map.Entry e : set) {
            Vector vec = (Vector)e.getValue();
            ArrayList list = new ArrayList(vec.size());
            list.addAll(vec);
            this.perms.put((String)e.getKey(), list);
        }
    }
}

