/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.BasicPermissionCollection;
import java.security.Permission;
import java.security.PermissionCollection;

public abstract class BasicPermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = 6279438298436773498L;
    private transient boolean wildcard;
    private transient String path;
    private transient boolean exitVM;

    private void init(String name) {
        if (name == null) {
            throw new NullPointerException("name can't be null");
        }
        int len = name.length();
        if (len == 0) {
            throw new IllegalArgumentException("name can't be empty");
        }
        char last = name.charAt(len - 1);
        if (last == '*' && (len == 1 || name.charAt(len - 2) == '.')) {
            this.wildcard = true;
            this.path = len == 1 ? "" : name.substring(0, len - 1);
        } else if (name.equals("exitVM")) {
            this.wildcard = true;
            this.path = "exitVM.";
            this.exitVM = true;
        } else {
            this.path = name;
        }
    }

    public BasicPermission(String name) {
        super(name);
        this.init(name);
    }

    public BasicPermission(String name, String actions) {
        super(name);
        this.init(name);
    }

    @Override
    public boolean implies(Permission p) {
        if (p == null || p.getClass() != this.getClass()) {
            return false;
        }
        BasicPermission that = (BasicPermission)p;
        if (this.wildcard) {
            if (that.wildcard) {
                return that.path.startsWith(this.path);
            }
            return that.path.length() > this.path.length() && that.path.startsWith(this.path);
        }
        if (that.wildcard) {
            return false;
        }
        return this.path.equals(that.path);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BasicPermission bp = (BasicPermission)obj;
        return this.getName().equals(bp.getName());
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public String getActions() {
        return "";
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new BasicPermissionCollection(this.getClass());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init(this.getName());
    }

    final String getCanonicalName() {
        return this.exitVM ? "exitVM.*" : this.getName();
    }
}

