/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl.digest;

import com.sun.security.sasl.digest.DigestMD5Base;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

final class DigestMD5Client
extends DigestMD5Base
implements SaslClient {
    private static final String MY_CLASS_NAME = DigestMD5Client.class.getName();
    private static final String CIPHER_PROPERTY = "com.sun.security.sasl.digest.cipher";
    private static final String[] DIRECTIVE_KEY = new String[]{"realm", "qop", "algorithm", "nonce", "maxbuf", "charset", "cipher", "rspauth", "stale"};
    private static final int REALM = 0;
    private static final int QOP = 1;
    private static final int ALGORITHM = 2;
    private static final int NONCE = 3;
    private static final int MAXBUF = 4;
    private static final int CHARSET = 5;
    private static final int CIPHER = 6;
    private static final int RESPONSE_AUTH = 7;
    private static final int STALE = 8;
    private int nonceCount;
    private String specifiedCipher;
    private byte[] cnonce;
    private String username;
    private char[] passwd;
    private byte[] authzidBytes;

    DigestMD5Client(String authzid, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        super(props, MY_CLASS_NAME, 2, protocol + "/" + serverName, cbh);
        if (authzid != null) {
            this.authzid = authzid;
            try {
                this.authzidBytes = authzid.getBytes("UTF8");
            }
            catch (UnsupportedEncodingException e) {
                throw new SaslException("DIGEST-MD5: Error encoding authzid value into UTF-8", e);
            }
        }
        if (props != null) {
            this.specifiedCipher = (String)props.get(CIPHER_PROPERTY);
            logger.log(Level.FINE, "DIGEST60:Explicitly specified cipher: {0}", this.specifiedCipher);
        }
    }

    @Override
    public boolean hasInitialResponse() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] evaluateChallenge(byte[] challengeData) throws SaslException {
        if (challengeData.length > 2048) {
            throw new SaslException("DIGEST-MD5: Invalid digest-challenge length. Got:  " + challengeData.length + " Expected < " + 2048);
        }
        switch (this.step) {
            case 2: {
                ArrayList<byte[]> realmChoices = new ArrayList<byte[]>(3);
                byte[][] challengeVal = DigestMD5Client.parseDirectives(challengeData, DIRECTIVE_KEY, realmChoices, 0);
                try {
                    this.processChallenge(challengeVal, realmChoices);
                    this.checkQopSupport(challengeVal[1], challengeVal[6]);
                    ++this.step;
                    return this.generateClientResponse(challengeVal[5]);
                }
                catch (SaslException e) {
                    this.step = 0;
                    this.clearPassword();
                    throw e;
                }
                catch (IOException e) {
                    this.step = 0;
                    this.clearPassword();
                    throw new SaslException("DIGEST-MD5: Error generating digest response-value", e);
                }
            }
            case 3: {
                try {
                    byte[][] challengeVal = DigestMD5Client.parseDirectives(challengeData, DIRECTIVE_KEY, null, 0);
                    this.validateResponseValue(challengeVal[7]);
                    if (this.integrity && this.privacy) {
                        this.secCtx = new DigestMD5Base.DigestPrivacy(this, true);
                    } else if (this.integrity) {
                        this.secCtx = new DigestMD5Base.DigestIntegrity(this, true);
                    }
                    byte[] byArray = null;
                    return byArray;
                }
                finally {
                    this.clearPassword();
                    this.step = 0;
                    this.completed = true;
                }
            }
        }
        throw new SaslException("DIGEST-MD5: Client at illegal state");
    }

    private void processChallenge(byte[][] challengeVal, List<byte[]> realmChoices) throws SaslException, UnsupportedEncodingException {
        if (challengeVal[5] != null) {
            if (!"utf-8".equals(new String(challengeVal[5], this.encoding))) {
                throw new SaslException("DIGEST-MD5: digest-challenge format violation. Unrecognised charset value: " + new String(challengeVal[5]));
            }
            this.encoding = "UTF8";
            this.useUTF8 = true;
        }
        if (challengeVal[2] == null) {
            throw new SaslException("DIGEST-MD5: Digest-challenge format violation: algorithm directive missing");
        }
        if (!"md5-sess".equals(new String(challengeVal[2], this.encoding))) {
            throw new SaslException("DIGEST-MD5: Digest-challenge format violation. Invalid value for 'algorithm' directive: " + challengeVal[2]);
        }
        if (challengeVal[3] == null) {
            throw new SaslException("DIGEST-MD5: Digest-challenge format violation: nonce directive missing");
        }
        this.nonce = challengeVal[3];
        try {
            String[] realmTokens = null;
            if (challengeVal[0] != null) {
                if (realmChoices == null || realmChoices.size() <= 1) {
                    this.negotiatedRealm = new String(challengeVal[0], this.encoding);
                } else {
                    realmTokens = new String[realmChoices.size()];
                    for (int i = 0; i < realmTokens.length; ++i) {
                        realmTokens[i] = new String(realmChoices.get(i), this.encoding);
                    }
                }
            }
            NameCallback ncb = this.authzid == null ? new NameCallback("DIGEST-MD5 authentication ID: ") : new NameCallback("DIGEST-MD5 authentication ID: ", this.authzid);
            PasswordCallback pcb = new PasswordCallback("DIGEST-MD5 password: ", false);
            if (realmTokens == null) {
                RealmCallback tcb = this.negotiatedRealm == null ? new RealmCallback("DIGEST-MD5 realm: ") : new RealmCallback("DIGEST-MD5 realm: ", this.negotiatedRealm);
                this.cbh.handle(new Callback[]{tcb, ncb, pcb});
                this.negotiatedRealm = tcb.getText();
                if (this.negotiatedRealm == null) {
                    this.negotiatedRealm = "";
                }
            } else {
                RealmChoiceCallback ccb = new RealmChoiceCallback("DIGEST-MD5 realm: ", realmTokens, 0, false);
                this.cbh.handle(new Callback[]{ccb, ncb, pcb});
                int[] selected = ccb.getSelectedIndexes();
                if (selected == null || selected[0] < 0 || selected[0] >= realmTokens.length) {
                    throw new SaslException("DIGEST-MD5: Invalid realm chosen");
                }
                this.negotiatedRealm = realmTokens[selected[0]];
            }
            this.passwd = pcb.getPassword();
            pcb.clearPassword();
            this.username = ncb.getName();
        }
        catch (SaslException se) {
            throw se;
        }
        catch (UnsupportedCallbackException e) {
            throw new SaslException("DIGEST-MD5: Cannot perform callback to acquire realm, authentication ID or password", e);
        }
        catch (IOException e) {
            throw new SaslException("DIGEST-MD5: Error acquiring realm, authentication ID or password", e);
        }
        if (this.username == null || this.passwd == null) {
            throw new SaslException("DIGEST-MD5: authentication ID and password must be specified");
        }
        int srvMaxBufSize = challengeVal[4] == null ? 65536 : Integer.parseInt(new String(challengeVal[4], this.encoding));
        this.sendMaxBufSize = this.sendMaxBufSize == 0 ? srvMaxBufSize : Math.min(this.sendMaxBufSize, srvMaxBufSize);
    }

    private void checkQopSupport(byte[] qopInChallenge, byte[] ciphersInChallenge) throws IOException {
        String qopOptions = qopInChallenge == null ? "auth" : new String(qopInChallenge, this.encoding);
        String[] serverQopTokens = new String[3];
        byte[] serverQop = DigestMD5Client.parseQop(qopOptions, serverQopTokens, true);
        byte serverAllQop = DigestMD5Client.combineMasks(serverQop);
        switch (DigestMD5Client.findPreferredMask(serverAllQop, this.qop)) {
            case 0: {
                throw new SaslException("DIGEST-MD5: No common protection layer between client and server");
            }
            case 1: {
                this.negotiatedQop = "auth";
                break;
            }
            case 2: {
                this.negotiatedQop = "auth-int";
                this.integrity = true;
                this.rawSendSize = this.sendMaxBufSize - 16;
                break;
            }
            case 4: {
                this.negotiatedQop = "auth-conf";
                this.integrity = true;
                this.privacy = true;
                this.rawSendSize = this.sendMaxBufSize - 26;
                this.checkStrengthSupport(ciphersInChallenge);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "DIGEST61:Raw send size: {0}", new Integer(this.rawSendSize));
        }
    }

    private void checkStrengthSupport(byte[] ciphersInChallenge) throws IOException {
        if (ciphersInChallenge == null) {
            throw new SaslException("DIGEST-MD5: server did not specify cipher to use for 'auth-conf'");
        }
        String cipherOptions = new String(ciphersInChallenge, this.encoding);
        StringTokenizer parser = new StringTokenizer(cipherOptions, ", \t\n");
        int tokenCount = parser.countTokens();
        String token = null;
        byte[] serverCiphers = new byte[]{0, 0, 0, 0, 0};
        String[] serverCipherStrs = new String[serverCiphers.length];
        for (int i = 0; i < tokenCount; ++i) {
            token = parser.nextToken();
            for (int j = 0; j < CIPHER_TOKENS.length; ++j) {
                if (!token.equals(CIPHER_TOKENS[j])) continue;
                int n = j;
                serverCiphers[n] = (byte)(serverCiphers[n] | CIPHER_MASKS[j]);
                serverCipherStrs[j] = token;
                logger.log(Level.FINE, "DIGEST62:Server supports {0}", token);
            }
        }
        byte[] clntCiphers = DigestMD5Client.getPlatformCiphers();
        byte inter = 0;
        for (int i = 0; i < serverCiphers.length; ++i) {
            int n = i;
            serverCiphers[n] = (byte)(serverCiphers[n] & clntCiphers[i]);
            inter = (byte)(inter | serverCiphers[i]);
        }
        if (inter == 0) {
            throw new SaslException("DIGEST-MD5: Client supports none of these cipher suites: " + cipherOptions);
        }
        this.negotiatedCipher = this.findCipherAndStrength(serverCiphers, serverCipherStrs);
        if (this.negotiatedCipher == null) {
            throw new SaslException("DIGEST-MD5: Unable to negotiate a strength level for 'auth-conf'");
        }
        logger.log(Level.FINE, "DIGEST63:Cipher suite: {0}", this.negotiatedCipher);
    }

    private String findCipherAndStrength(byte[] supportedCiphers, String[] tokens) {
        for (int i = 0; i < this.strength.length; ++i) {
            byte s = this.strength[i];
            if (s == 0) continue;
            for (int j = 0; j < supportedCiphers.length; ++j) {
                if (s != supportedCiphers[j] || this.specifiedCipher != null && !this.specifiedCipher.equals(tokens[j])) continue;
                switch (s) {
                    case 4: {
                        this.negotiatedStrength = "high";
                        break;
                    }
                    case 2: {
                        this.negotiatedStrength = "medium";
                        break;
                    }
                    case 1: {
                        this.negotiatedStrength = "low";
                    }
                }
                return tokens[j];
            }
        }
        return null;
    }

    private byte[] generateClientResponse(byte[] charset) throws IOException {
        ByteArrayOutputStream digestResp = new ByteArrayOutputStream();
        if (this.useUTF8) {
            digestResp.write("charset=".getBytes(this.encoding));
            digestResp.write(charset);
            digestResp.write(44);
        }
        digestResp.write(("username=\"" + DigestMD5Client.quotedStringValue(this.username) + "\",").getBytes(this.encoding));
        if (this.negotiatedRealm.length() > 0) {
            digestResp.write(("realm=\"" + DigestMD5Client.quotedStringValue(this.negotiatedRealm) + "\",").getBytes(this.encoding));
        }
        digestResp.write("nonce=\"".getBytes(this.encoding));
        DigestMD5Client.writeQuotedStringValue(digestResp, this.nonce);
        digestResp.write(34);
        digestResp.write(44);
        this.nonceCount = DigestMD5Client.getNonceCount(this.nonce);
        digestResp.write(("nc=" + DigestMD5Client.nonceCountToHex(this.nonceCount) + ",").getBytes(this.encoding));
        this.cnonce = DigestMD5Client.generateNonce();
        digestResp.write("cnonce=\"".getBytes(this.encoding));
        DigestMD5Client.writeQuotedStringValue(digestResp, this.cnonce);
        digestResp.write("\",".getBytes(this.encoding));
        digestResp.write(("digest-uri=\"" + this.digestUri + "\",").getBytes(this.encoding));
        digestResp.write("maxbuf=".getBytes(this.encoding));
        digestResp.write(String.valueOf(this.recvMaxBufSize).getBytes(this.encoding));
        digestResp.write(44);
        try {
            digestResp.write("response=".getBytes(this.encoding));
            digestResp.write(this.generateResponseValue("AUTHENTICATE", this.digestUri, this.negotiatedQop, this.username, this.negotiatedRealm, this.passwd, this.nonce, this.cnonce, this.nonceCount, this.authzidBytes));
            digestResp.write(44);
        }
        catch (Exception e) {
            throw new SaslException("DIGEST-MD5: Error generating response value", e);
        }
        digestResp.write(("qop=" + this.negotiatedQop).getBytes(this.encoding));
        if (this.negotiatedCipher != null) {
            digestResp.write((",cipher=\"" + this.negotiatedCipher + "\"").getBytes(this.encoding));
        }
        if (this.authzidBytes != null) {
            digestResp.write(",authzid=\"".getBytes(this.encoding));
            DigestMD5Client.writeQuotedStringValue(digestResp, this.authzidBytes);
            digestResp.write("\"".getBytes(this.encoding));
        }
        if (digestResp.size() > 4096) {
            throw new SaslException("DIGEST-MD5: digest-response size too large. Length: " + digestResp.size());
        }
        return digestResp.toByteArray();
    }

    private void validateResponseValue(byte[] fromServer) throws SaslException {
        if (fromServer == null) {
            throw new SaslException("DIGEST-MD5: Authenication failed. Expecting 'rspauth' authentication success message");
        }
        try {
            byte[] expected = this.generateResponseValue("", this.digestUri, this.negotiatedQop, this.username, this.negotiatedRealm, this.passwd, this.nonce, this.cnonce, this.nonceCount, this.authzidBytes);
            if (!Arrays.equals(expected, fromServer)) {
                throw new SaslException("Server's rspauth value does not match what client expects");
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new SaslException("Problem generating response value for verification", e);
        }
        catch (IOException e) {
            throw new SaslException("Problem generating response value for verification", e);
        }
    }

    private static int getNonceCount(byte[] nonceValue) {
        return 1;
    }

    private void clearPassword() {
        if (this.passwd != null) {
            for (int i = 0; i < this.passwd.length; ++i) {
                this.passwd[i] = '\u0000';
            }
            this.passwd = null;
        }
    }
}

