/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management;

import javax.management.openmbean.CompositeData;
import jdk.Exported;
import sun.management.VMOptionCompositeData;

@Exported
public class VMOption {
    private String name;
    private String value;
    private boolean writeable;
    private Origin origin;

    public VMOption(String name, String value, boolean writeable, Origin origin) {
        this.name = name;
        this.value = value;
        this.writeable = writeable;
        this.origin = origin;
    }

    private VMOption(CompositeData cd) {
        VMOptionCompositeData.validateCompositeData((CompositeData)cd);
        this.name = VMOptionCompositeData.getName((CompositeData)cd);
        this.value = VMOptionCompositeData.getValue((CompositeData)cd);
        this.writeable = VMOptionCompositeData.isWriteable((CompositeData)cd);
        this.origin = VMOptionCompositeData.getOrigin((CompositeData)cd);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public boolean isWriteable() {
        return this.writeable;
    }

    public String toString() {
        return "VM option: " + this.getName() + " value: " + this.value + "  origin: " + (Object)((Object)this.origin) + " " + (this.writeable ? "(read-write)" : "(read-only)");
    }

    public static VMOption from(CompositeData cd) {
        if (cd == null) {
            return null;
        }
        if (cd instanceof VMOptionCompositeData) {
            return ((VMOptionCompositeData)cd).getVMOption();
        }
        return new VMOption(cd);
    }

    @Exported
    public static enum Origin {
        DEFAULT,
        VM_CREATION,
        ENVIRON_VAR,
        CONFIG_FILE,
        MANAGEMENT,
        ERGONOMIC,
        OTHER;

    }
}

