/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.TMSchema;
import com.sun.java.swing.plaf.windows.WindowsBorders;
import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import sun.swing.DefaultLookup;
import sun.swing.StringUIClientPropertyKey;

public class WindowsComboBoxUI
extends BasicComboBoxUI {
    private static final MouseListener rolloverListener = new MouseAdapter(){

        private void handleRollover(MouseEvent e, boolean isRollover) {
            JComboBox comboBox = this.getComboBox(e);
            WindowsComboBoxUI comboBoxUI = this.getWindowsComboBoxUI(e);
            if (comboBox == null || comboBoxUI == null) {
                return;
            }
            if (!comboBox.isEditable()) {
                ButtonModel m = null;
                if (comboBoxUI.arrowButton != null) {
                    m = comboBoxUI.arrowButton.getModel();
                }
                if (m != null) {
                    m.setRollover(isRollover);
                }
            }
            comboBoxUI.isRollover = isRollover;
            comboBox.repaint();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.handleRollover(e, true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.handleRollover(e, false);
        }

        private JComboBox getComboBox(MouseEvent event) {
            Object source = event.getSource();
            JComboBox rv = null;
            if (source instanceof JComboBox) {
                rv = (JComboBox)source;
            } else if (source instanceof XPComboBoxButton) {
                rv = ((XPComboBoxButton)source).getWindowsComboBoxUI().comboBox;
            }
            return rv;
        }

        private WindowsComboBoxUI getWindowsComboBoxUI(MouseEvent event) {
            JComboBox comboBox = this.getComboBox(event);
            WindowsComboBoxUI rv = null;
            if (comboBox != null && comboBox.getUI() instanceof WindowsComboBoxUI) {
                rv = (WindowsComboBoxUI)comboBox.getUI();
            }
            return rv;
        }
    };
    private boolean isRollover = false;
    private static final PropertyChangeListener componentOrientationListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            JComboBox comboBox;
            WindowsComboBoxUI comboBoxUI;
            String propertyName = e.getPropertyName();
            Object source = null;
            if ("componentOrientation" == propertyName && (source = e.getSource()) instanceof JComboBox && ((JComboBox)source).getUI() instanceof WindowsComboBoxUI && (comboBoxUI = (WindowsComboBoxUI)(comboBox = (JComboBox)source).getUI()).arrowButton instanceof XPComboBoxButton) {
                ((XPComboBoxButton)comboBoxUI.arrowButton).setPart(comboBox.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT ? TMSchema.Part.CP_DROPDOWNBUTTONLEFT : TMSchema.Part.CP_DROPDOWNBUTTONRIGHT);
            }
        }
    };

    public static ComponentUI createUI(JComponent c) {
        return new WindowsComboBoxUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.isRollover = false;
        this.comboBox.setRequestFocusEnabled(true);
        if (XPStyle.getXP() != null && this.arrowButton != null) {
            this.comboBox.addMouseListener(rolloverListener);
            this.arrowButton.addMouseListener(rolloverListener);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.comboBox.removeMouseListener(rolloverListener);
        if (this.arrowButton != null) {
            this.arrowButton.removeMouseListener(rolloverListener);
        }
        super.uninstallUI(c);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        XPStyle xp = XPStyle.getXP();
        if (xp != null && xp.isSkinDefined(this.comboBox, TMSchema.Part.CP_DROPDOWNBUTTONRIGHT)) {
            this.comboBox.addPropertyChangeListener("componentOrientation", componentOrientationListener);
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.comboBox.removePropertyChangeListener("componentOrientation", componentOrientationListener);
    }

    @Override
    protected void configureEditor() {
        super.configureEditor();
        if (XPStyle.getXP() != null) {
            this.editor.addMouseListener(rolloverListener);
        }
    }

    @Override
    protected void unconfigureEditor() {
        super.unconfigureEditor();
        this.editor.removeMouseListener(rolloverListener);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (XPStyle.getXP() != null) {
            this.paintXPComboBoxBackground(g, c);
        }
        super.paint(g, c);
    }

    TMSchema.State getXPComboBoxState(JComponent c) {
        TMSchema.State state = TMSchema.State.NORMAL;
        if (!c.isEnabled()) {
            state = TMSchema.State.DISABLED;
        } else if (this.isPopupVisible(this.comboBox)) {
            state = TMSchema.State.PRESSED;
        } else if (this.isRollover) {
            state = TMSchema.State.HOT;
        }
        return state;
    }

    private void paintXPComboBoxBackground(Graphics g, JComponent c) {
        XPStyle xp = XPStyle.getXP();
        if (xp == null) {
            return;
        }
        TMSchema.State state = this.getXPComboBoxState(c);
        XPStyle.Skin skin = null;
        if (!this.comboBox.isEditable() && xp.isSkinDefined(c, TMSchema.Part.CP_READONLY)) {
            skin = xp.getSkin(c, TMSchema.Part.CP_READONLY);
        }
        if (skin == null) {
            skin = xp.getSkin(c, TMSchema.Part.CP_COMBOBOX);
        }
        skin.paintSkin(g, 0, 0, c.getWidth(), c.getHeight(), state);
    }

    @Override
    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        XPStyle xp = XPStyle.getXP();
        if (xp != null) {
            bounds.x += 2;
            bounds.y += 2;
            bounds.width -= 4;
            bounds.height -= 4;
        } else {
            ++bounds.x;
            ++bounds.y;
            bounds.width -= 2;
            bounds.height -= 2;
        }
        if (!this.comboBox.isEditable() && xp != null && xp.isSkinDefined(this.comboBox, TMSchema.Part.CP_READONLY)) {
            ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
            Component c = hasFocus && !this.isPopupVisible(this.comboBox) ? renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, true, false) : renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
            c.setFont(this.comboBox.getFont());
            if (this.comboBox.isEnabled()) {
                c.setForeground(this.comboBox.getForeground());
                c.setBackground(this.comboBox.getBackground());
            } else {
                c.setForeground(DefaultLookup.getColor(this.comboBox, this, "ComboBox.disabledForeground", null));
                c.setBackground(DefaultLookup.getColor(this.comboBox, this, "ComboBox.disabledBackground", null));
            }
            boolean shouldValidate = false;
            if (c instanceof JPanel) {
                shouldValidate = true;
            }
            this.currentValuePane.paintComponent(g, c, this.comboBox, bounds.x, bounds.y, bounds.width, bounds.height, shouldValidate);
        } else {
            super.paintCurrentValue(g, bounds, hasFocus);
        }
    }

    @Override
    public void paintCurrentValueBackground(Graphics g, Rectangle bounds, boolean hasFocus) {
        if (XPStyle.getXP() == null) {
            super.paintCurrentValueBackground(g, bounds, hasFocus);
        }
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        Dimension d = super.getMinimumSize(c);
        d.width = XPStyle.getXP() != null ? (d.width += 5) : (d.width += 4);
        d.height += 2;
        return d;
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new BasicComboBoxUI.ComboBoxLayoutManager(){

            @Override
            public void layoutContainer(Container parent) {
                super.layoutContainer(parent);
                if (XPStyle.getXP() != null && WindowsComboBoxUI.this.arrowButton != null) {
                    Dimension d = parent.getSize();
                    Insets insets = WindowsComboBoxUI.this.getInsets();
                    int buttonWidth = ((WindowsComboBoxUI)WindowsComboBoxUI.this).arrowButton.getPreferredSize().width;
                    WindowsComboBoxUI.this.arrowButton.setBounds(WindowsGraphicsUtils.isLeftToRight((JComboBox)parent) ? d.width - insets.right - buttonWidth : insets.left, insets.top, buttonWidth, d.height - insets.top - insets.bottom);
                }
            }
        };
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
    }

    @Override
    protected ComboPopup createPopup() {
        return super.createPopup();
    }

    @Override
    protected ComboBoxEditor createEditor() {
        return new WindowsComboBoxEditor();
    }

    protected ListCellRenderer createRenderer() {
        XPStyle xp = XPStyle.getXP();
        if (xp != null && xp.isSkinDefined(this.comboBox, TMSchema.Part.CP_READONLY)) {
            return new WindowsComboBoxRenderer();
        }
        return super.createRenderer();
    }

    @Override
    protected JButton createArrowButton() {
        XPStyle xp = XPStyle.getXP();
        if (xp != null) {
            return new XPComboBoxButton(xp);
        }
        return super.createArrowButton();
    }

    private static class WindowsComboBoxRenderer
    extends BasicComboBoxRenderer.UIResource {
        private static final Object BORDER_KEY = new StringUIClientPropertyKey("BORDER_KEY");
        private static final Border NULL_BORDER = new EmptyBorder(0, 0, 0, 0);

        private WindowsComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component rv = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (rv instanceof JComponent) {
                JComponent component = (JComponent)rv;
                if (index == -1 && isSelected) {
                    Border border = component.getBorder();
                    WindowsBorders.DashedBorder dashedBorder = new WindowsBorders.DashedBorder(list.getForeground());
                    component.setBorder(dashedBorder);
                    if (component.getClientProperty(BORDER_KEY) == null) {
                        component.putClientProperty(BORDER_KEY, border == null ? NULL_BORDER : border);
                    }
                } else if (component.getBorder() instanceof WindowsBorders.DashedBorder) {
                    Object storedBorder = component.getClientProperty(BORDER_KEY);
                    if (storedBorder instanceof Border) {
                        component.setBorder(storedBorder == NULL_BORDER ? null : (Border)storedBorder);
                    }
                    component.putClientProperty(BORDER_KEY, null);
                }
                if (index == -1) {
                    component.setOpaque(false);
                    component.setForeground(list.getForeground());
                } else {
                    component.setOpaque(true);
                }
            }
            return rv;
        }
    }

    public static class WindowsComboBoxEditor
    extends BasicComboBoxEditor.UIResource {
        @Override
        protected JTextField createEditorComponent() {
            JTextField editor = super.createEditorComponent();
            Border border = (Border)UIManager.get("ComboBox.editorBorder");
            if (border != null) {
                editor.setBorder(border);
            }
            editor.setOpaque(false);
            return editor;
        }

        @Override
        public void setItem(Object item) {
            super.setItem(item);
            Component focus = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (focus == this.editor || focus == this.editor.getParent()) {
                this.editor.selectAll();
            }
        }
    }

    @Deprecated
    protected class WindowsComboPopup
    extends BasicComboPopup {
        public WindowsComboPopup(JComboBox cBox) {
            super(cBox);
        }

        @Override
        protected KeyListener createKeyListener() {
            return new InvocationKeyHandler();
        }

        protected class InvocationKeyHandler
        extends BasicComboPopup.InvocationKeyHandler {
            protected InvocationKeyHandler() {
                super(WindowsComboPopup.this);
            }
        }
    }

    private class XPComboBoxButton
    extends XPStyle.GlyphButton {
        public XPComboBoxButton(XPStyle xp) {
            super(null, !xp.isSkinDefined(WindowsComboBoxUI.this.comboBox, TMSchema.Part.CP_DROPDOWNBUTTONRIGHT) ? TMSchema.Part.CP_DROPDOWNBUTTON : (WindowsComboBoxUI.this.comboBox.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT ? TMSchema.Part.CP_DROPDOWNBUTTONLEFT : TMSchema.Part.CP_DROPDOWNBUTTONRIGHT));
            this.setRequestFocusEnabled(false);
        }

        @Override
        protected TMSchema.State getState() {
            TMSchema.State rv = super.getState();
            XPStyle xp = XPStyle.getXP();
            if (rv != TMSchema.State.DISABLED && WindowsComboBoxUI.this.comboBox != null && !WindowsComboBoxUI.this.comboBox.isEditable() && xp != null && xp.isSkinDefined(WindowsComboBoxUI.this.comboBox, TMSchema.Part.CP_DROPDOWNBUTTONRIGHT)) {
                rv = TMSchema.State.NORMAL;
            }
            return rv;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(17, 21);
        }

        void setPart(TMSchema.Part part) {
            this.setPart(WindowsComboBoxUI.this.comboBox, part);
        }

        WindowsComboBoxUI getWindowsComboBoxUI() {
            return WindowsComboBoxUI.this;
        }
    }
}

