/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.CipherBlockChaining;
import com.sun.crypto.provider.ConstructKeys;
import com.sun.crypto.provider.DESedeCrypt;
import com.sun.crypto.provider.DESedeParameters;
import com.sun.crypto.provider.FeedbackCipher;
import com.sun.crypto.provider.SunJCE;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

public final class DESedeWrapCipher
extends CipherSpi {
    private static final byte[] IV2 = new byte[]{74, -35, -94, 44, 121, -24, 33, 5};
    private static final int CHECKSUM_LEN = 8;
    private static final int IV_LEN = 8;
    private FeedbackCipher cipher = new CipherBlockChaining(new DESedeCrypt());
    private byte[] iv = null;
    private Key cipherKey = null;
    private boolean decrypting = false;

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (!mode.equalsIgnoreCase("CBC")) {
            throw new NoSuchAlgorithmException(mode + " cannot be used");
        }
    }

    @Override
    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        if (!padding.equalsIgnoreCase("NoPadding")) {
            throw new NoSuchPaddingException(padding + " cannot be used");
        }
    }

    @Override
    protected int engineGetBlockSize() {
        return 8;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        int result = 0;
        result = this.decrypting ? inputLen - 16 : Math.addExact(inputLen, 16);
        return result < 0 ? 0 : result;
    }

    @Override
    protected byte[] engineGetIV() {
        return this.iv == null ? null : (byte[])this.iv.clone();
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException iape) {
            InvalidKeyException ike = new InvalidKeyException("Parameters required");
            ike.initCause(iape);
            throw ike;
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        byte[] currIv = null;
        if (opmode == 3) {
            this.decrypting = false;
            if (params == null) {
                this.iv = new byte[8];
                if (random == null) {
                    random = SunJCE.getRandom();
                }
                random.nextBytes(this.iv);
            } else if (params instanceof IvParameterSpec) {
                this.iv = ((IvParameterSpec)params).getIV();
            } else {
                throw new InvalidAlgorithmParameterException("Wrong parameter type: IV expected");
            }
            currIv = this.iv;
        } else if (opmode == 4) {
            if (params != null) {
                throw new InvalidAlgorithmParameterException("No parameter accepted for unwrapping keys");
            }
            this.iv = null;
            this.decrypting = true;
            currIv = IV2;
        } else {
            throw new UnsupportedOperationException("This cipher can only be used for key wrapping and unwrapping");
        }
        this.cipher.init(this.decrypting, key.getAlgorithm(), key.getEncoded(), currIv);
        this.cipherKey = key;
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        IvParameterSpec ivSpec = null;
        if (params != null) {
            try {
                DESedeParameters paramsEng = new DESedeParameters();
                paramsEng.engineInit(params.getEncoded());
                ivSpec = paramsEng.engineGetParameterSpec(IvParameterSpec.class);
            }
            catch (Exception ex) {
                InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException("Wrong parameter type: IV expected");
                iape.initCause(ex);
                throw iape;
            }
        }
        this.engineInit(opmode, key, ivSpec, random);
    }

    @Override
    protected byte[] engineUpdate(byte[] in, int inOffset, int inLen) {
        throw new IllegalStateException("Cipher has not been initialized");
    }

    @Override
    protected int engineUpdate(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) throws ShortBufferException {
        throw new IllegalStateException("Cipher has not been initialized");
    }

    @Override
    protected byte[] engineDoFinal(byte[] in, int inOffset, int inLen) throws IllegalBlockSizeException, BadPaddingException {
        throw new IllegalStateException("Cipher has not been initialized");
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        throw new IllegalStateException("Cipher has not been initialized");
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        AlgorithmParameters params = null;
        if (this.iv != null) {
            String algo = this.cipherKey.getAlgorithm();
            try {
                params = AlgorithmParameters.getInstance(algo, SunJCE.getInstance());
                params.init(new IvParameterSpec(this.iv));
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new RuntimeException("Cannot find " + algo + " AlgorithmParameters implementation in SunJCE provider");
            }
            catch (InvalidParameterSpecException ipse) {
                throw new RuntimeException("IvParameterSpec not supported");
            }
        }
        return params;
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        byte[] encoded = key.getEncoded();
        if (encoded.length != 24) {
            throw new InvalidKeyException("Invalid key length: " + encoded.length + " bytes");
        }
        return 112;
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] keyVal = key.getEncoded();
        if (keyVal == null || keyVal.length == 0) {
            throw new InvalidKeyException("Cannot get an encoding of the key to be wrapped");
        }
        byte[] cks = DESedeWrapCipher.getChecksum(keyVal);
        byte[] in = new byte[Math.addExact(keyVal.length, 8)];
        System.arraycopy(keyVal, 0, in, 0, keyVal.length);
        System.arraycopy(cks, 0, in, keyVal.length, 8);
        byte[] out = new byte[Math.addExact(this.iv.length, in.length)];
        System.arraycopy(this.iv, 0, out, 0, this.iv.length);
        this.cipher.encrypt(in, 0, in.length, out, this.iv.length);
        for (int i = 0; i < out.length / 2; ++i) {
            byte temp = out[i];
            out[i] = out[out.length - 1 - i];
            out[out.length - 1 - i] = temp;
        }
        try {
            this.cipher.init(false, this.cipherKey.getAlgorithm(), this.cipherKey.getEncoded(), IV2);
        }
        catch (InvalidKeyException ike) {
            throw new RuntimeException("Internal cipher key is corrupted");
        }
        byte[] out2 = new byte[out.length];
        this.cipher.encrypt(out, 0, out.length, out2, 0);
        try {
            this.cipher.init(this.decrypting, this.cipherKey.getAlgorithm(), this.cipherKey.getEncoded(), this.iv);
        }
        catch (InvalidKeyException ike) {
            throw new RuntimeException("Internal cipher key is corrupted");
        }
        return out2;
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        if (wrappedKey.length == 0) {
            throw new InvalidKeyException("The wrapped key is empty");
        }
        byte[] buffer = new byte[wrappedKey.length];
        this.cipher.decrypt(wrappedKey, 0, wrappedKey.length, buffer, 0);
        for (int i = 0; i < buffer.length / 2; ++i) {
            byte temp = buffer[i];
            buffer[i] = buffer[buffer.length - 1 - i];
            buffer[buffer.length - 1 - i] = temp;
        }
        this.iv = new byte[8];
        System.arraycopy(buffer, 0, this.iv, 0, this.iv.length);
        this.cipher.init(true, this.cipherKey.getAlgorithm(), this.cipherKey.getEncoded(), this.iv);
        byte[] buffer2 = new byte[buffer.length - this.iv.length];
        this.cipher.decrypt(buffer, this.iv.length, buffer2.length, buffer2, 0);
        int keyValLen = buffer2.length - 8;
        byte[] cks = DESedeWrapCipher.getChecksum(buffer2, 0, keyValLen);
        int offset = keyValLen;
        for (int i = 0; i < 8; ++i) {
            if (buffer2[offset + i] == cks[i]) continue;
            throw new InvalidKeyException("Checksum comparison failed");
        }
        this.cipher.init(this.decrypting, this.cipherKey.getAlgorithm(), this.cipherKey.getEncoded(), IV2);
        byte[] out = new byte[keyValLen];
        System.arraycopy(buffer2, 0, out, 0, keyValLen);
        return ConstructKeys.constructKey(out, wrappedKeyAlgorithm, wrappedKeyType);
    }

    private static final byte[] getChecksum(byte[] in) {
        return DESedeWrapCipher.getChecksum(in, 0, in.length);
    }

    private static final byte[] getChecksum(byte[] in, int offset, int len) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("SHA1 message digest not available");
        }
        md.update(in, offset, len);
        byte[] cks = new byte[8];
        System.arraycopy(md.digest(), 0, cks, 0, cks.length);
        return cks;
    }
}

