/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.draw;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Rand;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Tmp;
import mindustry.entities.part.DrawPart;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.type.Liquid;
import mindustry.world.Block;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.draw.DrawBlock;

public class DrawTurret
extends DrawBlock {
    protected static final Rand rand = new Rand();
    public Seq<DrawPart> parts = new Seq();
    public String basePrefix = "";
    @Nullable
    public Liquid liquidDraw;
    public float turretLayer = 50.0f;
    public float shadowLayer = 49.5f;
    public float heatLayer = 50.1f;
    public TextureRegion base;
    public TextureRegion liquid;
    public TextureRegion top;
    public TextureRegion heat;
    public TextureRegion preview;
    public TextureRegion outline;

    public DrawTurret(String basePrefix) {
        this.basePrefix = basePrefix;
    }

    public DrawTurret() {
    }

    @Override
    public void getRegionsToOutline(Block block, Seq<TextureRegion> out) {
        for (DrawPart part : this.parts) {
            part.getOutlines(out);
        }
        if (block.region.found() && (block.outlinedIcon <= 0 || block.outlinedIcon >= block.getGeneratedIcons().length || !block.getGeneratedIcons()[block.outlinedIcon].equals(block.region))) {
            out.add(block.region);
        }
        block.resetGeneratedIcons();
    }

    @Override
    public void drawPlan(Block block, BuildPlan plan, Eachable<BuildPlan> list) {
        Draw.rect(this.base, plan.drawx(), plan.drawy());
        Draw.rect(this.preview, plan.drawx(), plan.drawy(), block.rotate ? (float)plan.rotation * 90.0f - 90.0f : 0.0f);
    }

    @Override
    public void draw(Building build) {
        Turret turret = (Turret)build.block;
        Turret.TurretBuild tb = (Turret.TurretBuild)build;
        Draw.rect(this.base, build.x, build.y);
        Draw.color();
        Draw.z(this.shadowLayer);
        Drawf.shadow(this.preview, build.x + tb.recoilOffset.x - turret.elevation, build.y + tb.recoilOffset.y - turret.elevation, tb.drawrot());
        Draw.z(this.turretLayer);
        this.drawTurret(turret, tb);
        this.drawHeat(turret, tb);
        if (this.parts.size > 0) {
            if (this.outline.found()) {
                Draw.z(this.turretLayer - 0.01f);
                Draw.rect(this.outline, build.x + tb.recoilOffset.x, build.y + tb.recoilOffset.y, tb.drawrot());
                Draw.z(this.turretLayer);
            }
            float progress = tb.progress();
            DrawPart.PartParams params = DrawPart.params.set(build.warmup(), 1.0f - progress, 1.0f - progress, tb.heat, tb.curRecoil, tb.charge, tb.x + tb.recoilOffset.x, tb.y + tb.recoilOffset.y, tb.rotation);
            for (DrawPart part : this.parts) {
                params.setRecoil(part.recoilIndex >= 0 && tb.curRecoils != null ? tb.curRecoils[part.recoilIndex] : tb.curRecoil);
                part.draw(params);
            }
        }
    }

    public void drawTurret(Turret block, Turret.TurretBuild build) {
        if (block.region.found()) {
            Draw.rect(block.region, build.x + build.recoilOffset.x, build.y + build.recoilOffset.y, build.drawrot());
        }
        if (this.liquid.found()) {
            Liquid toDraw = this.liquidDraw == null ? build.liquids.current() : this.liquidDraw;
            Drawf.liquid(this.liquid, build.x + build.recoilOffset.x, build.y + build.recoilOffset.y, build.liquids.get(toDraw) / block.liquidCapacity, toDraw.color.write(Tmp.c1).a(1.0f), build.drawrot());
        }
        if (this.top.found()) {
            Draw.rect(this.top, build.x + build.recoilOffset.x, build.y + build.recoilOffset.y, build.drawrot());
        }
    }

    public void drawHeat(Turret block, Turret.TurretBuild build) {
        if (build.heat <= 1.0E-5f || !this.heat.found()) {
            return;
        }
        Drawf.additive(this.heat, block.heatColor.write(Tmp.c1).a(build.heat), build.x + build.recoilOffset.x, build.y + build.recoilOffset.y, build.drawrot(), this.heatLayer);
    }

    @Override
    public void load(Block block) {
        if (!(block instanceof Turret)) {
            throw new ClassCastException("This drawer can only be used on turrets.");
        }
        this.preview = Core.atlas.find(block.name + "-preview", block.region);
        this.outline = Core.atlas.find(block.name + "-outline");
        this.liquid = Core.atlas.find(block.name + "-liquid");
        this.top = Core.atlas.find(block.name + "-top");
        this.heat = Core.atlas.find(block.name + "-heat");
        this.base = Core.atlas.find(block.name + "-base");
        for (DrawPart part : this.parts) {
            part.turretShading = true;
            part.load(block.name);
        }
        if (!this.base.found() && block.minfo.mod != null) {
            this.base = Core.atlas.find(block.minfo.mod.name + "-" + this.basePrefix + "block-" + block.size);
        }
        if (!this.base.found()) {
            this.base = Core.atlas.find(this.basePrefix + "block-" + block.size);
        }
    }

    @Override
    public TextureRegion[] icons(Block block) {
        TextureRegion[] textureRegionArray;
        if (this.top.found()) {
            TextureRegion[] textureRegionArray2 = new TextureRegion[3];
            textureRegionArray2[0] = this.base;
            textureRegionArray2[1] = this.preview;
            textureRegionArray = textureRegionArray2;
            textureRegionArray2[2] = this.top;
        } else {
            TextureRegion[] textureRegionArray3 = new TextureRegion[2];
            textureRegionArray3[0] = this.base;
            textureRegionArray = textureRegionArray3;
            textureRegionArray3[1] = this.preview;
        }
        return textureRegionArray;
    }
}

